Imports NetShopForge.Library.Product
Partial Class Shop_Product_Controls_ProductAttributeControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        LoadControls()

    End Sub

    Private _selectedAttributeCollecion As ProductAttributeCollection
    Private _ProductInfo As ProductInfo

    Public Property Product() As ProductInfo
        Get
            Return _ProductInfo
        End Get
        Set(ByVal value As ProductInfo)
            _ProductInfo = value
        End Set
    End Property




    Public Property SelectedProductAttributeCollection() As ProductAttributeCollection
        Get

            'loop through the controls and 
            'create an attribute selection from them
            Dim selectedAttribute As ProductAttributeInfo
            Dim selection As ProductAttributeSelection
            Dim priceAdjustment As Decimal = 0

            If Not _ProductInfo.ProductAttributeCollection Is Nothing Then
                For Each att As ProductAttributeInfo In _ProductInfo.ProductAttributeCollection
                    'pull the control out
                    'and set the values/price adjustments
                    selectedAttribute = New ProductAttributeInfo
                    selectedAttribute.SelectionType = att.SelectionType
                    selectedAttribute.Selections = New System.Collections.Generic.List(Of ProductAttributeSelection)
                    selectedAttribute.Name = att.Name
                    selectedAttribute.Description = att.Description

                    'based on the type, pull out the selection
                    Select Case att.SelectionType
                        Case ProductAttributeType.SingleSelection
                            Dim ddl As DropDownList = CType(pnlAttControls.FindControl(att.Name), DropDownList)
                            selection = New ProductAttributeSelection

                            selection.Value = ddl.SelectedValue
                            selection.PriceAdjustment = att.GetPriceAdjustment(selection.Value)
                            selectedAttribute.Selections.Add(selection)
                        Case ProductAttributeType.MultipleSelection
                            Dim chk As CheckBoxList = CType(pnlAttControls.FindControl(att.Name), CheckBoxList)
                            For Each item As ListItem In chk.Items
                                If item.Selected Then
                                    selection = New ProductAttributeSelection
                                    selection.Value = item.Value
                                    selection.PriceAdjustment = att.GetPriceAdjustment(selection.Value)
                                    selectedAttribute.Selections.Add(selection)
                                End If
                            Next item
                        Case ProductAttributeType.UserInput
                            Dim t As TextBox = CType(pnlAttControls.FindControl(att.Name), TextBox)
                            selection = New ProductAttributeSelection()

                            selection.Value = t.Text
                            selectedAttribute.Selections.Add(selection)
                        Case Else
                    End Select
                    _selectedAttributeCollecion.Add(selectedAttribute)
                Next att
            End If


            Return _selectedAttributeCollecion

        End Get
        Set(ByVal value As ProductAttributeCollection)
            _selectedAttributeCollecion = value
        End Set
    End Property




    Private Sub LoadControls()
        Dim tbl As HtmlTable = New HtmlTable()
        tbl.ID = "optionzone"
        tbl.ID = "lips"
        Dim tr As HtmlTableRow
        Dim td As HtmlTableCell
        Dim indexer As Integer = 0

        If Not _ProductInfo.ProductAttributeCollection Is Nothing Then
            _selectedAttributeCollecion = New ProductAttributeCollection
            For Each att As ProductAttributeInfo In _ProductInfo.ProductAttributeCollection
                tr = New HtmlTableRow()
                td = New HtmlTableCell()

                Dim lblSingle As Label = New Label()
                lblSingle.Width = Unit.Pixel(50)

                'lblSingle.Style.Add("width", "500px")
                lblSingle.Text = "" & att.Name & ": &nbsp;"
                If att.Description <> String.Empty Then
                    lblSingle.ToolTip = att.Description
                End If
                lblSingle.ID = "lbl" & att.Name + indexer.ToString()
                td.Controls.Add(lblSingle)
                indexer += 1
                Select Case att.SelectionType
                    Case ProductAttributeType.SingleSelection
                        '  lblSingle.Text &= 
                        Dim ddl As DropDownList = New DropDownList()
                        ddl.ID = att.Name
                        ddl.DataSource = att.Selections
                        ddl.DataTextField = "FormattedValue"
                        ddl.DataValueField = "Value"
                        ddl.DataBind()
                        ddl.SelectedIndex = 0
                        td.Controls.Add(ddl)

                    Case ProductAttributeType.MultipleSelection
                        '  lblSingle.Text &= "<br>"
                        Dim chkList As CheckBoxList = New CheckBoxList()
                        chkList.ID = att.Name
                        chkList.DataSource = att.Selections
                        chkList.DataTextField = "FormattedValue"
                        chkList.DataValueField = "Value"
                        chkList.DataBind()
                        td.Controls.Add(chkList)
                    Case ProductAttributeType.UserInput
                        '  lblSingle.Text &= "<br>"
                        Dim t As TextBox = New TextBox()
                        t.ID = att.Name
                        t.TextMode = TextBoxMode.MultiLine
                        t.Height = Unit.Pixel(80)
                        t.Width = Unit.Pixel(120)
                        td.Controls.Add(t)

                End Select
                tr.Cells.Add(td)
                tbl.Rows.Add(tr)
            Next att
            pnlAttControls.Controls.Add(tbl)
        End If
    End Sub

End Class
