
Imports NetShopForge.Library.Product
Imports NetShopForge.Library.Cart
Partial Class Shop_Product_Controls_ProductDetailControl
    Inherits System.Web.UI.UserControl


    Public objProduct As ProductInfo
    Public NormalImagePath As String

    'Public Const sRecommend As String = "<b>{0}</b>of<b>{1}</b>({2:p})of customers said they would recommend this product to a friend."
    'Public Const sReviewLinkNo As String = "Ϊһ<a  href=""ProductReview.aspx?pID={0}"">д</a>."
    ' Public Const sReviewLinkHas As String = "<a  href=""ProductReview.aspx?pID={0}"">Write an online review</a> and share your thoughts with other customers."
    Public sReadeReview As String = "<a  href=""{0}"">鿴ȫ</a> "
    Public Const sPriceCaption As String = "ǵļ۸:"
    Public Const sListPriceCation As String = "г:"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not Page.IsPostBack Then
            ' If Not IsNothing(ProductID) Then BindData(CInt(ProductID))
            Dim thisPath As String = Request.Url.LocalPath
            Dim PageName As String = System.IO.Path.GetFileName(thisPath)

            lbListPriceCaption.Text = sListPriceCation
            lbPriceCaption.Text = sPriceCaption
            BindData()
            If PageName = "ProductDetail.aspx" Then
                ProductSpcialOfferControl1.CategoryID = objProduct.CategoryID
                ProductSpcialOfferControl1.ProductID = objProduct.ProductID
            End If
      
        End If
        ProductAttributeControl1.Product = objProduct

    End Sub

#Region "---DataBind---"
    Private Sub BindData()
        'bind image
        'BindProductImage(objProduct.ThumbImagePath, objProduct.ProductName)
        'bind details
        '  ProductDescriptionControl1.ProductDescription = objProduct.Description

        lbProductName.Text = objProduct.ProductName
        lbProductCode.Text = "#" & objProduct.ProductCode
        lbListPrice.Text = String.Format("{0:c}", objProduct.ListPrice)
        lbPrice.Text = String.Format("{0:c}", objProduct.Price)
        hfPrice.Value = objProduct.Price
        hfImagePath.Value = objProduct.ImagePath

        ' ProductOptionControl1.ProductID = objProduct.ProductID
        ProductAttributeControl1.Product = objProduct
        BindProductMultipleView(objProduct.ProductID)

        'Bind Product Rationg
        BindRationg(objProduct.ProductID)
        hfProductID.Value = objProduct.ProductID
    End Sub


    Private Sub BindRationg(ByVal productID As Integer)
        Dim thisPath As String = Request.Url.LocalPath
        Dim PageName As String = System.IO.Path.GetFileName(thisPath)
        If PageName = "ProductDetail.aspx" Then
            Dim pr As ProductRatingInfo = ProductController.GetProductRating(productID)

            If pr.RatingQty = 0 Then
                ReviewLinkNo.Text = String.Format(Global.Resources.GlobalResources.PRODUCT_REVIEW_REVIEWLINKNO, productID)
                mvRating.ActiveViewIndex = 1
            Else
                ReviewLinkHas.Text = String.Format(Global.Resources.GlobalResources.PRODUCT_REVIEW_REVIEWLINKHAS, productID)
                Rater1.DisplayValue = Decimal.Round(pr.Rating)
                Recommend.Text = String.Format(Global.Resources.GlobalResources.PRODUCT_REVIEW_RECOMMENDTOFRIEND, pr.RecommendQty, pr.RatingQty, pr.RecommendQty / pr.RatingQty)
                ReadeReview.Text = String.Format(sReadeReview, Request.RawUrl & "#aReview")
                rating.Text = String.Format(":{0:F}% ", (pr.Rating / 5) * 100)
                mvRating.ActiveViewIndex = 0
            End If
        End If

    End Sub



    Protected Sub BindProductMultipleView(ByVal productID As Integer)

        Dim pmvList As Generic.List(Of ProductImageInfo)
        Dim pic As New ProductImageController
        pmvList = pic.GetProductImageList(productID, ProductImageType.MultipleView)
        If pmvList.Count > 0 Then
            dlMultipleView.Visible = True
            Dim p As New ProductImageInfo
            p.ImagePath = NormalImagePath

            pmvList.Insert(0, p)
            dlMultipleView.DataSource = pmvList
            dlMultipleView.DataBind()
        Else
            dlMultipleView.Visible = False
        End If

    End Sub

#End Region

    Protected Sub btnAddToCart_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btnAddToCart.Click
        Dim objSCInfo As New CartInfo

        objSCInfo.ProductID = hfProductID.Value
        objSCInfo.ProductName = lbProductName.Text
        objSCInfo.ImagePath = hfImagePath.Value  'path.Substring(0, pos)
        objSCInfo.UnitPrice = Decimal.Parse(hfPrice.Value)

        '  Dim txtQty As TextBox =  tCType(rpOption.Controls(0).FindControl("txtQty"), TextBox)
        If IsNumeric(txtQty.Text) Then
            objSCInfo.Quantity = Integer.Parse(txtQty.Text)
        Else
            objSCInfo.Quantity = 1
        End If

        Dim attributeCollection As ProductAttributeCollection = ProductAttributeControl1.SelectedProductAttributeCollection
        If Not IsNothing(attributeCollection) Then
         
            For Each att As ProductAttributeInfo In attributeCollection
                For Each sel As ProductAttributeSelection In att.Selections
                    If sel.PriceAdjustment <> 0 Then
                        objSCInfo.UnitPrice += sel.PriceAdjustment
                    End If

                Next sel
            Next att

            objSCInfo.Options = attributeCollection.ToString
        Else
            objSCInfo.Options = ""
        End If

        ' If IsNothing(Profile.ShoppingCart) Then Profile.ShoppingCart = New Cart

        Profile.ShoppingCart.Add(objSCInfo)
        '  cart.Add(My.User.Name, objSCInfo)
        '  Profile.ShoppingCart.AddShoppingCart(objSCInfo)
        'Redirect to prevent duplictations in the cart if user hits "Refresh"

        My.Response.Redirect("~/MiniCart.aspx", True)
    End Sub

    Protected Sub btnAddToWishList_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btnAddToWishList.Click
        Dim URL As String = String.Format("~/User.aspx?mode=wishlist&pID={0}", hfProductID.Value)
        My.Response.Redirect(URL)
    End Sub

    Protected Sub btnEmailToFriedn_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btnEmailToFriedn.Click
        Dim URL As String = String.Format("~/SendEmail.aspx?pID={0}", hfProductID.Value)
        My.Response.Redirect(URL)
    End Sub
End Class
