
Imports NetShopForge.Library.Product

Partial Class Shop_Product_Controls_ProductReviewControl
    Inherits System.Web.UI.UserControl


    Private Sub BindData()

        Dim objPR As ProductReviewInfo = ProductReviewController.GetProductReview(hfProductID.Value, My.User.Name)

        If IsNothing(objPR) Then
            mvReview.ActiveViewIndex = 0
        Else
            lbFinishMessage.Text = "˼ƷѾ۹ˡϢ"
            mvReview.ActiveViewIndex = 2
            SetProductReview(objPR)
            pReviewed.Visible = True
        End If
    End Sub



    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        hfProductID.Value = NetShopForge.Common.Utility.GetParameter("pID")
        Dim URL As String = String.Format("~/ProductDetail.aspx?pID={0}", hfProductID.Value)
        NetShopForge.Common.UserAuthenticated(Page, URL)

        If (Not Page.IsPostBack) Then
            Dim ProductName As String = NetShopForge.Common.Utility.GetParameter("ProductName")
            lbProductName.Text = HttpUtility.UrlDecode(ProductName)
            hlBackProduct.NavigateUrl = String.Format("~/ProductDetail.aspx?pID={0}", hfProductID.Value)
            pReviewed.Visible = False
            BindData()
        Else

        End If

    End Sub

    Protected Sub btnReview_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnReview.Click
        rvRating.DisplayValue = Rater1.Value
        mvReview.ActiveViewIndex = 1
    End Sub

    Protected Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnEdit.Click
        mvReview.ActiveViewIndex = 0
    End Sub

    Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        mvReview.ActiveViewIndex = 2
        lbFinishMessage.Text = "Ѿȡ"
    End Sub

    Protected Sub btnSubmit_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSubmit.Click
        mvReview.ActiveViewIndex = 2
        ProductReviewController.AddProductReview(GetProductReview())
        lbFinishMessage.Text = "ݽύ72Сʱ֮ڱˡлĲۡ"
    End Sub



    Private Sub SetProductReview(ByVal pr As ProductReviewInfo)

        txtComments.Text = pr.Comments
        txtLocation.Text = pr.Location
        txtReviewer.Text = pr.ReviewerName
        rvRating.DisplayValue = CDbl(pr.Rating)
        Rater2.DisplayValue = CDbl(pr.Rating)
        txtTitle.Text = pr.Title
        rbComment.SelectedValue = IIf(pr.IsRecommend, -1, 0)
        hfReviewDate.Value = String.Format("{0:f}", pr.ReviewDate)
    End Sub


    Private Function GetProductReview() As ProductReviewInfo

        Dim pr As New ProductReviewInfo

        pr.IsApproved = False
        pr.IsRecommend = IIf(rbComment.SelectedValue = 0, False, True)
        pr.Comments = txtComments.Text
        pr.Location = txtLocation.Text
        pr.ProductID = hfProductID.Value
        pr.ReviewerName = txtReviewer.Text
        pr.Rating = Rater1.Value
        pr.Title = txtTitle.Text
        pr.UserID = My.User.Name

        Return pr

    End Function

    Protected Sub Button1_Click1(ByVal sender As Object, ByVal e As System.EventArgs) Handles Button1.Click
        mvReview.ActiveViewIndex = 2
        lbFinishMessage.Text = "Ѿȡ"
    End Sub
End Class
