Imports NetShopForge.Library.SpecialOffer
Partial Class Shop_Product_ProductSpcialOfferControl
    Inherits System.Web.UI.UserControl


    Public ProductID As Integer
    Public CategoryID As Integer
    Public SpecialList As Generic.List(Of SpecialOfferInfo)

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then

            If ProductID = 0 Then
                Me.Visible = False
                Exit Sub
            End If


            Dim spIDs As String = SpecialOfferController.GetAvailableSpecialOfferString(ProductID, "P")
            If spIDs.Length > 0 Then
                SpecialList = SpecialOfferController.GetSpecialOfferList(New String() {spIDs.ToString})
            Else
                Me.Visible = False
                Exit Sub
            End If

            If SpecialList.Count = 0 Then
                Me.Visible = False
                Exit Sub
            Else
                BindData(SpecialList)
            End If

        End If

    End Sub

    Private Sub BindData(ByVal sList As Generic.List(Of SpecialOfferInfo))
        Dim sb As New StringBuilder
        sb.Append(String.Format("<a  href=""{0}"">", Page.ResolveUrl("~/promotion.aspx?pID=" & ProductID)))
        Dim div As String = "<div>{0}</div>"
        Dim j As Integer = sList.Count
        If j > 3 Then j = 3
        For i As Integer = 0 To j - 1
            Dim objSP As SpecialOfferInfo = sList.Item(i)
            If objSP.ShortPromoText.Length > 0 Then
                sb.Append(String.Format(div, objSP.ShortPromoText))
            Else
                sb.Append(String.Format(div, objSP.Title))
            End If

            If objSP.ShortPromoImage.Length > 0 Then

                Dim img As String = String.Format("<img src=""{0}"" border=""0"">", Page.ResolveUrl("~/" & objSP.ShortPromoImage))
                sb.Append(img)
            End If
        Next
        sb.Append("</a>")
        pSpecialOffer.Text = sb.ToString

    End Sub


End Class
