Imports NetShopForge.Library.Address
Partial Class Shop_User_Controls_AddressControl
    Inherits System.Web.UI.UserControl


    Private Sub BindData()
        Dim objAC As New AddressController
        gvAddress.DataSource = objAC.GetAddressList(My.User.Name)
        gvAddress.DataBind()

    End Sub

    Private Function GetAddressInfo(ByVal AddressID As Integer) As AddressInfo
        Dim objAddress As New AddressInfo

        objAddress.FirstName = txtName.Text
        objAddress.LastName = ""

        objAddress.Address1 = txtAddress.Text
        objAddress.Address2 = ""

        objAddress.Province = AreaControl1.Province
        objAddress.City = AreaControl1.City
        objAddress.Country = "CN"
        objAddress.Area = AreaControl1.Area
        objAddress.AreaID = AreaControl1.AreaID
        objAddress.Phone = txtPhone.Text
        objAddress.Zip = txtZipCode.Text
        objAddress.MobilePhone = txtMobilePhone.Text
        objAddress.AddressID = AddressID
        objAddress.UserName = My.User.Name

        Return objAddress

    End Function

    Private Sub SetAddressInfo(ByVal objAddress As AddressInfo)
        txtName.Text = objAddress.FirstName

        txtAddress.Text = objAddress.Address1

        AreaControl1.AreaID = objAddress.AreaID
        txtPhone.Text = objAddress.Phone
        txtZipCode.Text = objAddress.Zip
        txtMobilePhone.Text = objAddress.MobilePhone


    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then

            BindData()

        End If

    End Sub

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click

        Dim objAC As New AddressController
        Dim addressID As Integer = CInt(hfAddressID.Value)
        If addressID = 0 Then
            objAC.AddAddress(GetAddressInfo(addressID))
            ResultMessageControl1.ShowSuccess("ӵַɹ")
        Else
            objAC.UpdateAddress(GetAddressInfo(addressID))
            hfAddressID.Value = 0
            ResultMessageControl1.ShowSuccess("޸ĵַɹ")
        End If

        btnSave.Text = "ӵַ"
        lblTitle.Text = "ӽ׵ַ"
        txtName.Text = ""
        txtAddress.Text = ""
        txtPhone.Text = ""
        txtZipCode.Text = ""
        txtMobilePhone.Text = ""
        AreaControl1.AreaID = ""
        BindData()

    End Sub


    Protected Sub gvAddress_RowDeleting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewDeleteEventArgs) Handles gvAddress.RowDeleting

        Dim objAC As New AddressController
        Dim addressID As Integer = gvAddress.DataKeys(e.RowIndex).Value
        objAC.DeleteAddress(addressID)
        BindData()
    End Sub


    Protected Sub rbDefault_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim rbDefault As RadioButton = CType(sender, RadioButton)
        Dim objAC As New AddressController
        Dim addressID As Integer = rbDefault.GroupName
        objAC.SetDefaultAddress(addressID, My.User.Name)
        BindData()
    End Sub

    Protected Sub gvAddress_RowEditing(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewEditEventArgs) Handles gvAddress.RowEditing
        Dim objAC As New AddressController
        Dim addressID As Integer = gvAddress.DataKeys(e.NewEditIndex).Value
        hfAddressID.Value = addressID
        SetAddressInfo(objAC.GetAddress(addressID))
        btnSave.Text = "޸"
        lblTitle.Text = "༭׵ַ"
        BindData()
    End Sub

End Class
