Imports AspNetProfile = System.Web.Profile
Imports AspNetSecurity = System.Web.Security
Imports NetShopForge.Library.Address

Partial Class Shop_User_Controls_EditUserInfoControl
    Inherits System.Web.UI.UserControl


#Region "----EventArg Method------"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            GetUserInfo(My.User.Name)
        End If
    End Sub

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
        Try
            SaveUserInfo(My.User.Name)
            ResultMessageControl1.ShowSuccess("ʻϢ³ɹ")
        Catch ex As Exception

            ResultMessageControl1.ShowFail("ʻϢʧܣ" & Environment.NewLine & ex.Message)
        End Try

    End Sub

#End Region
  

#Region "----Private Method----"

    Private Sub SaveUserInfo(ByVal userName As String)
        SaveUserInfo(userName, False)
    End Sub
    Private Sub SaveUserInfo(ByVal userName As String, ByVal IsSaveToAddress As Boolean)
        SaveUserInfo(userName, False, False)
    End Sub
    Private Sub SaveUserInfo(ByVal userName As String, ByVal IsSaveToAddress As Boolean, ByVal IsDefaultAddress As Boolean)
        Try

        Catch ex As Exception

        End Try
        Profile.Name = txtName.Text
        Profile.Address = txtAddress.Text
        Profile.State = AreaControl1.Province
        Profile.City = AreaControl1.City
        Profile.ZipCode = txtZipCode.Text
        Profile.Area = AreaControl1.Area
        Profile.AreaID = AreaControl1.AreaID
        AreaControl1.AreaID = Profile.AreaID
        Profile.Phone = txtPhone.Text

        If IsSaveToAddress Then
            Dim objA As New AddressInfo
            Dim objAC As New AddressController
            objA.FirstName = txtName.Text
            objA.Address1 = txtAddress.Text
            objA.Province = AreaControl1.Province
            objA.City = AreaControl1.City
            objA.Area = AreaControl1.Area
            objA.AreaID = AreaControl1.AreaID
            objA.Zip = txtZipCode.Text
            objA.Phone = txtPhone.Text
            objA.IsDefault = IsDefaultAddress
            objAC.AddAddress(objA)

        End If
    End Sub


    Private Sub GetUserInfo(ByVal userName As String)

        txtName.Text = Profile.Name
        txtAddress.Text = Profile.Address
        AreaControl1.AreaID = Profile.AreaID
        txtZipCode.Text = Profile.ZipCode
        txtPhone.Text = Profile.Phone

        Dim mu As MembershipUser = AspNetSecurity.Membership.GetUser(userName)
        txtEmail.Text = mu.Email

    End Sub
    Private Sub UpdateEmail(ByVal userName As String, ByVal email As String)

        Dim mu As MembershipUser = AspNetSecurity.Membership.GetUser(userName)
        mu.Email = email
        If mu.Email <> email Then
            AspNetSecurity.Membership.UpdateUser(mu)
        End If

    End Sub

#End Region



End Class
