Imports AspNetProfile = System.Web.Profile
Imports AspNetSecurity = System.Web.Security
Imports NetShopForge.Library.Address
Imports NetShopForge.Library.WantBuy
Imports NetShopForge.Library.Order

Partial Class Shop_User_Controls_EditWantBuyInfoControl
    Inherits System.Web.UI.UserControl


#Region "----EventArg Method------"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        If Not IsPostBack Then

            Dim action As String = Request("action")
            Dim wantBuyID As Integer = Request("wantbuyID")
            hfWantBuyID.Value = wantBuyID
            If Not IsNothing(action) Then
                Dim a As OrderAction = CInt(action)
          
                BindData(a)

                If a = OrderAction.B_Cancel OrElse a = OrderAction.ViewDetail Then
                    hlOrderCancel.Visible = False
                Else
                    Dim cancelUrl As String = String.Format("{0}?mode=editwantbuy&wantbuyID={1}&action={2}", Page.ResolveUrl("~/User.aspx"), hfWantBuyID.Value, CInt(OrderAction.B_Cancel))
                    hlOrderCancel.NavigateUrl = cancelUrl
                End If


            End If


        End If
    End Sub

    Private Sub BindData(ByVal a As OrderAction)

        Select Case a
            Case OrderAction.B_Cancel
                mvWantBuyItem.ActiveViewIndex = 0
                btnCancel.OnClientClick = "return confirm('ȷҪȡ?');"

            Case OrderAction.ViewDetail

                mvWantBuyItem.ActiveViewIndex = 1
                BindWantBuy()
                btnSave.Visible = False
                txtProductName.Enabled = False
                txtURL.Enabled = False
                txtFeature.Enabled = False
                txtComment.Enabled = False

            Case Else

                mvWantBuyItem.ActiveViewIndex = 1
                BindWantBuy()

        End Select
    End Sub

    Private Sub BindWantBuy()
        BindAddressList(My.User.Name)

        ddlType.Items.Clear()

        Dim j As Integer
        For Each j In [Enum].GetValues(GetType(WantBuyType))
            ddlType.Items.Add(New ListItem(WantBuyController.Instance.GetChineseWantBuyType(j), j))
        Next



        If CInt(hfWantBuyID.Value) = 0 Then
            Caption.Text = "´"
            hfWantBuyID.Value = -1
            txtComment.Text = GetDefaultComment()
        Else
            Caption.Text = "༭"

            BindWantBuyInfo(CInt(hfWantBuyID.Value))
        End If
    End Sub

    Private Function GetDefaultComment() As String

        Dim s As New StringBuilder
        s.Append("----------------------------------------------------" & vbCrLf)
        s.Append("Ʒƣ" & vbCrLf)
        s.Append("Ʒַ:" & vbCrLf)
        s.Append("Ʒ:" & vbCrLf)
        s.Append("----------------------------------------------------" & vbCrLf)
        s.Append("Ʒƣ" & vbCrLf)
        s.Append("Ʒַ:" & vbCrLf)
        s.Append("Ʒ:" & vbCrLf)
        s.Append("----------------------------------------------------" & vbCrLf)
        s.Append("Ʒƣ" & vbCrLf)
        s.Append("Ʒַ:" & vbCrLf)
        s.Append("Ʒ:" & vbCrLf)
        s.Append("----------------------------------------------------" & vbCrLf)
        s.Append("Ʒƣ" & vbCrLf)
        s.Append("Ʒַ:" & vbCrLf)
        s.Append("Ʒ:" & vbCrLf)
        s.Append("----------------------------------------------------" & vbCrLf)
        s.Append("Ʒƣ" & vbCrLf)
        s.Append("Ʒַ:" & vbCrLf)
        s.Append("Ʒ:" & vbCrLf)
        s.Append("----------------------------------------------------" & vbCrLf)
        s.Append("Ʒ" & vbCrLf)

        Return s.ToString
    End Function

    Private Sub BindAddressList(ByVal userName As String)
        Dim objAC As New AddressController
        ' rbAddressList.DataTextFormatString = ""
        For Each address As AddressInfo In objAC.GetAddressList(userName)
            Dim item As New ListItem
            item.Value = address.AddressID
            item.Text = String.Format("{0},{1},{2},{3},{4},{5},{6}/{7}", address.FirstName, address.Province, address.City, address.Area, address.Zip, address.Address1, address.MobilePhone, address.Phone)

            rbAddressList.Items.Add(item)
        Next

    End Sub

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
        Dim wantbuyID As Integer = CInt(hfWantBuyID.Value)
        If wantbuyID = -1 Then
            AddWantBuy()
        Else
            UpdateWantBuy()
        End If

    End Sub

#End Region


#Region "----Private Method----"

    Private Sub AddWantBuy()
        Dim wantBuyID As Integer
        Dim addressID As Integer = GetAddreeID()
        If addressID = -1 Then Exit Sub

        Dim type As WantBuyType = CInt(ddlType.SelectedValue)
        Try
            wantBuyID = WantBuyController.Instance.AddWantBuy(My.User.Name, txtProductName.Text, txtURL.Text, type, txtFeature.Text, txtComment.Text.Replace(vbCrLf, "<br>"), addressID)

            hfWantBuyID.Value = wantBuyID
            Caption.Text = "༭"

            ResultMessageControl1.ShowSuccess("ӳɹ")
        Catch ex As Exception

            ResultMessageControl1.ShowFail("ʧܣ" & Environment.NewLine & ex.Message)

        End Try
    End Sub

    Private Sub UpdateWantBuy()
        Try

            Dim wantbuyid As Integer = CInt(hfWantBuyID.Value)
            Dim addressID As Integer = GetAddreeID()
            If addressID = -1 Then Exit Sub

            WantBuyController.Instance.UpdateWantBuy(wantbuyid, txtProductName.Text, txtURL.Text, CInt(ddlType.SelectedValue), txtFeature.Text, txtComment.Text.Replace(vbCrLf, "<br>"), addressID)
            ResultMessageControl1.ShowSuccess("ӳɹ")
        Catch ex As Exception

            ResultMessageControl1.ShowFail("ʧܣ" & Environment.NewLine & ex.Message)

        End Try
    End Sub

    Private Function GetAddreeID() As Integer

        If rbAddressList.SelectedItem Is Nothing Then
            ResultMessageControl1.ShowFail("ѡַԵ<a href='/Website/User.aspx?mode=address'>׵ַ</a>ã")
            Return -1
        Else
            Return rbAddressList.SelectedValue
        End If

    End Function

    Private Sub BindWantBuyInfo(ByVal wantBuyID As Integer)
        Dim wantbuy As WantBuyInfo = WantBuyController.Instance.GetWantBuy(wantBuyID)
        txtComment.Text = wantbuy.Comment.Replace("<br>", vbCrLf)
        txtFeature.Text = wantbuy.Feature
        txtProductName.Text = wantbuy.ProductName
        txtURL.Text = wantbuy.URL
        ddlType.SelectedValue = CInt(wantbuy.Type)

        For Each Item As ListItem In rbAddressList.Items
            If Item.Value = wantbuy.AddressID Then
                Item.Selected = True
                Exit For
            End If
        Next
    End Sub

#End Region


    Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Dim cancelReason As String = ""
        If rbOthoer.Checked Then
            cancelReason = txtOther.Text
        Else
            cancelReason = rbCancel.SelectedValue
        End If
        ' Dim oc As New OrderController
        Dim wantBuyID As Integer = CInt(hfWantBuyID.Value)
        WantBuyController.Instance.UpdateWantBuyOrderStatus(wantBuyID, OrderStatus.OrderCancelledPriorToShipping)
        Dim ordernote As New OrderNoteInfo
        ordernote.OrderID = wantBuyID
        ordernote.Action = OrderAction.B_Cancel
        ordernote.Note = cancelReason
        ordernote.NoteDate = Now
        ordernote.OrderStatus = OrderStatus.OrderCancelledPriorToShipping
        OrderController.AddOrderNote(ordernote)
        Response.Redirect("~/User.aspx?mode=wantbuy")
    End Sub

    Protected Sub btnBack_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnBack.Click
        Response.Redirect("~/User.aspx?mode=wantbuy")
    End Sub
End Class
