Imports NetShopForge.Library.Order
Imports NetShopForge.Library.Shipping
Imports NetShopForge.Library.Payment

Partial Class Shop_User_OrderItemControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim action As String = Request("action")
            hfOrderID.Value = Request("orderid")

            If Not IsNothing(action) Then
                'Dim OC As New OrderController
                Dim O As OrderInfo = OrderController.GetOrder(CInt(hfOrderID.Value))
                Dim a As OrderAction = CInt(action)
                Dim actions As Generic.List(Of OrderAction) = OrderController.GetOrderActionsForUser(O.OrderStatus)
                If Not actions.Contains(a) Then
                    GoOrderItem()
                Else

                    BindData(O, a)
                    lbTitle.Text = "#" & O.OrderNumber

                    Dim reviewUrl As String = String.Format("{0}?mode=orderitem&orderid={1}&action={2}", Page.ResolveUrl("~/User.aspx"), hfOrderID.Value, CInt(OrderAction.B_Review))

                    hlAddReview.NavigateUrl = reviewUrl


                    If a = OrderAction.B_Cancel OrElse Not (actions.Contains(OrderAction.B_Cancel)) Then

                        hlOrderCancel.Visible = False
                    Else
                        Dim cancelUrl As String = String.Format("{0}?mode=orderitem&orderid={1}&action={2}", Page.ResolveUrl("~/User.aspx"), hfOrderID.Value, CInt(OrderAction.B_Cancel))
                        hlOrderCancel.NavigateUrl = cancelUrl
                    End If
                  
                End If

            End If
        

        End If
    End Sub

#Region " ---Private Method---"

    Private Sub BindData(ByVal O As OrderInfo, ByVal a As OrderAction)
  
        Select Case a
            Case OrderAction.B_Cancel
                mvOrderItem.ActiveViewIndex = 2
                btnCancel.OnClientClick = "return confirm('ȷҪȡ?');"
            Case OrderAction.B_Modify, OrderAction.ViewDetail
                mvOrderItem.ActiveViewIndex = 4
                BindOrderItem(O)
            Case OrderAction.B_Pay
                mvOrderItem.ActiveViewIndex = 1
            Case OrderAction.B_Received
                mvOrderItem.ActiveViewIndex = 0
                BindOrderReview(O)
            Case OrderAction.B_Review
                mvOrderItem.ActiveViewIndex = 3
            Case Else
                mvOrderItem.ActiveViewIndex = 4
                BindOrderItem(O)
        End Select

    End Sub

#Region "BindOrderItem"
    Private Sub BindOrderItem(ByVal O As OrderInfo)
        lbOrderStatus.Text = String.Format("({0})", OrderController.GetChineseOrderStatus(O.OrderStatus))
        Dim objS As ShippingMethodInfo
        Dim objP As PaymentMethodInfo
        Dim objpc As New PaymentController
        objP = objpc.GetPaymentMethodInfo(CInt(O.PaymentMethodID))
        Dim objSC As New ShippingController
        objS = objSC.GetShippingMethod(CInt(O.ShippingMethodID))

        ShippingAddress.Text = GetShippingAddressString(O)
        'ShippingMethod.Text = GetShippingMethodString(objS)
        btnPay.Visible = Not OrderController.IsPay(O.OrderStatus)
        '   OrderController.IsPay()
        PaymentMethod.Text = GetPaymentMethodString(objP)
        BindShippingItem()
        SetFeeInfo(O)
    End Sub

    Private Function GetShippingMethodString(ByVal objS As ShippingMethodInfo) As String

        Dim sbOut As New System.Text.StringBuilder
        sbOut.Append("<table>")
        sbOut.Append(String.Format("<tr><td><b>{0}</b></td></tr><tr><td>ͷ:{1} </td></tr>", objS.ShippingMethodName, String.Format("{0:c}", objS.ShippingPrice)))
        sbOut.Append("<tr><td>" & objS.ShippingMethodDescription & "</td></tr>")
        sbOut.Append("</table>")
        Return sbOut.ToString

    End Function

    Private Function GetPaymentMethodString(ByVal objp As PaymentMethodInfo) As String


        Dim sbOut As New System.Text.StringBuilder
        sbOut.Append("<table>")
        sbOut.Append(String.Format("<tr><td><b>{0} </b></td></tr>", objp.PaymentMethodName))
        sbOut.Append("<tr><td>" & objp.Description & "</td></tr>")
        sbOut.Append("</table>")
        Return sbOut.ToString
    End Function


    Public Function GetShippingAddressString(ByVal O As OrderInfo) As String
        Dim sbOut As New System.Text.StringBuilder
        sbOut.Append("<table>")
        sbOut.Append(String.Format("<tr><td>:<b>{0} {1}</b></td></tr><tr><td>ַ:{2} </td></tr>", O.ShipName, "", O.ShipAddress))
        If (Not String.IsNullOrEmpty(O.ShipAddress2)) Then
            sbOut.Append(String.Format("<tr><td>ַ2:{0}</td></tr>", O.ShipAddress2))
        End If
        sbOut.Append("<tr><td>:" & O.ShipPostalCode & "</td></tr>")
        sbOut.Append(String.Format("<tr><td>:{0},{1},{2}</td></tr>", O.ShipState, O.ShipCity, O.ShipArea))
        sbOut.Append("<tr><td>")
        sbOut.Append(String.Format("绰:{0}  ", O.ShipPhone))
        sbOut.Append("</td></tr>")
        sbOut.Append("</table>")
        Return sbOut.ToString
    End Function

    Private Sub BindShippingItem()
        'bind Product 
        ' Dim OC As New OrderController

        gvItems.DataSource = OrderController.GetOrderDetailList(CInt(hfOrderID.Value))
        gvItems.DataBind()
        
    End Sub

    Private Sub SetFeeInfo(ByVal O As OrderInfo)

        Dim sbOut As New System.Text.StringBuilder
        sbOut.Append("<table border=""0"" cellpadding=""0"" cellspacing=""0"" style=""width: 100%"">")
        sbOut.Append(String.Format("<tr><td style=""width: 120px"">{0}</td><td>{1}</td></tr>", "۸ܼƣ", String.Format("{0:c}", O.ProductSubtotalFee)))
        sbOut.Append(String.Format("<tr><td style=""width: 120px"">{0}</td><td>{1}</td></tr>", "˷ѣ", String.Format("{0:c}", O.ShippingFee)))
        If O.CouponFee > 0 Then sbOut.Append(String.Format("<tr><td style=""width: 120px"">{0}</td><td  style=""color: red;"">{1}</td></tr>", "ۿۣ", String.Format("{0:c}", -O.CouponFee)))
        sbOut.Append("<tr><td align=""left"" class=""ReviewLinks"" colspan=""2"">")
        '  sbOut.Append(" <hr />")
        sbOut.Append(String.Format("{0}{1}</td> </tr>", "ܼƣ", String.Format("{0:c}", O.TotalFee)))
        sbOut.Append("</table>")
        Fee.Text = sbOut.ToString

    End Sub

#End Region

    Private Sub BindOrderReview(ByVal O As OrderInfo)
        ' Dim oc As New OrderController
        Dim noteList As Generic.List(Of OrderNoteInfo)
        noteList = OrderController.GetOrderNoteList(O.OrderID, New OrderAction() {OrderAction.B_Review, OrderAction.S_Review})

        rpOrderReview.DataSource = noteList
        rpOrderReview.DataBind()
    End Sub



#End Region

    
    Protected Sub btnPay_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnPay.Click
        My.Response.Redirect("~/IhttpHandler/PaymentSendHandler.ashx?OrderID=" & hfOrderID.Value)
    End Sub

    Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Dim cancelReason As String = ""
        If rbOthoer.Checked Then
            cancelReason = txtOther.Text
        Else
            cancelReason = rbCancel.SelectedValue
        End If
        ' Dim oc As New OrderController
        Dim orderID As Integer = CInt(hfOrderID.Value)
        OrderController.UpdateOrderStatus(orderID, OrderStatus.OrderCancelledPriorToShipping)
        Dim ordernote As New OrderNoteInfo
        ordernote.Action = OrderAction.B_Cancel
        ordernote.Note = cancelReason
        ordernote.NoteDate = Now
        ordernote.OrderStatus = OrderStatus.OrderCancelledPriorToShipping
        OrderController.AddOrderNote(ordernote)
        GoOrderItem()
    End Sub

    Protected Sub btnBack_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnBack.Click
        GoOrderItem()
    End Sub

    Private Sub GoOrderItem()
        Dim Url As String = String.Format("{0}?mode=orderitem&orderid={1}&action={2}", Page.ResolveUrl("~/User.aspx"), hfOrderID.Value, CInt(OrderAction.ViewDetail))

        My.Response.Redirect(Url)
    End Sub
End Class
