Imports NetShopForge.Library.WantBuy
Imports NetShopForge.Library.Order

Partial Class Shop_User_WantBuyControl
    Inherits System.Web.UI.UserControl

#Region "---Event Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim objOC As New OrderController
            BindData()
            BindSearch()
        End If
    End Sub
    Protected Sub ChangePage(ByVal src As Object, ByVal e As EventArgs) Handles Pager.PageChanged
        BindData()
    End Sub


#End Region

#Region "---Private Method---"

    Private Sub BindData()
        Dim sqlWhere As String = GetSqlWhere()
        ' Dim objOC As New OrderController
        Pager.RecordCount = WantBuyController.Instance.GetWantBuyListNumber(sqlWhere)
        gvWantBuy.DataSource = WantBuyController.Instance.GetWantBuyList(Pager.PageSize, Pager.CurrentPageIndex, sqlWhere)
        gvWantBuy.DataBind()
        Pager.CustomInfoHTML = "¼:" + Pager.RecordCount.ToString()
        Pager.CustomInfoHTML += " ҳ:" + Pager.PageCount.ToString()
        Pager.CustomInfoHTML += " ǰҳ:" + Pager.CurrentPageIndex.ToString()
    End Sub


    Private Sub BindSearch()
        Dim I As Integer
        ddlOrderStatus.Items.Clear()
        ddlOrderStatus.Items.Add(New ListItem("ȫ", -1))
        For Each I In [Enum].GetValues(GetType(OrderStatus))
            ddlOrderStatus.Items.Add(New ListItem(OrderController.GetChineseOrderStatus(I), I))
        Next

        ddlType.Items.Clear()
        'ddlType.Items.Add(New ListItem("ȫ", -1))
        Dim j As Integer
        For Each j In [Enum].GetValues(GetType(WantBuyType))
            ddlType.Items.Add(New ListItem(WantBuyController.Instance.GetChineseWantBuyType(j), j))
        Next

    End Sub

#End Region

    Private Function GetSqlWhere() As String

        If hfSqlWhere.Value.Length > 0 Then
            Return (hfSqlWhere.Value & " AND (UserName='" & My.User.Name.Replace("'", "''") & "')")
        Else
            Return "UserName='" & My.User.Name.Replace("'", "''") & "'"
        End If



    End Function

    Protected Sub gvOrders_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvWantBuy.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim lbOrderStatus As Label = CType(e.Row.FindControl("lbOrderStatus"), Label)
            Dim I As Integer = CInt(lbOrderStatus.Text)
            lbOrderStatus.Text = Order.OrderController.GetChineseOrderStatus(I)
            Dim actions As Generic.List(Of OrderAction) = Order.OrderController.GetOrderActionsForUser(I)
            Dim ac As OrderAction
            Dim sb As New StringBuilder

            For Each ac In actions
                If ac = OrderAction.B_Review Then Continue For
                Dim Text As String = Order.OrderController.GetChineseOrderAction(ac)
                Dim Url As String = String.Format("{0}?mode=editwantbuy&wantbuyID={1}&action={2}", Page.ResolveUrl("~/User.aspx"), gvWantBuy.DataKeys(e.Row.RowIndex).Value, CInt(ac))
                sb.Append(String.Format("<a href =""{1}"">{0}</a>   ", Text, Url))
            Next

            Dim Operation As Literal = CType(e.Row.FindControl("Operation"), Literal)

            Operation.Text = sb.ToString


        End If
    End Sub

    Protected Sub btnSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSearch.Click
        hfSqlWhere.Value = "1=1"

        If ddlOrderStatus.SelectedIndex <> 0 Then
            hfSqlWhere.Value = String.Format("{0} AND (OrderStatus={1}) ", hfSqlWhere.Value.ToString, ddlOrderStatus.SelectedValue)
        End If

        If ddlType.SelectedIndex <> 0 Then
            hfSqlWhere.Value = String.Format("{0} AND (Type={1}) ", hfSqlWhere.Value.ToString, ddlType.SelectedValue)
        End If
        BindData()

    End Sub

    Protected Sub btnAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddNew.Click
        Response.Redirect("~/user.aspx?mode=editwantbuy&action=11")
    End Sub
End Class
