Imports NetShopForge.Library.WishList
Imports NetShopForge.Library.Product
Partial Class Shop_User_Controls_WishListControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then

            Dim pID As String = Request("pID")
            If Not IsNothing(pID) Then
                WishController.AddProductReview(CInt(pID), My.User.Name)
            End If
            BindData()

        End If
    End Sub


    Private Sub BindData()
        gvWish.DataSource = WishController.GetWishList(My.User.Name)
        gvWish.DataBind()
    End Sub






    Protected Sub gvWish_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvWish.RowDataBound

        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim btnAddToCart As Button = CType(e.Row.FindControl("btnAddToCart"), Button)
            Dim pID As Integer = CInt(gvWish.DataKeys(e.Row.RowIndex).Item("ProductID"))
            If ProductController.HasProductOption(pID) Then
                btnAddToCart.CommandArgument = String.Format("{0}|1", pID.ToString)
                btnAddToCart.Text = "鿴ϸ"
            Else
                btnAddToCart.CommandArgument = String.Format("{0}|0", pID.ToString)
                btnAddToCart.Text = "빺복"
            End If


        End If

    End Sub

    Protected Sub btnAddToCart_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim keys As String() = CType(sender, Button).CommandArgument.Split("|")

        Dim pID As Integer = CInt(keys(0))
        Dim b As Boolean = CBool(keys(1))

        If b Then
            My.Response.Redirect(String.Format("~/ProductDetail.aspx?pID={0}", pID.ToString))
        Else
            Profile.ShoppingCart.Add(pID)
            Dim msg As String = "ɹ빺ﳵ! 鿴<a href=""Cart.aspx"">ﳵ</a>"
            ResultMessageControl1.ShowSuccess(msg)
        End If
    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim wishID As Integer = CInt(CType(sender, Button).CommandArgument)
        WishController.DeleteProductReview(wishID)
        BindData()
    End Sub

    Protected Sub btnDeleteAll_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        For I As Integer = 0 To gvWish.Rows.Count - 1
            Dim wishID As Integer = CInt(gvWish.DataKeys(I).Item("WishID"))
            WishController.DeleteProductReview(wishID)
        Next
        BindData()

    End Sub
End Class
