﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>

<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
           
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:Areas, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:Areas, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
      <Hishop:Areas ID="Areas" runat="server">
        <SkinTemplate>

                    <Hishop:StatusMessage id="Status" runat="server" Visible="False" />

            <asp:ValidationSummary ID="ValidatName" runat="server" ValidationGroup="ValidatName"
                CssClass="errorMess" />
            <div class="grdGroupFormList">
                <div class="grdHeaderStyle">
                    <ul>
                        <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                            <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
                        <li class="spirtLines">|</li>
                        <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                            <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
                        <li class="spirtLines">|</li>
                        <li class="userGroupDelCheck">
                            <hishop:imagelinkbutton id="lkbDelectCheck" runat="server" onclientclick="showConfirm(this); return false;"
                                text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></hishop:imagelinkbutton>
                        </li>
                    </ul>
                </div>
                    <asp:GridView ID="grdAreas" runat="server" AutoGenerateColumns="false" ShowHeader="true"
                        DataKeyNames="AreaId" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow"
                        HeaderStyle-CssClass="GridViewHeaderStyle" SelectedRowStyle-BackColor="#FBFBF4">
                        <Columns>
                            <Hishop:CheckBoxColumn ReadOnly="true" />
                            <asp:TemplateField HeaderText="<%$ Resources:Areas, IDS_Header_Name %>">
                                <ItemTemplate>
	                                  <asp:Label ID="lblName" runat="server" Text='<%# Eval("Name") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <asp:TextBox ID="txtName" runat="server" MaxLength="25" Text='<%# Globals.HtmlDecode(Convert.ToString(Eval("Name"))) %>'></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="valrName" runat="server" ControlToValidate="txtName"
                                        ErrorMessage="<%$ Resources:Areas, IDS_ErrorMessagge_Name %>" Display="None"
                                        ValidationGroup="ValidatName" SetFocusOnError="true"></asp:RequiredFieldValidator>
                                    <asp:LinkButton ID="lkbUpdate" CommandName="Update" CssClass="SmallCommonTextButton" ValidationGroup="ValidatName" runat="server" Text="<%$ Resources:Areas, IDS_Button_Update %>"></asp:LinkButton>
                                    <asp:LinkButton ID="lkbCancel" CommandName="Cancel" CssClass="SmallCommonTextButton" runat="server" Text="<%$ Resources:Areas, IDS_Button_Cancel %>"></asp:LinkButton>
                                </EditItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" HeaderStyle-Width="30%">
                                <ItemStyle/>
                                  <ItemTemplate>
			                        <asp:LinkButton ID="lkbEdit" CommandName="Edit" CssClass="SmallCommonTextButton" runat="server" Text="<%$ Resources:Areas, IDS_Button_Edit %>"></asp:LinkButton>
			                        <Hishop:ImageLinkButton runat="server" ID="Delete" CssClass="SmallCommonTextButton" Text="<%$ Resources:Areas, IDS_Button_Delete %>" CommandName="Delete" OnClientClick="showConfirm(this); return false;"></Hishop:ImageLinkButton>
                                  </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
            </div>
            <div class="grdHeaderStyle" style="cursor: pointer;" onclick="expItemsTable('addItemsTable');">
                <ul>
                    <li class="addProductTmpt">
                        <asp:Literal ID="litAddArea" Text="<%$ Resources:Areas, IDS_FromField_lblAddName %>"
                            runat="server"></asp:Literal>
                    </li>
                </ul>
            </div>
            <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList"
                id="addItemsTable">
                <tr>
                    <td class="leftTD">
                        <asp:Label ID="lblAddName" runat="server" Text="<%$ Resources:Areas, IDS_Label_Name %>"></asp:Label>：
                    </td>
                    <td class="rightTD" width="100px">
                        <asp:TextBox ID="txtAddName" runat="server"></asp:TextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtAddNameTip" runat="server">
                        </div>
                        <hishop:validatetarget id="ValidateTargetName" runat="server" controltovalidate="txtAddName"
                            containerid="ValidatorContainer" description="<%$ Resources:Areas, IDS_ErrorMessagge_Name %>">
                           <Validators>
                             <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:Areas, IDS_ErrorMessagge_Name %>" LowerBound="1" UpperBound="25" />
                           </Validators>
                         </hishop:validatetarget>
                    </td>
                </tr>
                <tr>
                    <td class="bottonLeftTD">
                        &nbsp;</td>
                    <td class="rightTD">
                        <asp:LinkButton ID="lkbCreate" runat="server" ValidationGroup="valsName" Text="<%$ Resources:Areas, IDS_Button_Create %>"
                            OnClientClick="return PageIsValid()" CssClass="inp_L1"></asp:LinkButton>
                    </td>
                    <td class="rightTD">
                        &nbsp;</td>
                </tr>
            </table>
        </SkinTemplate> 
      </Hishop:Areas>
      
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>

 