﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
           
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:Regions,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:Regions,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
    <Hishop:Regions ID="Regions" runat="server">
        <SkinTemplate>
            <!-- 操作提示 -->

                    <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
            <!--删除确认-->
            <div class="grdGroupFormList">

                        
                        <div class="grdHeaderStyle">
                            <ul>
                                <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                                    <asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
                                <li class="spirtLines">|</li>
                                <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                                    <asp:Literal ID="lkbCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
                                <li class="spirtLines">|</li>
                                <li class="userGroupDelCheck">
                                    <Hishop:ImageLinkButton ID="lkbtnDeleteCheck" runat="server" OnClientClick=""
                                        Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></Hishop:ImageLinkButton></li>
                            </ul>
                        </div>
                        <div class="grdGroupList">
                            <div class="grdGroupListLi">
                                <Hishop:CustomGridView ID="grdRegions" runat="server" AutoGenerateColumns="false"
                                    ShowHeader="true" DataKeyNames="RegionId" CssClass="GridViewStyle" GridLines="None"
                                    RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" SelectedRowStyle-BackColor="#FBFBF4">
                                    <Columns>
                                        <Hishop:CheckBoxColumn ReadOnly="true" />
                                        <asp:TemplateField ItemStyle-Width="30%" HeaderText="<%$ Resources:Regions,IDS_Header_RegionsName%>">
                                            <itemtemplate>
	                                           <asp:Literal id="lblRegionsName" Text='<%#Eval("RegionName") %>' runat="server"></asp:Literal>
                                             </itemtemplate>
                                        </asp:TemplateField>
                                        <Hishop:SortImageColumn HeaderText="<%$Resources:Regions, IDS_Header_DisplaySequence%>" ReadOnly="true" />
                                        <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" HeaderStyle-Width="30%">
                                            <ItemStyle/>
                                               <ItemTemplate>
			                                         <asp:LinkButton ID="lkEdit" Text="<%$ Resources:Resources, IDS_Button_Edit %>" CssClass="SmallCommonTextButton" CommandName="Edit"  runat="server"></asp:LinkButton>
			                                         <Hishop:ImageLinkButton ID="lkDelete" CssClass="SmallCommonTextButton" Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete" OnClientClick="" runat="server"></Hishop:ImageLinkButton>
                                               </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </Hishop:CustomGridView>
                            </div>
                        </div>
                        <!--分页开始-->
                        <div class="grdGroupTabhead">
                           <UI:Pager runat="server" ListToPaging="grdRegions" ID="pager" />
                        </div>

                        <!--添加新的配送地区-->
                        <div class="grdHeaderStyle" style="cursor: pointer;" id="addClassItems">
                            <ul>
                                <li class="addDeliverArea">
                                    <asp:Literal ID="lblRegionsTitle" Text="<%$Resources:Regions,IDS_Title_AddRegion %>"
                                        runat="server"></asp:Literal>
                                </li>
                            </ul>
                        </div>
                        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                            <tr id="tblrAreas" runat="server" >
                                <td class="leftTD">
                                    <asp:Literal ID="lblAreas" runat="server" Text="<%$Resources:Regions,IDS_FormField_AreaGroup %>"></asp:Literal>：
                                </td>
                                <td class="rightTD">
                                    <Hishop:AreasDropDownList ID="dropAreas" runat="server" />
                                </td>
                                <td class="rightTD">
                                    <div id="dropAreasTip" runat="server">
                                    </div>
                                    <Hishop:ValidateTarget ID="ValidateTarget1" runat="server" ControlToValidate="dropAreas"
                                        ContainerId="ValidatorContainer" Description="<%$Resources:Regions,IDS_Message_DropAreas %>">
                                        <Validators>
                                            <Hishop:DropDownListClientValidator ErrorMessage="<%$Resources:Regions,IDS_Message_DropAreas %>" />
                                        </Validators>
                                    </Hishop:ValidateTarget>
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD">
                                    <asp:Literal ID="lblRegionName" Text="<%$Resources:Regions,IDS_DataField_RegionsName %>"
                                        runat="server"></asp:Literal>：</td>
                                <td class="rightTD">
                                    <asp:TextBox ID="txtRegionName" CssClass="input_short" runat="server"></asp:TextBox></td>
                                <td class="rightTD">
                                    <div id="txtRegionNameTip" runat="server">
                                    </div>
                                    <Hishop:ValidateTarget runat="server" ControlToValidate="txtRegionName" ContainerId="ValidatorContainer"
                                        Nullable="false" Description="<%$Resources:Regions,IDS_ErrorMessage_RegionName_Length %>"
                                        FocusMessage="<%$Resources:Regions,IDS_ErrorMessage_RegionName_Length %>">
                                        <Validators>
                                            <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Regions,IDS_ErrorMessage_RegionName_Length %>"
                                                LowerBound="1" UpperBound="100" />
                                        </Validators>
                                    </Hishop:ValidateTarget>
                                </td>
                            </tr>
                            <tr>
                                <td class="leftTD">
                                    <asp:Literal ID="lblDisplaySequence" Text="<%$Resources:Regions,IDS_DataField_DisplaySequence %>"
                                        runat="server"></asp:Literal>：</td>
                                <td class="rightTD">
                                    <asp:TextBox ID="txtDisplaySequence" CssClass="input_short" runat="server" Text="1"></asp:TextBox></td>
                                <td class="rightTD">
                                    <div id="txtDisplaySequenceTip" runat="server">
                                    </div>
                                    <Hishop:ValidateTarget runat="server" ControlToValidate="txtDisplaySequence" ContainerId="ValidatorContainer"
                                        Description="<%$Resources:Regions,IDS_ErrorMessage_DisplaySequence %>" Nullable="false"
                                        FocusMessage="<%$Resources:Regions,IDS_ErrorMessage_DisplaySequence %>">
                                        <Validators>
                                            <Hishop:InputNumberClientValidator ErrorMessage="<%$Resources:Regions,IDS_ErrorMessage_DisplaySequence %>" />
                                            <Hishop:NumberRangeClientValidator ErrorMessage="<%$Resources:Regions,IDS_ErrorMessage_DisplaySequence %>"
                                                MinValue="1" />
                                        </Validators>
                                    </Hishop:ValidateTarget>
                                </td>
                            </tr>
                            <tr>
                                <td class="bottonLeftTD">
                                    &nbsp;</td>
                                <td class="rightTD" colspan="2">
                                    <asp:Button ID="btnSubmitRegions" runat="server" Text="<%$ Resources:Resources, IDS_Button_Confirm%>"
                                        CssClass="inp_L1" OnClientClick="return PageIsValid()" />
                                    <asp:Button ID="btnCancel" runat="server" Text="<%$ Resources:Resources, IDS_Button_Cancel%>"
                                        CssClass="inp_L1" />
                                </td>
                            </tr>
                        </table>

            </div>        
        </SkinTemplate>
    </Hishop:Regions>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>