﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>

</head>
<body>
    <form id="form1" runat="server">

        <div>
           
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ShippingModes, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:ShippingModes, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
                  <Hishop:ShippingModes ID="ShippingModes" runat="server">
        <SkinTemplate>

                    <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
            <div class="grdHeaderStyle">
                <ul>
                    <li class="userGroupAddadmin"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_createShippingModes")%>'>
                        <asp:Label ID="lblCreateShippingMode" runat="server" Text="<%$ Resources:ShippingModes, IDS_FromField_lblAddShippingMode %>"></asp:Label></a></li>
                    <li class="spirtLines">|</li>
                    <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                        <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
                    <li class="spirtLines">|</li>
                    <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                        <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
                    <li class="spirtLines">|</li>
                    <li class="userGroupDelCheck">
                        <Hishop:ImageLinkButton ID="lkbDelectCheck" runat="server" OnClientClick=""
                            Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></Hishop:ImageLinkButton></li>
                </ul>
            </div>
                    <asp:GridView ID="grdShippingModes" runat="server" DataKeyNames="ModeId" AutoGenerateColumns="false"
                        CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                        <Columns>
                            <Hishop:CheckBoxColumn />
                            <asp:TemplateField HeaderText="<%$ Resources:ShippingModes, IDS_Header_Name %>" ItemStyle-Width="25%">
                                <ItemTemplate>
	                               <asp:Label ID="lblShippingModesName" Text='<%#Eval("Name") %>' runat="server"></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField HeaderText="<%$ Resources:ShippingModes, IDS_Header_Weight %>" DataField="Weight" />
                            <asp:TemplateField HeaderText="<%$ Resources:ShippingModes, IDS_Header_Price %>">
                                <ItemTemplate>
                                    <Hishop:FormatedMoneyLabelForAdmin runat="server" Money='<%# Eval("Price") %>'></Hishop:FormatedMoneyLabelForAdmin>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField HeaderText="<%$ Resources:ShippingModes, IDS_Header_AddWeight %>"
                                DataField="AddWeight" />
                            <asp:TemplateField HeaderText="<%$ Resources:ShippingModes, IDS_Header_AddPrice %>">
                                <ItemTemplate>
                                    <Hishop:FormatedMoneyLabelForAdmin runat="server" Money='<%# Eval("AddPrice") %>'></Hishop:FormatedMoneyLabelForAdmin>
                                </ItemTemplate>
                            </asp:TemplateField>
                             <Hishop:SortImageColumn HeaderText="<%$ Resources:ShippingModes,IDS_Header_DisplaySequence %>" />
                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" HeaderStyle-Width="20%">
                                <ItemStyle/>
                                   <ItemTemplate>
			                           <a href='EditShippingMode.aspx?modeId=<%# DataBinder.Eval(Container, "DataItem.ModeId") %>' class="SmallCommonTextButton"><asp:Literal ID="lblManagerText" runat="server" Text="<%$ Resources:Resources, IDS_Button_Edit %>"></asp:Literal>
			                           <Hishop:ImageLinkButton runat="server" ID="Delete" CommandName="Delete" CssClass="SmallCommonTextButton" OnClientClick="" Text="<%$ Resources:Resources, IDS_Button_Delete %>"/>
                                   </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>

        </SkinTemplate>
      </Hishop:ShippingModes>            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
