﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:AgentialRanks, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:AgentialRanks, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <div class="PageTitleArea" style="background-color:#FFC6FF">
                <div style="color:Red"><asp:Literal ID="litMark" runat="server"  Text="<%$ Resources:AgentialRanks, IDS_Label_Mark %>"></asp:Literal>：</div>
                <div><asp:Literal ID="litMessage" runat="server"  Text="<%$ Resources:AgentialRanks, IDS_Message %>"></asp:Literal></div>
            </div>
                  <Hishop:AgentialRanks ID="AgentialRanks" runat="server">
        <SkinTemplate>

                    <Hishop:StatusMessage id="Status" runat="server" Visible="False" />

            <div class="grdGroupFormList">             		

                       <div class="grdHeaderStyle">
			               <ul>
			                   <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Literal ID="CheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>" ></asp:Literal></a></li>
                               <li class="spirtLines">|</li>
                               <li class="userGroupReverseCheck"><a  href="#" onclick="CheckReverse()"><asp:Literal ID="lblCheckRecerse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
                               <li class="spirtLines">|</li>
			                   <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
			               </ul>
			            </div>
		              <div class="grdGroupList">
                              <Hishop:CustomGridView ID="grdAgentialRanks" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="RankId" CssClass="GridViewStyle" GridLines="None"  RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" >      
                                      <SelectedRowStyle BackColor="#FBFBF4" />  
			                  <Columns>
			                      <Hishop:CheckBoxColumn ReadOnly="true"/>
			                     <asp:BoundField DataField="Name" HeaderText="<%$ Resources:AgentialRanks,IDS_DataField_RankName %>"/>
			                     <asp:BoundField DataField="NumberOfMemberRanks" HeaderText="<%$ Resources:AgentialRanks,IDS_DataField_NumberOfMemberRanks %>"/>
			                     <asp:BoundField DataField="Description" HeaderText="<%$ Resources:AgentialRanks,IDS_DataField_RankDesc %>"/>
                                <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" HeaderStyle-Width="30%">
                                    <ItemTemplate>
			                             <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_SetProductAgentPrice",Eval("RankId"))%>' class="SmallCommonTextButton"><asp:Literal id="lblSetAgentProductPrice" runat="server" Text="<%$Resources:AgentialRanks,IDS_Link_ProductPrice %>"></asp:Literal></a>
			                             <asp:LinkButton runat="server" CssClass="SmallCommonTextButton" ID="lkEdit" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit %>"/>
			                             <Hishop:DeleteImageLinkButton runat="server" CssClass="SmallCommonTextButton" ID="lkDelete" CommandName="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete %>"/>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_SetProductAgentPrice",Eval("RankId"))%>' class="SmallCommonTextButton"><asp:Literal id="lblSetAgentProductPrice" runat="server" Text="<%$Resources:AgentialRanks,IDS_Link_ProductPrice %>"></asp:Literal></a>
			                             <asp:LinkButton runat="server" CssClass="SmallCommonTextButton" ID="lbtnUpdate" CommandName="Update" Text="<%$ Resources:Resources, IDS_Button_Update %>"/>
			                             <Hishop:ImageLinkButton runat="server" CssClass="SmallCommonTextButton" ID="lbtnCancel" CommandName="Cancel" Text="<%$ Resources:Resources, IDS_Button_Cancel %>"/>
                                    </EditItemTemplate>
                                </asp:TemplateField>
			                  </Columns>
			               </Hishop:CustomGridView>
			            </div>

			             </div>
              <!--添加代理等级开始-->

                     <div class="grdHeaderStyle" style="cursor:pointer;" onclick="expItemsTable('addItemsTable');">
                            <ul>
                                <li class="addActing">
                                    <asp:Literal ID="lblAgentRankTitle" Text="<%$Resources:AgentialRanks, IDS_Button_AddAgentialRanks%>" runat="server"></asp:Literal>
                                </li>
                            </ul>
                        </div>
                     <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable">
                         <tr>
                             <td class="leftTD"><asp:Label ID="lblRankNameTitle" Text="<%$Resources:AgentialRanks,IDS_DataField_RankName%>" runat="server"></asp:Label>：</td>
                             <td class="rightTD"><asp:TextBox ID="txtRankName" CssClass="input_short" runat="server"></asp:TextBox></td>
                             <td class="rightTD">
                                 <div id="txtRankNameTip" runat="server"></div>
                                  <Hishop:ValidateTarget ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtRankName" Description="<%$ Resources:AgentialRanks,IDS_ErrorMessage_RankName  %>" Nullable="false" FocusMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_RankName %>">
                                     <Validators>
                                         <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_RankName %>" LowerBound="1" UpperBound="50" />
                                     </Validators>
                                  </Hishop:ValidateTarget>		
                             </td>
                          </tr>              
                           <tr>
                               <td class="leftTD"><asp:Label ID="lblNumberOfMemberRanks" Text='<%$Resources:AgentialRanks,IDS_DataField_NumberOfMemberRanks%>' runat="server"></asp:Label>：</td>
                               <td class="rightTD"><asp:TextBox ID="txtNumberOfMemberRanks" CssClass="input_short" runat="server"></asp:TextBox></td>
                               <td class="rightTD">
                                 <div id="txtNumberOfMemberRanksTip" runat="server"></div>
                                  <Hishop:ValidateTarget ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtNumberOfMemberRanks" Description="<%$ Resources:AgentialRanks,IDS_ErrorMessage_MemberRanksNum  %>" Nullable="false" FocusMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_MemberRanksNum %>">
                                     <Validators>
                                         <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_MemberRanksNum %>" />
                                         <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_MemberRanksNum %>" MinValue="1"/>
                                     </Validators>
                                  </Hishop:ValidateTarget>		
                             </td>
                           </tr>
                           <tr>
                               <td class="leftTD"><asp:Label ID="Label1" Text='<%$Resources:AgentialRanks,IDS_DataField_RankPrice%>' runat="server"></asp:Label>=</td>
                               <td class="rightTD">
                                    <Hishop:PriceTypeDropDownList ID="dropPriceType" runat="server" />
                                    <Hishop:PriceOperationsDownList ID="dropPriceOperateions" runat="server"  />
                                    <asp:TextBox ID="txtValue" CssClass="input_short" Width="90px" runat="server" ></asp:TextBox></td>
                               <td class="rightTD">
                                 <div id="txtValueTip" runat="server"></div>
                                  <Hishop:ValidateTarget ID="ValidateTarget1" ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtValue" Description="<%$ Resources:AgentialRanks,IDS_ErrorMessage_RnakPrice  %>" Nullable="false" FocusMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_RnakPrice %>">
                                     <Validators>
                                         <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_RnakPrice %>" />
                                         <Hishop:MoneyRangeClientValidator MinValue="0" MaxValue="10000" ErrorMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_RnakPrice %>" />
                                     </Validators>
                                  </Hishop:ValidateTarget>		
                             </td>
                           </tr>
                           <tr>
                               <td class="leftTD"><asp:Label ID="lblRankDescTitle" Text='<%$Resources:AgentialRanks,IDS_DataField_RankDesc%>' runat="server"></asp:Label>：</td>
                                <td class="rightTD"><asp:TextBox ID="txtRankDesc" runat="server" CssClass="input_short" TextMode="MultiLine" Height="60px"></asp:TextBox></td>
                                <td class="rightTD">
                                 <div id="txtRankDescTip" runat="server"></div>
                                  <Hishop:ValidateTarget ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtRankDesc" Description="<%$ Resources:AgentialRanks,IDS_ErrorMessage_RankDesc  %>" Nullable="true" FocusMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_RankDesc %>">
                                     <Validators>
                                         <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:AgentialRanks, IDS_ErrorMessage_RankDesc %>" LowerBound="1" UpperBound="200" />
                                     </Validators>
                                  </Hishop:ValidateTarget>		
                             </td>
                           </tr> 
                            <tr>
                                <td class="bottonLeftTD">&nbsp;</td>
                                <td class="rightTD">
                                     <asp:Button ID="btnSubmitAgentialRanks" OnClientClick="return PageIsValid();" Text="<%$ Resources:Resources, IDS_Button_Add%>" CssClass="inp_L1" runat="server"/>                                     
                                </td>
                                <td class="rightTD">&nbsp;</td>
                            </tr>                         
                     </table>
        </SkinTemplate>
      </Hishop:AgentialRanks>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
