﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
           
            <div class="PageTitleArea">
                <div class="PageTitle">
                     <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:BrandCategories, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:BrandCategories,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:BrandCategories ID="BrandCategories" runat="server">
            <SkinTemplate>

        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />


<div class="grdGroupFormList">
    <div class="grdHeaderStyle">
        <ul>
            <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupDelCheck">
                <Hishop:DeleteImageLinkButton ID="lkbDelectCheck" runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" ></Hishop:DeleteImageLinkButton>
            </li>
        </ul>
    </div>
            <asp:GridView ID="grdBrandCategries" runat="server" AutoGenerateColumns="false" ShowHeader="true"
                DataKeyNames="BrandId" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow"
                HeaderStyle-CssClass="GridViewHeaderStyle" ShowFooter="false" SelectedRowStyle-BackColor="#FBFBF4" >
                <Columns>
                    <Hishop:CheckBoxColumn />
                    <asp:TemplateField HeaderText="<%$ Resources:BrandCategories, IDS_Header_BrandId %>" ItemStyle-Width="10%">
                        <ItemTemplate>
	                           <asp:Literal ID="lblId" runat="server" Text='<%# Bind("BrandId") %>'></asp:Literal>
                        </ItemTemplate>
                    </asp:TemplateField>
                    
                    <asp:TemplateField HeaderText="<%$ Resources:BrandCategories, IDS_Header_BrandName %>" ItemStyle-Width="30%">
                        <ItemTemplate>
                            <div>
                                <a id="A1" href='<%# Eval("CompanyUrl") %>' runat="server" target="_blank">
                                    <Hishop:Common_Image runat="server" EnabledTimestamp="true" DataField="Logo"  />
                                </a>
                            </div>
                            <asp:Literal ID="lblName" runat="server" Text='<%# Bind("BrandName") %>'></asp:Literal>
                        </ItemTemplate>
                    </asp:TemplateField>
                    
                    <asp:TemplateField HeaderText="<%$ Resources:BrandCategories, IDS_Header_Description %>" ItemStyle-Width="40%">
                        <ItemTemplate>
                            <asp:Label Text='<%# Eval("Description") %>'  runat="server" style="word-break:break-all" /></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    
                    <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                        <ItemStyle/>
                        <ItemTemplate>
			                <asp:LinkButton ID="lkbEdit" runat="server" CssClass="SmallCommonTextButton" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit%>"></asp:LinkButton>
			                <Hishop:DeleteImageLinkButton ID="DeleteImageLinkButton1" CssClass="SmallCommonTextButton" runat="server"  Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete"/>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <!--分页开始-->
            <div class="grdGroupTabhead">
                <UI:Pager runat="server" ListToPaging="grdBrandCategries" ID="pager" />
            </div>
            <!--分页结束-->

</div>
<!--002-->
        <div class="grdHeaderStyle" style="cursor: pointer;" onclick="expItemsTable('addItemsTable');">
            <ul>
                <li class="addProductTmpt">
                    <asp:Literal ID="litBrandTitle" Text="<%$ Resources:BrandCategories, IDS_FromField_litBrandTitle_Create %>"
                        runat="server"></asp:Literal>
                </li>
            </ul>
        </div>
        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="formTableList"
            id="addItemsTable">
            <tr>
                <!--品牌名称-->
                <td class="leftTD">
                    <asp:Label ID="lblBrandId" runat="server" Style="display: none"></asp:Label>
                    <asp:Label ID="lblBrandName" runat="server" Text="<%$ Resources:BrandCategories, IDS_FromField_lblBrandName %>"></asp:Label>：</td>
                <td class="rightTD">
                    <asp:TextBox ID="txtBrandName" runat="server" MaxLength="64" Columns="40"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtBrandNameTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateName" runat="server" ControlToValidate="txtBrandName"
                        ContainerId="ValidatorContainer" Description="<%$ Resources:BrandCategories, IDS_Message_BrandName %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:BrandCategories, IDS_Message_BrandName %>"
                                LowerBound="1" UpperBound="128" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <!--官网Logo -->
                <td class="leftTD">
                    <asp:Label ID="lblBrandLogo" runat="server" Text="<%$ Resources:BrandCategories, IDS_FromField_lblBrandLogo %>"></asp:Label>：</td>
                <td class="rightTD">
                    <asp:FileUpload ID="fileUpload" runat="server" />
                <td class="rightTD">
                    <div class="msgNormal">
                        <Hishop:UploadImageMessageLabel runat="server" ID="uploadMessage"></Hishop:UploadImageMessageLabel>
                    </div>
                </td>
            </tr>
            <tr>
                <!--官网网站-->
                <td class="leftTD">
                    <asp:Label ID="lblBrandAddress" runat="server" Text="<%$ Resources:BrandCategories, IDS_FromField_lblBrandAddress %>"></asp:Label>：</td>
                <td class="rightTD">
                    <asp:TextBox ID="txtOffAddress" Text="http://" runat="server" MaxLength="64" Columns="40"></asp:TextBox></td>
                <td class="rightTD">
                    <div id="txtOffAddressTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetOffAddress" runat="server" ControlToValidate="txtOffAddress"
                        ContainerId="ValidatorContainer" Nullable="true" Description="<%$ Resources:BrandCategories, IDS_Message_OffAddress %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:BrandCategories, IDS_Message_OffAddress %>"
                                UpperBound="128" Regex="^(http)://.*" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <!--品牌描叙-->
                <td class="leftTD">
                    <asp:Label ID="lblBrandDescription" runat="server" Text="<%$ Resources:BrandCategories, IDS_FromField_lblBrandDescription %>"></asp:Label>：</td>
                <td class="rightTD">
                    <asp:TextBox ID="txtBrandDescription" TextMode="MultiLine" Width="280" Height="60"
                        runat="server" MaxLength="500"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtBrandDescriptionTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetDescription" runat="server" ControlToValidate="txtBrandDescription"
                        ContainerId="ValidatorContainer" Nullable="true" Description="<%$ Resources:BrandCategories, IDS_Message_BrandDescription %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:BrandCategories, IDS_Message_BrandDescription %>"
                                UpperBound="500" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="bottonLeftTD">
                    &nbsp;</td>
                <td class="rightTD">
                    <asp:Button ID="btnCreate" runat="server" Text="<%$ Resources:BrandCategories,IDS_Button_Create %>"
                        CssClass="inp_L1" OnClientClick="return PageIsValid();" />
                    <asp:Button ID="btnCanel" Text="<%$ Resources:Resources, IDS_Button_Cancel%>" CssClass="inp_L1"
                        runat="server" />
                </td>
                <td class="rightTD">
                    &nbsp;</td>
            </tr>
        </table>
            </SkinTemplate>
            </Hishop:BrandCategories>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>