﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ManageMembers, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:ManageMembers, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:NoProductCheck ID="ManageMembers" runat="server">
                <SkinTemplate>
                    <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
                        <div class="grdGroupFormList">
                            <div class="grdHeaderStyle">
                                <ul>
                                    <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                                        <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
                                    <li class="spirtLines">|</li>
                                    <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                                        <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
                                    <li class="spirtLines">|</li>
                                    <li class="userGroupDelCheck">
                                        <Hishop:ImageLinkButton ID="lkbDelectCheck" runat="server" OnClientClick=""
                                            Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></Hishop:ImageLinkButton></li>
                                </ul>
                            </div>
                            <div class="grdGroupListLi">
                                <Hishop:CustomGridView ID="grdNoProductCheckList" runat="server" AutoGenerateColumns="false"
                                    ShowHeader="true" DataKeyNames="CheckId" CssClass="GridViewStyle" GridLines="None"
                                    RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" AllowSorting="true" SortOrderBy="CreateDate" SortOrder="DESC">
                                    <Columns>
                                        <Hishop:CheckBoxColumn />
                                        <asp:TemplateField ItemStyle-Width="120px">                            
                                            <itemtemplate>
                                                 <a href="javascript:openDialog('<%# Globals.GetSiteUrls().UrlData.FormatUrl("ProductImages",Eval("ProductId")) %>')">
                                                <Hishop:Common_ProductThumbnail ID="Common_ProductThumbnail1" runat="server" EnabledTimestamp="true" AutoResize="true" DataField="ThumbnailsUrl"/>
                                                </a>
                                             </itemtemplate>
                                        </asp:TemplateField>
                                        
                                        <asp:TemplateField HeaderText="商品名称"  ItemStyle-Width="100px">
                                            <itemtemplate>
                                                <Hishop:ProductNavigationDetails ProductName='<%# Eval("ProductName") %>' ProductId='<%# Eval("ProductId") %>' runat="server"/>
                                            </itemtemplate>
                                        </asp:TemplateField>
                                        
                                        <asp:TemplateField HeaderText="会员名"  ItemStyle-Width="80px">                            
                                            <itemtemplate>
                                                 <asp:Label ID="lblUserName" runat="server" Text='<%# Eval("UserName") %>' />
                                            </itemtemplate>
                                        </asp:TemplateField>
                                                               
                                        <asp:BoundField HeaderText="电子邮箱" DataField="Email" />

                                        <asp:TemplateField HeaderText="登记时间" SortExpression="CheckDate">
                                            <itemtemplate>
                                               <Hishop:FormatedTimeLabel ID="lblCheckDate" Time='<%# Bind("CheckDate") %>' runat="server"></Hishop:FormatedTimeLabel>
                                            </itemtemplate>
                                        </asp:TemplateField>
                                        
                                         <asp:TemplateField HeaderText="通知时间" SortExpression="NotifyDate">
                                            <itemtemplate>
                                               <Hishop:FormatedTimeLabel ID="lblCheckDate" Time='<%# Bind("NotifyDate") %>' runat="server"></Hishop:FormatedTimeLabel>
                                            </itemtemplate>
                                        </asp:TemplateField>
                                        
                                        <asp:TemplateField HeaderText="通知状态">                            
                                            <itemtemplate>
                                                <asp:Label ID="lblIsNotify" runat="server" Text='<%# Eval("IsNotify") %>' />
                                            </itemtemplate>
                                        </asp:TemplateField> 
                                        
                                        <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                            <itemstyle width="66px" />
                                            <itemtemplate>
                                                <Hishop:ImageLinkButton runat="server" ID="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete %>"
                                                    CommandName="Delete" CssClass="SmallCommonTextButton"></Hishop:ImageLinkButton>
                                            </itemtemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </Hishop:CustomGridView>
                            </div>
                        </div>
                </SkinTemplate>
            </Hishop:NoProductCheck>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
    </form>
</body>
</html>
 
