﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div class="PageTitleArea">
            <div class="PageTitle">
                <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ProductConsultationsManage,IDS_PageTitle %>"></asp:Literal>
            </div>
            <div style="width: 80%;">
                <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:ProductConsultationsManage,IDS_PageDesc %>"></asp:Literal>
            </div>
        </div>
        <Hishop:ProductConsultationsManage ID="ProductConsultations" runat="server">
            <SkinTemplate>
                <!-- 操作提示 -->
                <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
                <!-------- ProductSearch -------->
                <Hishop:ProductSearch runat="server" ID="productSearch">
                    <SkinTemplate>
                        <fieldset class="AdminSearchform">
                            <legend>
                                <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_litSelectQuery %>"></asp:Literal></legend>
                            <table width="55%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
                                <tr>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <asp:TextBox ID="txtSearchText" runat="server" Width="110" ToolTip="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText_ToolTip %>"></asp:TextBox>
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FromField_lblCategory %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:ProductCategoriesDropDownList ID="dropCategories" runat="server" />
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblSKU" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSKU %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <asp:TextBox ID="txtSKU" Width="110" runat="server"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>

                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblBrandCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblBrandCategory %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:BrandCategoriesDropDownList ID="dropBrandCategories" runat="server" />
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                    <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblPageSize %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
                                    </td>
                                    <td class="searchTableControlTD">
                                        <asp:Button ID="btnSearch" runat="server" Text="<%$ Resources:ProductSearch, IDS_Button_Search %>"
                                            CssClass="inp_L1" />
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </SkinTemplate>
                </Hishop:ProductSearch>
                <!-- 选项卡-->
                <div>
                    <ul class="anchors clearfix">
                        <li class="tabs-selected"><a href='#'>
                            <img src="../images/00212_2.png" alt="" onclick="errorEventTable(this)" />
                            <asp:Label runat="server" ID="lblAgentPriceTemplets" Text="<%$ Resources:ProductConsultationsManage,IDS_Title_Reply %>"></asp:Label></a>
                        </li>
                        <li><a href="<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ProductConsultationsReplyedManage")%>">
                            <img src="../images/00212.png" alt="" onclick="errorEventTable(this)" />
                            <asp:Label runat="server" ID="lblPriceTemplets" Text="<%$ Resources:ProductConsultationsManage, IDS_Title_Replyed %>"></asp:Label></a>
                        </li>
                    </ul>
                </div>
                <div class="grdGroupFormList" style="word-break: break-all;">
                    <div class="grdGroupList">
                        <Hishop:CustomGridView runat="server" ID="grdConsultation" CssClass="GridNoBorder"
                            Width="100%" AllowSorting="true" ShowOrderIcons="true" GridLines="None" DataKeyNames="ConsultationId"
                            SortOrder="Desc" SortOrderBy="ConsultationDate" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle"
                            AutoGenerateColumns="false" ForeColor="#333333">
                            <RowStyle CssClass="grdrow" ForeColor="#333333" />
                            <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
                            <HeaderStyle BackColor="#EEF8FF" Height="25" CssClass="GridViewHeaderStyle" Font-Bold="True"
                                ForeColor="#314E9F" />
                            <AlternatingRowStyle BackColor="White" />
                            <Columns>
                                <asp:TemplateField SortExpression="ProductName" HeaderText="<%$ Resources:ProductConsultationsManage, IDS_GrdHead_Product %>">
                                    <ItemTemplate>
                                        <a href="javascript:openDialog('<%# Globals.GetSiteUrls().UrlData.FormatUrl("ProductImages",Eval("ProductId")) %>')">
                                            <Hishop:Common_ProductThumbnail runat="server" AutoResize="true" DataField="ThumbnailsUrl" Width="50px" /></a>
                                        <asp:Label ID="lblThumbUrl" runat="server" Text='<%# Eval("ThumbnailsUrl") %>' Style="display: none;"></asp:Label>
                                        <asp:Label ID="lblInFocusUrl" runat="server" Text='<%# Eval("InFocusImageUrl") %>'
                                            Style="display: none;"></asp:Label>
                                        <div>
                                            <div style="color: Blue">
                                                <%# Eval("SKU") %>
                                            </div>
                                            <Hishop:ProductNavigationDetails ProductName='<%# Eval("ProductName") %>' ProductId='<%# Eval("ProductId") %>'
                                                runat="server" />
                                        </div>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField ItemStyle-Width="100px" HeaderText="<%$ Resources:ProductConsultationsManage, IDS_GrdHead_User %>"
                                    SortExpression="UserName">
                                    <ItemTemplate>
                                        <asp:Label ID="lblUserName" runat="server" Text='<%# Eval("UserName") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="<%$ Resources:ProductConsultationsManage, IDS_GrdHead_Text %>">
                                    <ItemTemplate>
                                        <asp:Label ID="lblConsultationText" runat="server" Text='<%# Eval("ConsultationText") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField ItemStyle-Width="120px" HeaderText="<%$ Resources:ProductConsultationsManage, IDS_GrdHead_Time %>"
                                    SortExpression="ConsultationDate">
                                    <ItemTemplate>
                                        <Hishop:FormatedTimeLabel ID="ConsultationDateTime" Time='<%# Eval("ConsultationDate") %>'
                                            runat="server"></Hishop:FormatedTimeLabel>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="<%$ Resources:Resources,IDS_Header_Options %>">
                                    <ItemStyle HorizontalAlign="Right" CssClass="handleRightSelect" />
                                    <ItemTemplate>
                                            
                                        <a id="btnReplyRequest" Class="SmallCommonTextButton" onclick="$.myfunction.OpenWindow(<%# Eval("ConsultationId") %>,'<%# Eval("ConsultationText") %>')" href="#">回复</a>
                                            
                                        <Hishop:ImageLinkButton ID="ilikbReplyDelete" runat="server" CommandName="Delete"
                                            CommandArgument='<%# Eval("ConsultationId")%>' CssClass="SmallCommonTextButton"
                                            OnClientClick="" Text="<%$ Resources:Resources, IDS_Button_Delete %>"></Hishop:ImageLinkButton>
                                    </ItemTemplate>
                                    <HeaderStyle HorizontalAlign="Right" />
                                </asp:TemplateField>
                            </Columns>
                        </Hishop:CustomGridView>
                        <!--分页开始-->
                        <div class="grdGroupTabhead">
                            <UI:pager runat="server" listtopaging="grdConsultation" id="pager" />
                        </div>
                    </div>
                </div>
                
                <script type="text/javascript">
                    $(document).ready(function() {
                        jQuery.myfunction = {
                            OpenWindow: function(consultationId, consultationText) {
                                if (!dlgConsultation.get_isShowing()) {
                                    dlgConsultation.Show();
                                    document.getElementById("ProductConsultations_lblSaveConsultationId").value = consultationId;
                                    document.getElementById("ProductConsultations_lblReplyAsk").value = consultationText;
                                }
                            },
                            Close: function() {
                                dlgConsultation.Close();
                                document.getElementById("ProductConsultations_lblSaveConsultationId").value = "";
                                document.getElementById("ProductConsultations_lblReplyAsk").value = "";
                            }
                        }
                    });
               </script>
              
              
                <!-- 回复窗体内容 -->
                  <UI:Dialog AnimationType="Live" ShowTransition="Fade" AnimationSlide="ExponentialDecelerate"
                        CloseTransition="Fade" AnimationDuration="600" Modal="true"
                        AllowDrag="true" Alignment="MiddleCentre" Title="<%$ Resources:ProductConsultationsManage,IDS_FormField_DealRequest%>"
                        ID="dlgConsultation" runat="server" Width="400px">
                        <Content>
                            <div class="affirmpop">
                                <asp:TextBox ID="lblSaveConsultationId" runat="server" style="display:none"></asp:TextBox>
                                <asp:TextBox ID="lblReplyAsk" runat="server" style="display:none"></asp:TextBox>
                                <nobr>&nbsp;&nbsp;<asp:Label ID="lblReplyTextForm" runat="server" Text="<%$ Resources:ProductConsultationsManage,IDS_FormField_ReplyText%>"></asp:Label>：</nobr>
                                <asp:TextBox ID="txtReplyTextForm" Width="280" Height="100px" TextMode="MultiLine"
                                    runat="server"></asp:TextBox>
                            </div>
                            <div class="popbottom" style="text-align: center;">
                                <asp:Button ID="btnAgreeRequest" runat="server" Text="<%$ Resources:ProductConsultationsManage, IDS_Button_AgreeRequest%>"
                                    CssClass="inp_L1" />
                                <asp:Button ID="btnBack" runat="server" Text="<%$ Resources:ProductConsultationsManage, IDS_Button_Back %>"
                                    CssClass="inp_L1" />
                            </div>
                       </Content>
                   </UI:Dialog>
                   
            </SkinTemplate>
        </Hishop:ProductConsultationsManage>
    </div>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright runat="server" />
    </div>
    <br />
    <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
