﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<%@ Import Namespace="System.Web.UI.WebControls" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="litManagerTop" runat="server" Text="<%$ Resources:ProductOnSales, IDS_PageTitle %>" ></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="litManagerDisciption" runat="server" Text="<%$ Resources:ProductOnSales, IDS_PageDescription %>" ></asp:Literal>
                </div>
            </div>
            
            <Hishop:ProductOnSales runat="server" >
            <SkinTemplate>
<!-- 操作提示 -->
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<!-------- ProductSearch -------->
<fieldset class="AdminSearchform">
    <legend>
        <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_litSelectQuery %>"></asp:Literal></legend>
    <table width="55%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
        <tr>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtSearchText" runat="server" Width="110" ToolTip="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText_ToolTip %>"></asp:TextBox></td>
             <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FromField_lblCategory %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:ProductCategoriesDropDownList ID="dropCategories" runat="server" />
            </td>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblSKU" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSKU %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <asp:TextBox ID="txtSKU" Width="110" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblBrandCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblBrandCategory %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:BrandCategoriesDropDownList ID="dropBrandCategories" runat="server" />
            </td>
            <td class="searchTableLeftTD">
                <nobr>
                    <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblPageSize %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
                <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
            </td>
            <td class="searchTableControlTD">
                <asp:Button ID="btnSearch" runat="server" Text="<%$ Resources:ProductSearch, IDS_Button_Search %>"
                    CssClass="inp_L1" /></td>
            <td>
            </td>
        </tr>
    </table>
</fieldset>

<div class="grdHeaderStyle">
    <ul>
        <li class="userGroupCheckAll">
            <asp:LinkButton ID="Button2" runat="server" OnClientClick="CheckClickAll();return false;"
                Text="<%$ Resources:ProductOnSales, IDS_Button_CheckAll %>" />
        </li>
        <li class="spirtLines">|</li>
        <li class="userGroupReverseCheck">
            <asp:LinkButton ID="CheckReverse" runat="server" OnClientClick="CheckReverse();return false;"
                Text="<%$ Resources:ProductOnSales, IDS_Button_CheckReverse %>" />
        </li>
        <li class="spirtLines">|</li>
        <li class="userGroupDelCheck">
            <asp:LinkButton runat="server" ID="btnOffShelf" Text="<%$ Resources:ProductOnSales, IDS_Button_btnOffShelf %>" />
        </li>
        <li class="spirtLines">|</li>
        <li class="userGroupDelCheck">
            <Hishop:DeleteImageLinkButton ID="btnDelete" runat="server" Text="<%$ Resources:ProductOnSales, IDS_Button_btnDelete %>" /></li>
        <li class="userGroupDelCheck">
            <Hishop:DeleteImageLinkButton ID="btnDeleteSearch" runat="server" Text="<%$ Resources:ProductOnSales, IDS_Btn_DeleteSearch %>" /></li>
    </ul>
</div>
<div id="big_image" style="display:none;position:absolute;z-index:1; background-color:White; border: 0px solid #f4f4f4;"></div>
<script type="text/jscript" >
    function ShowImage(t) {
        var ei = document.getElementById("big_image");
        ei.style.display = "block";
        ei.innerHTML = '<img src="' + t.src + '" onload = ResizeImage(this,200,200) />'
    }

    function HiddenImage() {
        var ei = document.getElementById("big_image");
        ei.innerHTML = "";
        ei.style.display = "none";
    }
    function move_layer(event) {
        event = event || window.event;

        document.getElementById("big_image").style.top = event.clientY + 8 + "px";
        document.getElementById("big_image").style.left = event.clientX + 8 + "px";
    }
    document.onmousemove = move_layer;

    var imageObject;
    function ResizeImage(F, D, G) {
        if (F != null) {
            imageObject = F;
        }

        if (document.all) {
            if (imageObject.readyState != "complete") {
                setTimeout("ResizeImage(null," + D + "," + G + ")", 50);
                return;
            }
        }
        else if (!imageObject.complete) {
            setTimeout("ResizeImage(null," + D + "," + G + ")", 50);
            return;
        }

        var B = new Image();
        B.src = imageObject.src;
        var A = B.width;
        var C = B.height;
        if (A > D || C > G) {
            a = A / D;
            b = C / G;
            if (b > a) {
                a = b;
            }
            A = A / a;
            C = C / a;
        }
        if (A > 0 && C > 0) {
            imageObject.width = A;
            imageObject.height = C;
        }
    }
</script>
<div class="grdGroupList">
    <div class="grdGroupListLi">
                <Hishop:CustomGridView runat="server" ID="grdProducts" CssClass="GridNoBorder" Width="100%"
                    AllowSorting="true" ShowOrderIcons="true" GridLines="None" DataKeyNames="ProductId"
                    SortOrder="Desc" SortOrderBy="DisplaySequence" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle"
                    AutoGenerateColumns="false" ForeColor="#333333">
                    <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
                    <HeaderStyle BackColor="#EEF8FF" Height="25" CssClass="GridViewHeaderStyle" Font-Bold="True" ForeColor="#314E9F" />
                    <AlternatingRowStyle BackColor="White" />
                    <Columns>
                        <Hishop:CheckBoxField HeadWidth="35" />
                        <asp:BoundField HeaderText="排序" DataField="DisplaySequence" ItemStyle-Width="45px" />
                        <asp:TemplateField ItemStyle-Width="8px">
                            <itemtemplate>
                            <Hishop:Common_ProductThumbnail runat="server" EnabledTimestamp="true" AutoResize="true" Width="50px" DataField="ThumbnailsUrl" 
                                onmousemove='ShowImage(this)' onmouseout="HiddenImage()" />
                         </itemtemplate>
                        </asp:TemplateField>
                        <asp:TemplateField SortExpression="ProductName" HeaderText="货号" ItemStyle-Width="80px">
                            <itemtemplate>
                             <%# Eval("SKU") %>
                            </itemtemplate>
                        </asp:TemplateField>
                        <asp:TemplateField SortExpression="ProductName" HeaderText="<%$ Resources:ProductInStock, IDS_Header_ProductName %>">
                            <itemtemplate>
                             <div style="color:Blue"> <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("productDetails",Eval("ProductId")) %>' target="_blank">
                                <asp:Literal ID="litName" runat="server" Text='<%# Eval("ProductName") %>'></asp:Literal></a></div>
                            </itemtemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="<%$ Resources:ProductOnSales, IDS_Header_Stock %>"
                            SortExpression="Stock" ItemStyle-Width="100" ItemStyle-HorizontalAlign="Center">
                            <itemtemplate>
                             <asp:Label ID="lblStock" runat="server" Text='<%# Eval("Stock") %>' Width="25"></asp:Label>
                          </itemtemplate>
                        </asp:TemplateField>
                        <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:ProductOnSales, IDS_Header_CostPrice %>"
                            ItemStyle-Width="80" SortExpression="CostPrice" DataField="CostPrice" ItemStyle-HorizontalAlign="Center" />
                        <Hishop:MoneyColumnForAdmin HeaderText="<%$ Resources:ProductOnSales, IDS_Header_SalePrice %>"
                            ItemStyle-Width="80" SortExpression="SalePrice" DataField="SalePrice" ItemStyle-HorizontalAlign="Center"/>
                        <Hishop:YesNoImageColumn HeaderText="<%$ Resources:ProductOnSales, IDS_Header_Recommanded %>"
                            ItemStyle-Width="41" SortExpression="Recommended" DataField="Recommended" CommandName="Recommended" ItemStyle-HorizontalAlign="Center"/>
                        <Hishop:YesNoImageColumn HeaderText="<%$ Resources:ProductOnSales, IDS_Header_HotSale %>"
                            ItemStyle-Width="41" SortExpression="Hotsale" DataField="Hotsale" CommandName="Hotsale" ItemStyle-HorizontalAlign="Center"/>
                        <Hishop:YesNoImageColumn HeaderText="<%$ Resources:ProductOnSales, IDS_Header_SpecialOffer %>"
                            ItemStyle-Width="41" SortExpression="SpecialOffer" DataField="SpecialOffer" CommandName="SpecialOffer" ItemStyle-HorizontalAlign="Center"/>
                        <Hishop:YesNoImageColumn HeaderText="<%$ Resources:ProductOnSales, IDS_Header_Latest %>"
                            ItemStyle-Width="41" SortExpression="Latest" DataField="Latest" CommandName="Latest" ItemStyle-HorizontalAlign="Center"/>
                        <Hishop:ProductEditColumn ItemStyle-Width="30" />
                    </Columns>
                </Hishop:CustomGridView>
                <!--分页开始-->
                <div class="grdGroupTabhead">
                    <UI:Pager runat="server"  RunningMode="Get" ID="pager" />
                </div>
    </div>
</div>
            </SkinTemplate>
            </Hishop:ProductOnSales>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>