﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../Utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../Utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../Utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="PageTitleArea">
        <div class="PageTitle">
            <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ProductTypes, IDS_PageTitle %>"></asp:Literal>
        </div>
        <div style="width: 80%;">
            <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:ProductTypes, IDS_PageDesc %>"></asp:Literal>
        </div>
    </div>
    <Hishop:ProductTypes ID="productTypes" runat="server">
        <SkinTemplate>
            <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
            <fieldset class="AdminSearchform">
            <legend><asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:Resources, Utilty_Search_Title %>"></asp:Literal></legend>      
             <table width="65%" border="0" cellspacing="0" cellpadding="0" style="margin-left:18px">
                <tr>
                    <td class="searchTableLeftTD">
                        <nobr> <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:ProductTypes, IDS_Lable_TypeName %>"></asp:Label>：</nobr>
                    </td>
                    <td class="searchTableControlTD">
                       <Hishop:DefaultButtonTextBox ID="txtSearchText" runat="server" Button="btnSearchButton" /></td>
                    <td class="searchTableLeftTD">
                        <nobr> <asp:Label ID="lblGiftType" runat="server" Text="<%$ Resources:Resources, Utilty_Search_PageSize %>"></asp:Label>：</nobr>
                        </td>
                    <td class="searchTableControlTD">
                     <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server"  />
                    </td>
                     <td>
                        <asp:Button ID="btnSearchButton" runat="server"  Text="<%$ Resources:Resources, IDS_Button_ChaXun %>" CssClass="inp_L1"></asp:Button>
                    </td>
                </tr>    
            </table>          
            </fieldset>
            <div class="grdHeaderStyle">
                <ul>
                    <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                        <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
                    <li class="spirtLines">|</li>
                    <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                        <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
                    <li class="spirtLines">|</li>
                    <li class="userGroupDelCheck">
                        <Hishop:DeleteImageLinkButton ID="lkbDelectCheck"  runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
                </ul>
            </div>
            <Hishop:CustomGridView ID="grdProductTypes" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="TypeId" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                <Columns>
                    <Hishop:CheckBoxColumn ReadOnly="true" />
                    <asp:TemplateField HeaderText="<%$ Resources:ProductTypes, IDS_Lable_TypeName %>">
                        <ItemTemplate>
		                    <asp:Label ID="lblTypeName" runat="server" Text='<%# Eval("TypeName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="txtTypeName" runat="server" Text='<%# Eval("TypeName") %>'></asp:TextBox>
                            <asp:LinkButton ID="lkbUpdate" Width="30" CssClass="SmallCommonTextButton" runat="server" CommandName="Update" Text="<%$ Resources:Resources, IDS_Button_Update %>" ></asp:LinkButton>
                            <asp:LinkButton ID="lkbCancel" Width="30" CssClass="SmallCommonTextButton" runat="server" CommandName="Cancel" Text="<% $Resources:Resources, IDS_Button_Cancel %>"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Resources:ProductTypes, IDS_Lable_Remark %>">
                        <ItemTemplate>
                            <asp:Label ID="lblRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="txtRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                             <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="20%">
                                 <ItemStyle CssClass="handleRightSelect"/>
                                 <ItemTemplate>
			                         <asp:HyperLink ID="lkbViewAttribute" CssClass="SmallCommonTextButton" runat="server" Text="<%$ Resources:ProductTypes, IDS_Link_Attribute %>" NavigateUrl='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_attribute",Eval("TypeId"))%>' ></asp:HyperLink>
			                         <asp:LinkButton ID="lkbEdit" CssClass="SmallCommonTextButton" runat="server" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit%>"></asp:LinkButton>
			                         <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" ID="lkbDelete" runat="server" CommandName="Delete"  Text="<%$ Resources:Resources, IDS_Button_Delete %>" />
                                 </ItemTemplate>
                             </asp:TemplateField>  
                </Columns>
            </Hishop:CustomGridView>
            <div class="grdGroupTabhead">
            <UI:Pager runat="server" ListToPaging="grdProductTypes" ID="pager" />
        </div>
        <div class="grdHeaderStyle" style="cursor: pointer;" onclick="expItemsTable('addItemsTable');">
            <ul>
                <li class="addArticleClass">
                    <asp:Label ID="lblAddArticleCategoryiesTitle" Text="<%$ Resources:ProductTypes, IDS_Lable_AddType %>" runat="server"></asp:Label>
                </li>
            </ul>
        </div>
        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable">
                    <tr>
                        <td class="leftTD">
                            <asp:Literal ID="lblTypeName" Text="<%$ Resources:ProductTypes, IDS_Lable_TypeName %>" runat="server"></asp:Literal>：
                        </td>
                        <td class="rightTD">
                            <asp:TextBox ID="txtTypeName" CssClass="input_short" runat="server"></asp:TextBox>
                        </td>
                        <td class="rightTD">
                            <div id="txtTypeNameTip" runat="server">
                            </div>
                            <Hishop:ValidateTarget ID="ValidateTarget1" runat="server" ContainerId="ValidatorContainer"
                                ControlToValidate="txtTypeName" Description="<%$ Resources:ProductTypes, IDS_Help_TypeMane %>"
                                Nullable="false" FocusMessage="<%$ Resources:ProductTypes, IDS_Help_TypeMane %>">
                                <Validators>
                                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:ProductTypes, IDS_Help_TypeMane %>"
                                        LowerBound="1" UpperBound="100" />
                                </Validators>
                            </Hishop:ValidateTarget>
                        </td>
                    </tr>
                    <tr>
                        <td class="leftTD">
                            <asp:Literal ID="lblRemark" Text="<%$ Resources:ProductTypes, IDS_Lable_Remark %>" runat="server"></asp:Literal>：
                        </td>
                        <td class="rightTD">
                            <asp:TextBox ID="txtRemark" CssClass="input_short" runat="server"></asp:TextBox>
                        </td>
                        <td class="rightTD">
                            <div id="txtRemarkTip" runat="server">
                            </div>
                            <Hishop:ValidateTarget ID="ValidateTarget2" runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtRemark" Description="<%$ Resources:ProductTypes, IDS_Help_Remark %>"
                                Nullable="true" FocusMessage="">
                                <Validators>
                                    <Hishop:InputStringClientValidator ErrorMessage="" LowerBound="1" UpperBound="100" />
                                </Validators>
                            </Hishop:ValidateTarget>
                        </td>
                    </tr>
                    <tr>
                        <td class="bottonLeftTD">
                            &nbsp;
                        </td>
                        <td class="rightTD" colspan="2">
                            <asp:Button ID="btnAddProductType" runat="server" OnClientClick="return PageIsValid();" Text="<%$ Resources:Resources, IDS_Button_Add%>" CssClass="inp_L1" />
                            <asp:Button ID="btnCancel" runat="server" Text="<%$ Resources:Resources, IDS_Button_Cancel%>" CssClass="inp_L1" />
                        </td>
                    </tr>
                </table>
        </SkinTemplate>
    </Hishop:ProductTypes>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
    </div>
    <br />
    <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
