﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<%@ Import Namespace="System.Web.UI.WebControls" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div class="PageTitleArea">
            <div class="PageTitle">
                <asp:Literal ID="litManagerTop" runat="server" Text="未分类商品" />
            </div>
            <div style="width: 80%;">
                <asp:Literal ID="litManagerDisciption" runat="server" Text="主类是在上架商品时为商品选择的分类，您可以将未分类的商品重新分类，或者将商品添加到多个分类" />
            </div>
        </div>
        <Hishop:ProductUnclassified runat="server">
            <SkinTemplate>
                <!-- 操作提示 -->
                <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
                <Hishop:ProductSearch runat="server" ID="productSearch">
                    <SkinTemplate>
                        <fieldset class="AdminSearchform">
                            <legend>
                                <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_litSelectQuery %>"></asp:Literal></legend>
                            <table width="55%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
                                <tr>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                            <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <asp:TextBox ID="txtSearchText" runat="server" Width="110" ToolTip="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText_ToolTip %>"></asp:TextBox>
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                            <asp:Label ID="lblCategory" runat="server" Text="<%$ Resources:ProductSearch, IDS_FromField_lblCategory %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:ProductCategoriesDropDownList ID="dropCategories" NullToDisplay="未分类商品" runat="server" />
                                    </td>
                                    <td class="searchTableLeftTD">
                                        <nobr>
                            <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblPageSize %>"></asp:Label>：</nobr>
                                    </td>
                                    <td class="searchTableControlTD">
                                        <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
                                    </td>
                                    <td class="searchTableControlTD">
                                        <asp:Button ID="btnSearch" runat="server" Text="<%$ Resources:ProductSearch, IDS_Button_Search %>"
                                            CssClass="inp_L1" />
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </SkinTemplate>
                </Hishop:ProductSearch>
                <div class="grdHeaderStyle">
                    <ul>
                        <li class="userGroupCheckAll">
                            <asp:LinkButton ID="Button2" runat="server" OnClientClick="CheckClickAll();return false;"
                                Text="<%$ Resources:ProductOnSales, IDS_Button_CheckAll %>" />
                        </li>
                        <li class="spirtLines">|</li>
                        <li class="userGroupReverseCheck">
                            <asp:LinkButton ID="CheckReverse" runat="server" OnClientClick="CheckReverse();return false;"
                                Text="<%$ Resources:ProductOnSales, IDS_Button_CheckReverse %>" />
                        </li>
                        <li class="spirtLines">|</li>
                        <li class="userGroupDelCheck">
                            <Hishop:ImageLinkButton ID="btnDelete" OnClientClick="" runat="server" Text="删除商品"></Hishop:ImageLinkButton></li>
                    </ul>
                </div>
                <div class="grdGroupList">
                    <div class="grdGroupListLi">
                        <Hishop:CustomGridView runat="server" ID="grdProducts" CssClass="GridNoBorder" Width="100%"
                            AllowSorting="true" ShowOrderIcons="true" GridLines="None" DataKeyNames="ProductId"
                            SortOrder="Desc" SortOrderBy="AddedDate" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle"
                            AutoGenerateColumns="false" ForeColor="#333333">
                            <RowStyle CssClass="grdrow" ForeColor="#333333" />
                            <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
                            <HeaderStyle BackColor="#EEF8FF" Height="25" CssClass="GridViewHeaderStyle" Font-Bold="True"
                                ForeColor="#314E9F" />
                            <AlternatingRowStyle BackColor="White" />
                            <Columns>
                                <Hishop:CheckBoxField HeadWidth="35" />
                                <asp:TemplateField ItemStyle-Width="8px">
                                    <ItemTemplate>
                                        <Hishop:Common_ProductThumbnail ID="Common_ProductThumbnail1" runat="server" DataField="ThumbnailsUrl" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField SortExpression="ProductName" HeaderText="<%$ Resources:ProductOnSales, IDS_Header_ProductName %>">
                                    <ItemTemplate>
                                        <Hishop:ProductNavigationDetails ProductName='<%# Eval("ProductName") %>' ProductId='<%# Eval("ProductId") %>' runat="server" />
                                        <asp:Label ID="lblThumbUrl" runat="server" Text='<%# Eval("ThumbnailsUrl") %>' Style="display: none;"></asp:Label>
                                        <asp:Label ID="lblInFocusUrl" runat="server" Text='<%# Eval("InFocusImageUrl") %>'
                                            Style="display: none;"></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="所属分类">
                                    <ItemTemplate>
                                        <div>
                                            <nobr><span style="font-size:13px;">主类：<span style="color:Blue;"><asp:Literal runat="server" ID="litMainCategory" /></span></span></nobr>
                                        </div>
                                        <div>
                                            <asp:GridView ID="grdExtendCategories" DataKeyNames="CategoryId" GridLines="None"
                                                ShowHeader="false" ShowFooter="false" AutoGenerateColumns="false" runat="server">
                                                <Columns>
                                                    <asp:BoundField DataField="Name" HtmlEncode="false" />
                                                    <asp:CommandField ButtonType="Link" DeleteText="[移除分类]" ShowDeleteButton="true" />
                                                </Columns>
                                            </asp:GridView>
                                        </div>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="添加扩展分类" ItemStyle-Width="50px">
                                    <ItemTemplate>
                                        <Hishop:ProductCategoriesDropDownList ID="dropAddToCategories" NullToDisplay="添加到分类"
                                            runat="server" AutoPostBack="true" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </Hishop:CustomGridView>
                        <!--分页开始-->
                        <div class="grdGroupTabhead">
                            <UI:Pager runat="server" ListToPaging="grdProducts" ID="pager" />
                        </div>
                    </div>
                </div>
                <div style="text-align: center;">
                    <div style="width: 600px; padding: 8px; padding-bottom: 15px; border: #A6DAFF 1px solid;
                        background: #EEF8FF; color: #404040;">
                        <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <nobr>
                    <span style="font-size:15px;">移动商品到分类：</span><Hishop:ProductCategoriesDropDownList ID="dropMoveToCategories" NullToDisplay="未分类商品" runat="server" />
                    <asp:Button runat="server" ID="btnMove" Text="转移主类" />
                    </nobr>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <br />
                                    批量转移商品的主类或者将商品转移到未分类，在转移以前请先选择要转移的商品。
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </SkinTemplate>
        </Hishop:ProductUnclassified>
    </div>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright runat="server" />
    </div>
    <br />
    </form>
</body>
</html>
