﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>           

            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:AddCoupons,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:AddCoupons,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
             <Hishop:AddCoupon ID="AddCoupon" runat="server">
                <SkinTemplate>
                    <div id="addCoupons"><Hishop:StatusMessage id="Status" runat="server" Visible="False" /></div>
                    <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                        <Hishop:CouponView id="addCoupon" runat="server">
                            <SkinTemplate>
                                <tr>
                                    <td colspan="3">
                                        <asp:Label ID="lblEditCouponId" runat="server" style="display:none"></asp:Label>
                                    </td>
                                </tr>
                                <!--优惠券名称(编号在名称前且隐藏)-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="lblCouponName" Text='<%$Resources:CouponView,IDS_FormField_CouponName %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtCouponName" runat="server" Width="280px"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtCouponNameTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidateCouponName"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtCouponName" 
                                                 Description="<%$ Resources:CouponView, IDM_help01 %>" Nullable="false">
                                            <Validators>
                                                 <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help01%>" LowerBound="1" UpperBound="100"/>
                                            </Validators>
                                        </Hishop:ValidateTarget>
                                    </td>
                                </tr>
                                <!--满足-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="lblAmount" Text='<%$Resources:CouponView,IDS_FormField_Amount %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtAmount" runat="server"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtAmountTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidatetAmount"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtAmount" 
                                                  Description="<%$ Resources:CouponView, IDM_help05%>" Nullable="false">
                                            <Validators>
                                                  <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help05%>" />
                                                  <Hishop:MoneyRangeClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help05%>" MinValue="0"/>
                                            </Validators>
                                        </Hishop:ValidateTarget>
                                    </td>
                                </tr>
                                <!--面值-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="lblDiscountValue" Text='<%$Resources:CouponView,IDS_FormField_DiscountValue %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtDiscountValue" runat="server"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtDiscountValueTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidateDiscountValue"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtDiscountValue" 
                                                  Description="<%$ Resources:CouponView, IDM_help06%>" Nullable="false">
                                            <Validators>
                                                  <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help06%>" />
                                                  <Hishop:MoneyRangeClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help06%>" MinValue="0" />
                                            </Validators>
                                        </Hishop:ValidateTarget> 
                                    </td>
                                </tr>
                                <!--有效期-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="lblDateTo" Text='<%$Resources:CouponView,IDS_FormField_DateTo %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtDateTo" runat="server"></asp:TextBox><asp:Literal ID="Literal1" Text='<%$Resources:CouponView,IDS_FormField_Day %>' runat="server"></asp:Literal></td>
                                    
                                    <td class="rightTD">
                                        <div id="txtDateToTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidateDateTo"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtDateTo" 
                                                  Description="<%$ Resources:CouponView, IDM_help03%>" Nullable="false">
                                            <Validators>
                                                  <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help03%>" />
                                                  <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help03%>" MinValue="1" MaxValue="1000000" />
                                            </Validators>
                                        </Hishop:ValidateTarget> 
                                    </td>
                                </tr>
                                <!--使用次数-->
                                <tr >
                                    <td class="leftTD"><asp:Literal ID="lblEnabledTimes" Text='<%$Resources:CouponView,IDS_FormField_EnabledTimes %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtEnabledTimes" runat="server" Text="1"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtEnabledTimesTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidateEnabledTimes"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtEnabledTimes" 
                                                  Description="<%$ Resources:CouponView, IDM_help02%>" Nullable="false">
                                            <Validators>
                                                  <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help02%>" />
                                                  <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:CouponView, IDM_help02%>" MinValue="1" MaxValue="2147483647" />
                                            </Validators>
                                        </Hishop:ValidateTarget> 
                                    </td>
                                </tr>
                                <!--简单描述-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="lblDesc" Text='<%$Resources:CouponView,IDS_FormField_Description %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD" colspan="2">
                                        <FCKeditorV2:FCKeditor id="fckDesc" runat="server" Width="99%" EnableXHTML="true" EnableSourceXHTML="true" basepath="~/FCKeditor/" height="200px" ></FCKeditorV2:FCKeditor>
                                        <div class="msgNormal"><asp:Literal ID="Literal3" runat="server" Text="<%$Resources:CouponView,IDM_help04 %>" /></div>
                                    </td>
                                </tr>  
                            </SkinTemplate>
                        </Hishop:CouponView>
                        <tr>
                            <td class="bottonLeftTD">&nbsp;</td>
                            <td colspan="2" class="rightTD">
                                <table>
                                    <tr>
                                        <td valign="top"><asp:Button ID="btnAddCoupons" OnClientClick="return PageIsValid();" runat="server" Text="<%$ Resources:Resources, IDS_Button_Add %>" CssClass="inp_L1" /></td>
                                        <td><div class="return_inp"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_newcoupons")%>'>
                                            <asp:Literal ID="lblreturn" runat="server" Text="<%$ Resources:AddCoupons ,IDS_ReturnCoupons %>" /></a></div>
                                        </td>
                                    </tr>
                                 </table>                    
                            </td>
                            <td class="rightTD">&nbsp;</td>
                        </tr>
                    </table>
                </SkinTemplate>
             </Hishop:AddCoupon>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>