﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
           
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:AddGift,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:AddGift,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:AddGift ID="AddGift" runat="server">
            <SkinTemplate>

        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />


<!--------GiftView of control -------->
<Hishop:GiftView ID="giftView" runat="server" >
<SkinTemplate>
<table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
    <tr>
        <td class="leftTD">
            <img src="../images/jiaoyiIcon.gif" alt="" /></td>
        <td class="rightTD" colspan="2">
            <asp:Literal runat="server" Text="<%$ Resources:GiftView,IDS_FormField_Info %>"></asp:Literal></td>
    </tr>
    <!--名称-->
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblGiftName" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblGiftName %>"></asp:Literal></td>
        <td class="rightTD">
            <label>
                <asp:TextBox ID="txtGiftName" runat="server" Width="230px" ></asp:TextBox>
            </label>
        </td>
        <td class="rightTD">
            <div id="txtGiftNameTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTargetGiftName" runat="server" ControlToValidate="txtGiftName"
                ContainerId="ValidatorContainer" Description="<%$ Resources:GiftView,IDS_Message_Gift_Name %>">
                <Validators>
                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_Message_Gift_Name %>"
                        LowerBound="1" UpperBound="100" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <!--礼品图片-->
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblThumbnailsUrl" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_GiftImage %>"></asp:Literal>：</td>
        <td class="rightTD">
            <asp:FileUpload ID="imageUpload" runat="server" Width="250px" />
        </td>
        <td class="rightTD">
            <div class="msgNormal">
                <Hishop:UploadImageMessageLabel runat="server" ID="uploadMessage"></Hishop:UploadImageMessageLabel>
            </div>
        </td>
    </tr>
    <!--库存-->
    <tr id="tblrStock" runat="server">
        <td class="leftTD">
            <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblStockNum %>"></asp:Literal></td>
        <td class="rightTD">
            <asp:TextBox ID="txtStock" runat="server" Width="80px" MaxLength="100"></asp:TextBox></td>
        <td class="rightTD">
            <div id="txtStockTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTargetStock" runat="server" ControlToValidate="txtStock"
                Nullable="true" ContainerId="ValidatorContainer" Description="<%$ Resources:GiftView,IDS_Message_Gift_Stock %>">
                <Validators>
                    <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_Message_Gift_Stock %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <!--计量单位-->
    <tr id="tblrUnit" runat="server">
        <td class="leftTD">
            <asp:Literal ID="lblUnit" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblUnit %>"></asp:Literal></td>
        <td class="rightTD">
            <asp:TextBox ID="txtUnit" runat="server" Width="80px"></asp:TextBox></td>
        <td class="rightTD">
            <div id="txtUnitTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTargetUnit" runat="server" ControlToValidate="txtUnit"
                Nullable="true" ContainerId="ValidatorContainer" Description="<%$ Resources:GiftView,IDS_FormField_lblUnitHelp %>">
                <Validators>
                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_FormField_lblUnitHelp %>"
                        UpperBound="10" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <!--重量-->
    <tr id="tblrWeight" runat="server">
        <td class="leftTD">
            <asp:Literal ID="lblWeight" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblWeight %>"></asp:Literal></td>
        <td class="rightTD">
            <asp:TextBox ID="txtWeight" runat="server" Width="80px"></asp:TextBox>
            <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblDanwei %>"></asp:Literal>
        </td>
        <td class="rightTD">
            <div id="txtWeightTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTargetWeighte" runat="server" ControlToValidate="txtWeight"
                Nullable="true" ContainerId="ValidatorContainer" Description="<%$ Resources:GiftView,IDS_Message_Gift_Weight %>">
                <Validators>
                    <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_Message_Gift_Weight %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <!--成本价-->
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblCostPrice" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblCostPrice %>"></asp:Literal></td>
        <td class="rightTD">
            <asp:TextBox ID="txtCostPrice" runat="server"></asp:TextBox>
        </td>
        <td class="rightTD">
            <div id="txtCostPriceTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTargetCostPrice" runat="server" ContainerId="ValidatorContainer"
                ControlToValidate="txtCostPrice" Nullable="true" Description="<%$ Resources:GiftView,IDS_Message_Gift_CostPrice %>">
                <Validators>
                    <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_Message_Gift_CostPrice %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <!--市场价-->
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblMarketPrice" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblMarketPrice %>"></asp:Literal></td>
        <td class="rightTD">
            <label>
                <asp:TextBox ID="txtMarketPrice" runat="server"></asp:TextBox>
            </label>
        </td>
        <td class="rightTD">
            <div id="txtMarketPriceTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTargetMarketPrice" runat="server" ContainerId="ValidatorContainer"
                ControlToValidate="txtMarketPrice" Nullable="true" Description="<%$ Resources:GiftView,IDS_Message_Gift_MarketPrice %>">
                <Validators>
                    <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_Message_Gift_MarketPrice %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <!--销售价-->
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblSalePrice" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblSalePrice %>"></asp:Literal></td>
        <td class="rightTD">
            <label>
                <asp:TextBox ID="txtSalePrice" runat="server"></asp:TextBox>
            </label>
        </td>
        <td class="rightTD">
            <div id="txtSalePriceTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTargetSalePrice" runat="server" ContainerId="ValidatorContainer"
                ControlToValidate="txtSalePrice" Nullable="true" Description="<%$ Resources:GiftView,IDS_Message_Gift_SalePrice %>">
                <Validators>
                    <Hishop:InputMoneyClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_Message_Gift_SalePrice %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
</table>

<!--礼品描述-->
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="formTableList">
    <tr>
        <td class="leftTD">
            <img src="../images/jiaoyiIcon.gif" alt="" /></td>
        <td class="rightTD" colspan="2">
            <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_Desc %>"></asp:Literal></td>
    </tr>
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblShortDescription" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblShortDescription %>"></asp:Literal></td>
        <td class="rightTD">
            <asp:TextBox ID="txtShortDescription" runat="server" TextMode="MultiLine" Width="250px" Height="70px"></asp:TextBox>
        </td>
        <td class="rightTD">
         <div id="txtShortDescriptionTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTarget4" runat="server" ControlToValidate="txtShortDescription" Nullable="true"
                ContainerId="ValidatorContainer" Description="<%$ Resources:GiftView,IDS_FormField_lblShortDesc %>">
                <Validators>
                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_FormField_lblShortDesc %>"
                         UpperBound="1000" />
                </Validators>
            </Hishop:ValidateTarget>
           
        </td>
    </tr>
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblLongDescription" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblLongDescription %>"></asp:Literal></td>
        <td class="rightTD" colspan="2">
            <FCKeditorV2:FCKeditor ID="fcDescription" runat="server" Width="100%" EnableXHTML="true"
                EnableSourceXHTML="true" BasePath="~/FCKeditor/" Height="200px">
            </FCKeditorV2:FCKeditor>
        </td>
    </tr>
</table> 
<!--礼品优化-->
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="formTableList">
    <tr>
        <td class="leftTD">
            <img src="../images/jiaoyiIcon.gif" alt="" /></td>
        <td class="rightTD" colspan="2">
            <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_Other %>"></asp:Literal></td>
    </tr>
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblTitle" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblTitle %>"></asp:Literal></td>
        <td class="rightTD">
            <asp:TextBox ID="txtGiftTitle" Width="230px" runat="server"></asp:TextBox>
        </td>
        <td class="rightTD">
            <div id="txtGiftTitleTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTarget3" runat="server" ControlToValidate="txtGiftTitle"
                Nullable="true" ContainerId="ValidatorContainer" Description="<%$ Resources:GiftView,IDS_FormField_lblGiftTitleHelp %>">
                <Validators>
                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_FormField_lblGiftTitleHelp %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblKeywords" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblKeywords %>"></asp:Literal></td>
        <td class="rightTD">
            <asp:TextBox ID="txtTitleKeywords" Width="230px" runat="server"></asp:TextBox>
        </td>
        <td class="rightTD">
            <div id="txtTitleKeywordsTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTarget2" runat="server" ControlToValidate="txtTitleKeywords"
                Nullable="true" ContainerId="ValidatorContainer" Description="<%$ Resources:GiftView,IDS_FormField_TitleKeywords %>">
                <Validators>
                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_FormField_TitleKeywords %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
    <tr>
        <td class="leftTD">
            <asp:Literal ID="lblTitleDescription" runat="server" Text="<%$ Resources:GiftView,IDS_FormField_lblTitleDescription %>"></asp:Literal>
        </td>
        <td class="rightTD">
            <asp:TextBox ID="txtTitleDescription" runat="server" Width="230px"></asp:TextBox></td>
        <td class="rightTD">
            <div id="txtTitleDescriptionTip" runat="server">
            </div>
            <Hishop:ValidateTarget ID="ValidateTarget1" runat="server" ControlToValidate="txtTitleDescription"
                Nullable="true" ContainerId="ValidatorContainer" Description="<%$ Resources:GiftView,IDS_FormField_TitleDescription %>">
                <Validators>
                    <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:GiftView,IDS_FormField_TitleDescription %>" />
                </Validators>
            </Hishop:ValidateTarget>
        </td>
    </tr>
</table>
</SkinTemplate>
</Hishop:GiftView>
<table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
    <tr>
        <td class="bottonLeftTD">
            &nbsp;</td>
        <td class="rightTD">
            <table>
                <tr>
                    <td valign="top">
                        <asp:Button ID="btnCreate" runat="server" Text="<%$ Resources:Resources, IDS_Button_Confirm %>"
                             OnClientClick="return PageIsValid();"
                            CssClass="inp_L1" /></td>
                    <td>
                        <div class="return_inp">
                            <a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManageGifts")%>'>
                                <asp:Literal ID="lblReturn" runat="server" Text="<%$ Resources:EditGift, IDS_FromField_lblReturn %>"></asp:Literal></a>
                        </div>
                    </td>
                </tr>
            </table>
        </td>
        <td class="rightTD">
            &nbsp;</td>
    </tr>
</table>

            </SkinTemplate>
            </Hishop:AddGift>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>