﻿<%@ Page Language="C#" AutoEventWireup="false" ValidateRequest="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>           
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:EditBuyToSend,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:EditBuyToSend,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:EditBuyToSend ID="EditBuyToSend" runat="server">
                <SkinTemplate>
                    <script type="text/javascript">
                        function ResetPager(sender, eventArgs) {
                            CB_Pager.callback();
                        }

                        function showDialog() {
                            if (dialogProducts.get_isShowing()) {
                                dialogProducts.Close();
                            }
                            else {
                                dialogProducts.Show();
                            }
                        }
                    </script>
                    <div id="editBuyToSends"><Hishop:StatusMessage id="Status" runat="server" Visible="False" /></div>
                    <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList">
                        <Hishop:PromoteView id="editpromoteSales" runat="server">
                            <SkinTemplate>
                            <!--促销活动名称(编号在名称前且隐藏)-->
                                <tr>
                                    <td class="leftTD">
                                        <asp:Label ID="lblAddEditActivityId" Style="display: none" runat="server"></asp:Label>
                                        <asp:Literal ID="Literal1" Text='<%$Resources:PromoteView,IDS_FormField_PromoteSalesName %>' runat="server"></asp:Literal>
                                    </td>
                                    <td class="rightTD"><asp:TextBox ID="txtPromoteSalesName" runat="server" Width="200px"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtPromoteSalesNameTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidatePromoteSalesName"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtPromoteSalesName" 
                                                 Description="<%$ Resources:PromoteView, IDM_help01 %>" Nullable="false">
                                            <Validators>
                                                 <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:PromoteView, IDM_help01%>" LowerBound="1" UpperBound="100" />
                                            </Validators>
                                        </Hishop:ValidateTarget>
                                    </td>
                                </tr>
                                <!--开始时间 --> 
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal4" Text='<%$Resources:PromoteView,IDS_FormField_StartTime %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><Hishop:Calendar ID="calendarStart" runat="server" EnableTime="true"/></td>
                                    <td class="rightTD">
                                        <div class="msgNormal">
                                            <asp:Literal ID="Literal3" runat="server" Text="<%$Resources:PromoteView,IDM_help03 %>" />
                                        </div>
                                    </td>             
                                    </tr>
                                <!--结束时间 -->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal5" Text='<%$Resources:PromoteView,IDS_FormField_EndTime %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><Hishop:Calendar ID="calendarEnd" runat="server" EnableTime="true"/></td>
                                    <td class="rightTD">
                                        <div class="msgNormal">
                                                <asp:Literal ID="Literal7" runat="server" Text="<%$Resources:PromoteView,IDM_help04 %>" />
                                        </div>
                                    </td>
                                </tr>
                                <!--促销活动描述 -->  
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal6" Text='<%$Resources:PromoteView,IDS_FormField_Description %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD" colspan="2"><FCKeditorV2:FCKeditor ID="fckDescription" runat="server" Width="99%" EnableXHTML="true" EnableSourceXHTML="true" BasePath="~/FCKeditor/" Height="230px"></FCKeditorV2:FCKeditor></td>
                                </tr>
                            </SkinTemplate>
                        </Hishop:PromoteView>
                        <Hishop:BuyToSendView id="editBuyToSend" runat="server">
                            <SkinTemplate>
                                <!--购买数量-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal1" Text='<%$Resources:BuyToSendView,IDS_FormField_BuyQuantity %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtBuyQuantity" runat="server"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtBuyQuantityTip" runat="server"></div>
                                        <Hishop:ValidateTarget ID="ValidateBuyQuantity"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtBuyQuantity" 
                                                  Description="<%$ Resources:BuyToSendView, IDM_help01%>" Nullable="false">
                                            <Validators>
                                                  <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:BuyToSendView, IDS_ErrorMessage_BuyToSend_BuyQuantity_NotNumber%>" />
                                                  <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:BuyToSendView, IDS_ErrorMessage_BuyToSend_BuyQuantity_Length%>" MinValue="1" MaxValue="9999999" />
                                            </Validators>
                                        </Hishop:ValidateTarget> 
                                    </td>
                                </tr>
                                <!--赠送数量-->
                                <tr>
                                    <td class="leftTD"><asp:Literal ID="Literal2" Text='<%$Resources:BuyToSendView,IDS_FormField_GiveQuantity %>' runat="server"></asp:Literal></td>
                                    <td class="rightTD"><asp:TextBox ID="txtGiveQuantity" runat="server"></asp:TextBox></td>
                                    <td class="rightTD">
                                        <div id="txtGiveQuantityTip" runat="server"></div>
                                            <Hishop:ValidateTarget ID="ValidateGiveQuantity"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtGiveQuantity" 
                                                  Description="<%$ Resources:BuyToSendView, IDM_help02%>" Nullable="false">
                                                <Validators>
                                                  <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:BuyToSendView, IDS_ErrorMessage_BuyToSend_GiveQuantity_NotNumber%>" />
                                                  <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:BuyToSendView, IDS_ErrorMessage_BuyToSend_GiveQuantity_Length%>" MinValue="1" MaxValue="999999" />
                                                </Validators>
                                        </Hishop:ValidateTarget> 
                                    </td>                
                                </tr>
                            </SkinTemplate>
                        </Hishop:BuyToSendView>
                        <tr>
                        <td class="leftTD">
                            <img src="../images/jiaoyiIcon.gif" alt="" /><asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:BuyToSendView, IDS_Label_PromoteProducts%>"></asp:Literal>：</td>
                        <td class="rightTD" colspan="2">
                            <a  style="color:Blue" onclick="showDialog();" ><asp:Literal ID="litCheckProducts" runat="server" Text="<%$ Resources:BuyToSendView, IDS_Label_CheckProducts%>" /></a>
                         </td>
                    </tr>
                        <tr>
                            <td colspan="3" style="padding-left:25px"><asp:Literal ID="litCheckedProducts" runat="server" Text="<%$ Resources:BuyToSendView, IDS_Label_CheckedProducts%>" /></td>
                        </tr>
                        <tr>
                        <td colspan="3" style="padding-left:25px">
                        <div class="grdHeaderStyle">
                            <ul>
                                <li class="userGroupCheckAll"><a  onclick="CheckClickAll()"><asp:Label ID="SelectAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
	                            <li class="spirtLines">|</li>
	                            <li class="userGroupReverseCheck"><a   onclick="CheckReverse()"><asp:Label ID="lblRecerse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
	                            <li class="spirtLines">|</li>
	                            <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lbtnDeleteCheck" runat="server" OnClientClick="" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li> 
                            </ul>   
                        </div>
                        <asp:GridView ID="grdPromoteSales" runat="server" AutoGenerateColumns="False" DataKeyNames="ProductId" Width="100%" CssClass="GridViewStyle" GridLines="None" ShowHeader="true">
                                  <Columns>
                                      <Hishop:CheckBoxColumn  ShowHead="false" Text="<%$ Resources:Resources, IDS_Header_Check %>" HeadWidth="35" ></Hishop:CheckBoxColumn>            
                                      <asp:TemplateField HeaderText="<%$ Resources:BuyToSendView, IDS_Header_ProductName %>">
                                            <ItemTemplate>
                                                <Hishop:SubStringLabel ID="lblPromoteSaleProductName" StrLength="20" StrReplace="..." ToolTip='<%#Eval("ProductName") %>' Text='<%#Eval("ProductName") %>' runat="server"></Hishop:SubStringLabel>
                                            </ItemTemplate>
                                       </asp:TemplateField>
                                        <Hishop:MoneyColumnForAdmin DataField="CostPrice" HeaderText="<%$Resources:BuyToSendView,IDS_Header_CostPrice %>"  />
                                        <Hishop:MoneyColumnForAdmin DataField="MarketPrice" HeaderText="<%$Resources:BuyToSendView,IDS_Header_MarketPrice %>"  />
                                        <Hishop:MoneyColumnForAdmin DataField="SalePrice" HeaderText="<%$Resources:BuyToSendView,IDS_Header_SalePrice %>"  />
                                        <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                            <ItemTemplate>
                                                <Hishop:DeleteImageLinkButton ID="lkbDelete" runat="server"  CommandName="Delete" Text="<%$ Resources:EngagedPromoteSales, IDS_FormField_DeleteEngagedPromoteSal%>" />
                                            </ItemTemplate>
                                       </asp:TemplateField>
                                     </Columns>
                                     <RowStyle CssClass="grdrow"/>
                                     <HeaderStyle CssClass="GridViewHeaderStyle"/>
                                </asp:GridView>
                        <div style="text-align:left">
                            <UI:Pager runat="server"  RunningMode="PostBack" ID="butToSendPager" />
                        </div>
                        <UI:Dialog AnimationType="Live" ShowTransition="Fade" AnimationSlide="ExponentialDecelerate"
                            CloseTransition="Fade" AnimationDuration="600" Modal="false"
                            AllowDrag="true" Alignment="MiddleCentre" Title="<%$ Resources:BuyToSendView, IDS_Label_CheckProducts%>"
                            ID="dialogProducts" runat="server" Width="600">
                            <Content>
                                <table style="width:100%">
                                    <tr>
                                        <td class="searchTableLeftTD"><nobr><asp:Label ID="lblProductTypes" runat="server" Text="<%$ Resources:ProductSearch, IDS_FromField_lblCategory %>"></asp:Label>：</nobr></td>
                                        <td class="searchTableControlTD" colspan="2"><nobr><Hishop:ProductCategoriesDropDownList ID="dropCategories" runat="server" /> </nobr></td>
                                        <td class="searchTableLeftTD"><nobr><asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText %>"></asp:Label>：</nobr></td>
                                        <td class="searchTableControlTD"><asp:TextBox ID="txtSearchText" runat="server" Width="150" ToolTip="<%$ Resources:ProductSearch, IDS_FormField_lblSearchText_ToolTip %>"></asp:TextBox></td>
                                        <td align="left"><input type="button"  value="查询" onclick="grdProducts_ReBindData();"  /></td>
                                    </tr>
                                    <tr>
                                       <td colspan="5">
                                        <UI:CallBack id="CB_Products" ClientSideOnCallbackComplete="ResetPager" CacheContent="false" runat="server" PostState="true" Debug="false">
                                          <Content>
                                           <UI:Grid ID="grdProducts" runat="server" AutoGenerateColumns="False" CssClass="GridNoBorder" CallBackDataKey="ProductId"
                                                CellPadding="4" ForeColor="#333333" GridLines="None" AllowSorting="false" HeaderStyle-CssClass="GridViewHeaderStyle"
                                                Width="100%" RunningMode="Callback" >
                                                <Columns>
                                                       <Hishop:CheckBoxColumn  ShowHead="false" Text="<%$ Resources:Resources, IDS_Header_Check %>" HeadWidth="35" ></Hishop:CheckBoxColumn>            
                                                       <asp:TemplateField HeaderText="<%$ Resources:BuyToSendView, IDS_Header_ProductName %>">
                                                            <ItemTemplate>
                                                                <Hishop:SubStringLabel ID="lblPromoteSaleProductName" StrLength="20" StrReplace="..." ToolTip='<%#Eval("ProductName") %>' Text='<%#Eval("ProductName") %>' runat="server" />
                                                            </ItemTemplate>
                                                       </asp:TemplateField>
                                                       <Hishop:MoneyColumnForAdmin DataField="CostPrice" HeaderText="<%$Resources:BuyToSendView,IDS_Header_CostPrice %>"  />
                                                        <Hishop:MoneyColumnForAdmin DataField="MarketPrice" HeaderText="<%$Resources:BuyToSendView,IDS_Header_MarketPrice %>"  />
                                                        <Hishop:MoneyColumnForAdmin DataField="SalePrice" HeaderText="<%$Resources:BuyToSendView,IDS_Header_SalePrice %>"  />                                        
                                                </Columns>
                                                <RowStyle CssClass="grdrow"/>
                                                <HeaderStyle CssClass="GridViewHeaderStyle"/>
                                           </UI:Grid>
                                          </Content>
                                       </UI:CallBack>
                                        <div style="text-align:left">
                                            <UI:CallBack id="CB_Pager" CacheContent="false" PostState="true" Debug="false" runat="server">
                                            <Content>
                                                <UI:Pager runat="server" ListToPaging="grdProducts" ListToCallBackID="CB_Products" RunningMode="Callback" ID="pager" />
                                            </Content>
                                            </UI:CallBack>
                                        </div>
                                       </td>
                                    </tr>
                                 </table>
                                 <div class="footer">
                                   <asp:Button ID="btnAddProduct" runat="server" Text="<%$ Resources:Resources, IDS_Button_Confirm %>" CssClass="inp_L1" />
                                </div>
                                
                            </Content>
                        </UI:Dialog>
                        </td>
                        </tr>
                        <tr>
                            <td class="bottonLeftTD">&nbsp;</td>
                            <td colspan="2" class="rightTD">
                                <table>
                                    <tr>
                                        <td valign="top"><asp:Button ID="btnEditBuyToSend" OnClientClick="return PageIsValid();" runat="server" Text="<%$ Resources:EditBuyToSend, IDS_Button_Edit %>" CssClass="inp_L1" /></td>
                                        <td><div class="return_inp"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_ManagePromoteSales")%>'>
                                            <asp:Literal ID="lblreturn" runat="server" Text="<%$ Resources:Resources ,IDS_Button_Back %>" /></a></div>
                                        </td>
                                    </tr>
                                 </table>                    
                            </td>
                            <td class="rightTD">&nbsp;</td>
                        </tr>
                    </table>
                </SkinTemplate>
             </Hishop:EditBuyToSend>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
