﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>
           
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:Gifts,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:Gifts,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
            <Hishop:Gifts ID="Gifts" runat="server">
            <SkinTemplate>

        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />


<!------- GiftSearch of control -------->
<Hishop:GiftSearch ID="giftSearch" runat="server" >
<SkinTemplate>
<fieldset class="AdminSearchform">
 <legend><asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:GiftSearch, IDS_FromField_SelectQuery %>"></asp:Literal></legend>      
     <table width="65%" border="0" cellspacing="0" cellpadding="0" style="margin-left:18px">
        <tr>
            <td class="searchTableLeftTD">
                <nobr> <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:GiftSearch, IDS_FromField_SearchText %>"></asp:Label>：</nobr>
            </td>
            <td class="searchTableControlTD">
               <Hishop:DefaultButtonTextBox ID="txtSearchText" runat="server" Button="btnSearchButton"></Hishop:DefaultButtonTextBox></td>
            <td class="searchTableLeftTD">
                <nobr><asp:Label ID="lblISSearchName" runat="server" Text="<%$ Resources:GiftSearch, IDS_FromField_PageSize %>"></asp:Label>：</nobr>
                </td>
            <td class="searchTableControlTD">
               <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
            </td>
            <td>
           <asp:Button ID="btnSearchButton" runat="server"  Text="<%$ Resources:GiftSearch, IDS_Button_Search %>" CssClass="inp_L1"></asp:Button></td>
        </tr>      
    </table>          
 </fieldset>
</SkinTemplate>
</Hishop:GiftSearch>

<div class="grdHeaderStyle">
    <ul>
        <li class="userGroupAddadmin"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_AddGift")%>'>
            <asp:Literal ID="lblAddGift" runat="server" Text="<%$ Resources:Gifts, IDS_FromField_lblAddGift %>"></asp:Literal></a>
        </li>
        <li class="spirtLines">|</li>
        <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
            <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
        <li class="spirtLines">|</li>
        <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
            <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
        <li class="spirtLines">|</li>
        <li class="userGroupDelCheck">
            <Hishop:DeleteImageLinkButton ID="lkbDelectCheck" runat="server" 
                Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>"></Hishop:DeleteImageLinkButton></li>
    </ul>
</div>
        <Hishop:CustomGridView ID="grdGift" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="GiftId" SortOrderBy="GiftId" SortOrder="DESC"
        CssClass="GridViewStyle" GridLines="None" AllowSorting="true"  RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
            <Columns>
                <Hishop:CheckBoxColumn />
                <asp:TemplateField>
                    <ItemTemplate>
                    <Hishop:Common_ProductThumbnail runat="server" EnabledTimestamp="true" AutoResize="true" Width="50px" DataField="ThumbnailsUrl"/>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="<%$ Resources:Gifts, IDS_Header_GiftName %>" SortExpression="Name">
                    <itemtemplate>
	                   <asp:Label ID="lblGiftName" runat="server" Text='<%# Bind("Name") %>'></asp:Label>
                    </itemtemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="<%$ Resources:Gifts, IDS_Header_Stock %>" SortExpression="Stock">
                       <itemtemplate>
                         <div style="float:left;">
                        <asp:TextBox ID="txtStock" runat="server" Text='<%# Eval("Stock") %>' Width="25" ></asp:TextBox>
                        </div>
                        <div style="float:left;padding-top:5px;">
                         <asp:LinkButton ID="stockSet" runat="server" Text="<%$ Resources:Gifts, IDS_Button_Set %>" CommandName="SetStock" CssClass="SmallCommonTextButton" ></asp:LinkButton>
                         </div>
                      </itemtemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="成本价" SortExpression="CostPrice">
                    <itemtemplate>
	                   <asp:Label ID="lblCostPrice" runat="server" Text='<%# Eval("CostPrice")==DBNull.Value ? "-" : Eval("CostPrice") %>'></asp:Label>
                    </itemtemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="销售价" SortExpression="SalePrice">
                    <itemtemplate>
	                   <asp:Label ID="lblSalePrice" runat="server" Text='<%# Eval("SalePrice")==DBNull.Value ? "-" : Eval("SalePrice") %>'></asp:Label>
                    </itemtemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                    <itemstyle width="150px" />
                    <itemtemplate>
			            <asp:LinkButton runat="server"  CssClass="SmallCommonTextButton" ID="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit %>" CommandName="Edit" />
			            <Hishop:DeleteImageLinkButton  CssClass="SmallCommonTextButton" runat="server" ID="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete" ></Hishop:DeleteImageLinkButton>
                    </itemtemplate>
                </asp:TemplateField>
            </Columns>
        </Hishop:CustomGridView>
        <div class="grdGroupTabhead">
            <UI:Pager runat="server" ListToPaging="grdGift" ID="pager" />
        </div>

            </SkinTemplate>
            </Hishop:Gifts>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>

