﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>         
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:SendCouponToUsers,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:SendCouponToUsers,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:SendCouponToUsers ID="SendCouponToUsers" runat="server">
                <SkinTemplate>
                    <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
                    <div class="Content">
                        <Hishop:MemberSearch ID="memberSearch" runat="server">
                            <SkinTemplate>
                            <fieldset class="AdminSearchform">
                                <legend>
                                    <asp:Literal ID="litSelectQuery" runat="server" Text="<%$ Resources:MemberSearch, IDS_FromField_litSelectQuery %>"></asp:Literal></legend>
                                <table width="75%" border="0" cellspacing="0" cellpadding="0" style="margin-left: 18px">
                                    <tr>
                                        <td class="searchTableLeftTD">
                                            <nobr>
                                                <asp:Label ID="lblSearchText" runat="server" Text="<%$ Resources:MemberSearch, IDS_FromField_Keywords %>"></asp:Label>：</nobr>
                                        </td>
                                        <td class="searchTableControlTD">
                                            <asp:TextBox ID="txtSearchText" runat="server"></asp:TextBox></td>
                                        <td class="searchTableLeftTD">
                                            <nobr>
                                                <asp:Label ID="lblMemberRank" runat="server" Text="<%$ Resources:MemberSearch, IDS_FromField_lblMemberRank %>"></asp:Label>：</nobr>
                                        </td>
                                        <td class="searchTableControlTD">
                                            <Hishop:MemberRankDropDownList ID="rankList" runat="server" AllowNull="true" NullToDisplay="<%$ Resources:MemberSearch, IDS_MemberRankDropDownList_NullText %>" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="searchTableLeftTD">
                                            <nobr>
                                                <asp:Label ID="lblUserState" runat="server" Text="<%$ Resources:MemberSearch, IDS_FromField_lblUserState %>"></asp:Label>：</nobr>
                                        </td>
                                        <td class="searchTableControlTD">
                                            <Hishop:AccountStatusDropDownList ID="dropUserStateList" runat="server" />
                                        <td class="searchTableLeftTD">
                                            <nobr>
                                                <asp:Label ID="lblPageSize" runat="server" Text="<%$ Resources:MemberSearch, IDS_FromField_PageSize %>"></asp:Label>：</nobr>
                                        </td>
                                        <td class="searchTableControlTD">
                                            <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
                                        </td>
                                        <td class="bottonTD">
                                            <asp:Button ID="btnSearchButton" runat="server" Text="<%$ Resources:MemberSearch, IDS_Button_Search %>"
                                                CssClass="inp_L1" />
                                        </td>
                                    </tr>
                                </table>
                            </fieldset>
                            </SkinTemplate>
                        </Hishop:MemberSearch> 
                        <div class="grdHeaderStyle">
			                          <ul>
			                            <li class="_return"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_newcoupons")%>'><asp:Label ID="lblReturnNewCoupons" Text='<%$Resources:AddCoupons,IDS_ReturnCoupons %>' runat="server" /></a></li>
			                            <li class="spirtLines">|</li>
			   	                        <li class="userGroupCheckAll"><a  href="#" onclick="CheckClickAll()" ><asp:Label ID="SelectAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
			                            <li class="spirtLines">|</li>
			                            <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()"><asp:Label ID="lblRecerse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
			                            <li class="spirtLines">|</li>
			                            <li class="userGroupDelCheck"><asp:LinkButton ID="lbtnSendCouponToUser" runat="server" Text="<%$ Resources:SendCouponToUsers, IDS_FormField_SendCouponToUsers %>"></asp:LinkButton></li> 
			                            <li class="spirtLines">|</li>
			                            <li class="userGroupDelCheck"><asp:LinkButton ID="lbtnSendCouponToSearchUser" runat="server" Text="<%$ Resources:SendCouponToUsers, IDS_FormField_SendCouponToSearchUsers %>"></asp:LinkButton></li> 
			                          </ul>   
                        </div>
                        <div class="FormArea">
                             <table border="0" cellpadding="0" cellspacing="0" style="width:100%">
                                 <tr>
                                    <td>
                                       <Hishop:CustomGridView ID="grdMemberList" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="hi_UserID" CssClass="GridViewStyle" GridLines="None"
                                        RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" AllowSorting="true">
                                          <Columns> 
                                                <Hishop:CheckBoxColumn  ShowHead="false"  Text="<%$ Resources:Resources, IDS_Header_Check %>"></Hishop:CheckBoxColumn>            
                                                <asp:BoundField DataField="UserName" HeaderText="<%$Resources:SendCouponToUsers,IDS_FormField_UserName %>" SortExpression="UserName" />
                                                <asp:BoundField DataField="Email" HeaderText="<%$Resources:SendCouponToUsers,IDS_FormField_Email %>" SortExpression="Email" />
                                                <asp:TemplateField HeaderText="<%$ Resources:ManageMembers, IDS_Header_UserRank %>">
                                                    <ItemTemplate>
                                                        <Hishop:Private_UserMemberRank  runat="server" />
                                                    </ItemTemplate>
                                                </asp:TemplateField>  
                                                <asp:TemplateField HeaderText="<%$ Resources:SendCouponToUsers, IDS_FormField_DateCreated %>">
                                                     <ItemTemplate>
                                                        <Hishop:FormatedTimeLabel ID="lblCreateDate" Time='<%# Bind("CreateDate") %>' runat="server" ></Hishop:FormatedTimeLabel>
                                                     </ItemTemplate>
                                                 </asp:TemplateField> 
                                          </Columns>
                                        </Hishop:CustomGridView>
			                            <div class="grdGroupTabhead">
                                            <UI:Pager runat="server" ListToPaging="grdMemberList" ID="pager" />
                                        </div>	
                                    </td>
                                 </tr>
                             </table>      
                        </div>  
                    </div>
                </SkinTemplate>
            </Hishop:SendCouponToUsers>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
