﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>

<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>         
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="litManagerTop" runat="server" Text="<%$ Resources:OrderLookupLists, IDS_PageTitle %>" ></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="litManagerDisciption" runat="server" Text="<%$ Resources:OrderLookupLists, IDS_PageDesc %>" ></asp:Literal>
                </div>
            </div>
            <Hishop:OrderLookupLists ID="OrderLookupLists" runat="server">
                <SkinTemplate>
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdGroupFormList">
    <div class="grdHeaderStyle">
        <ul>
            <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupDelCheck">
                <Hishop:DeleteImageLinkButton ID="lkbDelectCheck" runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
        </ul>
    </div>
            <asp:GridView ID="grdOrderLookupList" runat="server" AutoGenerateColumns="false"
                ShowHeader="true" DataKeyNames="LookupListId" CssClass="GridViewStyle" GridLines="None"
                RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                <Columns>
                    <Hishop:CheckBoxColumn ReadOnly="true" />
                    <asp:TemplateField HeaderText="<%$ Resources:OrderLookupLists, IDS_Header_SelectName %>"
                        ItemStyle-Width="250px">
                        <ItemTemplate>
		                     <asp:Label ID="lblLookupList" runat="server" Text='<%# Eval("Name") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="txtLookupListName" runat="server" Text='<%# Globals.HtmlDecode(Convert.ToString(Eval("Name"))) %>'></asp:TextBox>
                            <asp:LinkButton ID="Update" CssClass="SmallCommonTextButton" runat="server" CommandName="Update" Text="<%$ Resources:Resources, IDS_Button_Update %>"></asp:LinkButton>
                            <asp:LinkButton ID="Cancel" CssClass="SmallCommonTextButton" runat="server" CommandName="Cancel" Text="<% $Resources:Resources, IDS_Button_Cancel %>"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Resources:OrderLookupLists, IDS_Header_SelectMode %>">
                        <ItemTemplate>
                            <Hishop:SelectModeDropDownList ID="dropSelectMode" runat="server" SelectedValue='<%# Eval("SelectMode") %>'
                                RepeatDirection="Horizontal" Enabled="false">
                            </Hishop:SelectModeDropDownList>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <Hishop:SelectModeDropDownList ID="dropEditSelectMode" runat="server" SelectedValue='<%# Eval("SelectMode") %>'
                                RepeatDirection="Horizontal">
                            </Hishop:SelectModeDropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Resources:OrderLookupLists, IDS_Header_Description %>">
                        <ItemTemplate>
                             <span style="word-break:break-all;">
                            <asp:Label ID="lblDescription" runat="server" Text='<%# Eval("Description") %>'></asp:Label></span>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="txtEditDescription" runat="server" Text='<%# Globals.HtmlDecode(Convert.ToString(Eval("Description"))) %>'></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                                <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" HeaderStyle-Width="30%">
                                    <ItemStyle/>
                                    <ItemTemplate>
			                             <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_orderlookupItem",Eval("LookupListId")) %>' class="SmallCommonTextButton"><asp:Literal ID="lblManagerText" runat="server" Text="<%$ Resources:OrderLookupLists, IDS_Header_ListItem %>"></asp:Literal></a>
			                             <asp:LinkButton ID="Edit" runat="server" CssClass="SmallCommonTextButton" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit%>"></asp:LinkButton>
		                                 <Hishop:DeleteImageLinkButton ID="lkbDelete" CssClass="SmallCommonTextButton" runat="server" CommandName="Delete"  Text="<%$ Resources:Resources, IDS_Button_Delete %>" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                </Columns>
            </asp:GridView>
</div>
<!--添加可选项开始-->
<div class="grdHeaderStyle" style="cursor: pointer;" onclick="expItemsTable('addItemsTable');">
    <ul>
        <li class="addProductTmpt">
            <asp:Literal ID="litAddTemple" Text="<%$ Resources:OrderLookupLists,IDS_FormField_lblAdd %>"
                runat="server"></asp:Literal>
        </li>
    </ul>
</div>
        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList"
            id="addItemsTable">
            <tr>
                <td class="leftTD">
                    <nobr>
                        <asp:Label ID="lblOrderLooupListName" runat="server" Text="<%$ Resources:OrderLookupLists, IDS_FormField_lblName %>"></asp:Label></nobr>
                </td>
                <td class="rightTD">
                    <asp:TextBox ID="txtListName" runat="server" MaxLength="64"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtListNameTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateAddName" ContainerId="ValidatorContainer" runat="server"
                        ControlToValidate="txtListName" Description="<%$ Resources:OrderLookupLists, IDS_Message_Name_Description %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:OrderLookupLists, IDS_Message_Name_Description %>"
                                LowerBound="1" UpperBound="50" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <nobr>
                        <asp:Label ID="lblSelectMode" runat="server" Text="<%$ Resources:OrderLookupLists,IDS_FormField_lblSelectMode %>"></asp:Label>
                    </nobr>
                </td>
                <td class="rightTD">
                    <Hishop:SelectModeDropDownList ID="dropSelectMode" runat="server" SelectedValue="1" />
                </td>
                <td class="rightTD">
                    <div id="dropSelectModeTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTarget1" runat="server" ContainerId="ValidatorContainer"
                        ControlToValidate="dropSelectMode" Description="<%$ Resources:OrderLookupLists,IDS_FormField_SelectModeHelp %>">
                        <Validators>
                            <Hishop:DropDownListClientValidator ErrorMessage="<%$ Resources:OrderLookupLists,IDS_FormField_SelectModeHelp %>" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="leftTD">
                    <nobr>
                        <asp:Label ID="lblDescription" runat="server" Text="<%$ Resources:OrderLookupLists, IDS_FormField_lblDescription %>"></asp:Label>
                    </nobr>
                </td>
                <td class="rightTD">
                    <asp:TextBox ID="txtDescription" TextMode="MultiLine" Width="230" Height="60" runat="server"
                        MaxLength="50"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtDescriptionTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget ID="ValidateTargetDescription" runat="server" ContainerId="ValidatorContainer"
                        ControlToValidate="txtDescription" Nullable="true" Description="<%$ Resources:OrderLookupLists,IDS_Message_Description %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:OrderLookupLists,IDS_Message_Description %>"
                                UpperBound="1000" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="bottonLeftTD">
                    &nbsp;</td>
                <td class="rightTD">
                    <asp:Button ID="btnCreateOk" runat="server" Text="<%$ Resources:Resources, IDS_Button_Add %>"
                        OnClientClick="return PageIsValid()" CssClass="inp_L1" />
                </td>
                <td class="rightTD">
                    <div class="msgNormal">
                        <asp:Literal ID="Label1" runat="server" Text="<%$ Resources:OrderLookupLists, IDS_FormField_AddHelp %>"></asp:Literal>
                    </div>
                </td>
            </tr>
        </table>
                </SkinTemplate>
            </Hishop:OrderLookupLists>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
 