﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>

<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
    <script type="text/javascript" src="../../utility/Calendar/WdatePicker.js" ></script>
</head>
<body>
    <form id="form1" runat="server">

        <div>         

            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:PaymentModes, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:PaymentModes, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:PaymentModes ID="PaymentModes" runat="server">
                <SkinTemplate>

        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />

<div class="grdGroupFormList">
    <div class="grdHeaderStyle">
        <ul>
            <li class="userGroupAddadmin"> <a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_CreatePaymentMode")%>'><asp:Literal ID="lblAdd" runat="server" Text="<%$ Resources:PaymentModes, IDS_FromField_lblAddPaymentMode %>"></asp:Literal></a>
            </li>
            <li class="spirtLines">|</li>
            <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                <asp:Label ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                <asp:Label ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupDelCheck">
                <Hishop:DeleteImageLinkButton ID="lkbDelectCheck" runat="server"  Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
        </ul>
    </div>
                    <asp:GridView ID="grdPaymentMode" runat="server" AutoGenerateColumns="false" ShowHeader="true"
                        DataKeyNames="ModeId" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow"
                        HeaderStyle-CssClass="GridViewHeaderStyle">
                        <Columns>
                            <Hishop:CheckBoxColumn />
                            <asp:TemplateField HeaderText="<%$ Resources:PaymentModes, IDS_Header_Name %>"
                                ItemStyle-Width="25%">
                                <ItemTemplate>
	                               <asp:Label ID="lblModeName" runat="server" Text='<%# Eval("Name") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="merchantCode" HeaderText="<%$ Resources:PaymentModes, IDS_Header_merchantCode %>"></asp:BoundField>
                            <asp:TemplateField HeaderText="<%$ Resources:PaymentModes, IDS_Header_Gateway %>">
                                <ItemTemplate>
                                    <asp:Label ID="lblGatawayType" runat="server" Text='<%# Eval("Gateway") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <Hishop:SortImageColumn HeaderText="<%$ Resources:PaymentModes,IDS_Header_DisplaySequence %>" />
                            <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>">
                                <ItemStyle Width="100px" />
                                <ItemTemplate>
			                        <a href='<%# Globals.GetSiteUrls().UrlData.FormatUrl("admin_EditPaymentMode",Eval("ModeId")) %>' class="SmallCommonTextButton"><asp:Literal ID="lblManagerText" runat="server" Text="<%$ Resources:Resources, IDS_Button_Edit %>"></asp:Literal></a>
			                        <Hishop:DeleteImageLinkButton runat="server" CssClass="SmallCommonTextButton" ID="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete" />
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>

</div>
                </SkinTemplate>
            </Hishop:PaymentModes>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>