﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<%@ Import Namespace="System.Data" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>           
            <div class="PageTitleArea">
                <div class="PageTitle">
                <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:Advertisements,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                  <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:Advertisements,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:Advertisements ID="Advertisements" runat="server">
                <SkinTemplate> 
<Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdHeaderStyle">
    <asp:Label ID="lblAdvPositions" runat="server"></asp:Label>
</div>
<!--广告列表-->
<div class="grdGroupFormList"> 
            <div class="grdHeaderStyle">
               <ul>   
                 <li class="_return"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_AdvPositions")%>'><asp:Label ID="lblReturnAdvPositions" runat="server" Text="<%$ Resources:Advertisements,IDS_Label_ReturnAdvPositions %>"></asp:Label></a></li>                                                      
                 <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Label ID="CheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>" ></asp:Label></a></li>
                 <li class="spirtLines">|</li>
                 <li class="userGroupReverseCheck"><a  href="#" onclick="CheckReverse()"><asp:Label ID="lblCheckRecerse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
                 <li class="spirtLines">|</li>
                 <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbDeleteCheck" runat="server" Text="<%$Resources:Resources, IDS_Button_DeleteCheck %>" /></li>			                 
               </ul>
            </div>
            <div class="grdGroupList">
                <asp:GridView ID="grdAdvertisement" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="AdvertisementId" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" >                                                        
                        <SelectedRowStyle BackColor="#FBFBF4" />
                        <Columns>                                       
                            <Hishop:CheckBoxColumn ReadOnly="true" HeadWidth="30"/>
                            <asp:TemplateField HeaderText="<%$ Resources:Advertisements,IDS_grdImageUrl %>">
                                <ItemTemplate>
                                    <a id="navigateUrl"  runat="server" href='<%#Eval("NavigateUrl") %>' target="_blank">
                                        <UI:ResizeableImage ID="imgUrl" EnabledTimestamp="true" runat="server" DataField="ImageUrl"  AlternateText='<%#Eval("AlternateText") %>' />
                                        <div class="row-actions">
                                        <asp:LinkButton ID="lkbEdit" runat="server"  CommandName="Edit" Text="<%$ Resources:Advertisements, IDS_FormField_EditAdvertisement %>"></asp:LinkButton>
                                        |
                                        <Hishop:DeleteImageLinkButton ID="lkbDelete" runat="server"  CommandName="Delete" Text="<%$ Resources:Advertisements, IDS_FormField_DeleteAdvertisements %>" />    
                                        </div>
                                    </a>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="<%$ Resources:Advertisements,IDS_grdAdvertisementName %>">
                                <ItemTemplate>
                                        <asp:Literal ID="litName" runat="server" Text='<%#Eval("AdvertisementName") %>' />
                                </ItemTemplate>
                            </asp:TemplateField> 
                            <asp:BoundField HeaderText="<%$ Resources:Advertisements,IDS_grdImpressions %>" DataField="Impressions"  />                                                                                                                                                                                                                                                                                                 
                        </Columns>
                </asp:GridView>
            </div>
 </div>   
            <!--添加/修改广告-->
            <div class="grdHeaderStyle" style="cursor:pointer;" onclick="expItemsTable('addItemsTable');">
                <ul>
                    <li class="addProductTmpt">
                        <asp:Literal ID="litAddAdvertisements" Text='<%$Resources:Advertisements,IDS_Literal_AddAdvertisements %>' runat="server"></asp:Literal>
                   </li>
                </ul>
            </div>
            <table style="width: 100%;" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable">
                <!--广告名称-->
                <tr>
                    <td class="leftTD"><asp:Label ID="lblAdvertisementId" runat="server" Visible="false"></asp:Label>
                        <nobr><asp:Label id="lblAddAdvertisements" runat="server"  Text="<%$ Resources:Advertisements,IDS_Label_AdvertisementName%>"></asp:Label></nobr>
                    </td>
                    <td class="rightTD">
                        <Hishop:DefaultButtonTextBox ID="txtAddAdvertisementName" runat="server" Width="200"  Button="btnAddAdvPositionName"></Hishop:DefaultButtonTextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtAddAdvertisementNameTip" runat="server"></div>
                        <Hishop:ValidateTarget ID="ValidateAddNameItem" ContainerId="ValidatorContainer"  runat="server" ControlToValidate="txtAddAdvertisementName" Description="<%$ Resources:Advertisements,IDS_Help_Name %>" Nullable="false">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:Advertisements, IDS_Help_Name %>" LowerBound="1" UpperBound="100" />
                            </Validators>
                        </Hishop:ValidateTarget>		            
                    </td>
                </tr>
                <!--广告语-->
                <tr>
                    <td class="leftTD"><asp:Label ID="Label2" runat="server" Visible="false"></asp:Label>
                        <nobr><asp:Label id="Label4" runat="server"  Text="<%$ Resources:Advertisements,IDS_Label_AlternateText%>"></asp:Label></nobr>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtAlternateText" runat="server" Width="200"  ></asp:TextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtAlternateTextTip" runat="server"></div>
                        <Hishop:ValidateTarget ID="ValidateAlternateText" ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtAlternateText" Description="<%$ Resources:Advertisements,IDS_Help_AlternateText %>" Nullable="true">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:Advertisements, IDS_Help_AlternateText %>" LowerBound="0" UpperBound="200" />
                            </Validators>
                        </Hishop:ValidateTarget>		            
                    </td>
                </tr>
                <!--图片地址-->
                <tr>
                    <td class="leftTD">
                        <nobr><asp:Label id="Label3" runat="server"  Text="<%$ Resources:Advertisements,IDS_Label_ImageUrl %>"></asp:Label></nobr>
                    </td>
                    <td class="rightTD"><asp:FileUpload ID="uploadedImageUrl" runat="server" Width="280px" /></td>
                    <td class="rightTD">
                        <div class="msgNormal">
                            <Hishop:UploadImageMessageLabel runat="server" ID="uploadMessage"></Hishop:UploadImageMessageLabel>
                        </div>
                    </td>
                </tr>
                <!--链接地址-->
                <tr>
                    <td class="leftTD">
                        <nobr><asp:Label id="Label1" runat="server"  Text="<%$ Resources:Advertisements,IDS_Label_NavigateUrl%>"></asp:Label></nobr>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtNavigateUrl" Width="200" runat="server"></asp:TextBox> 
                    </td>
                    <td class="rightTD">
                        <div id="txtNavigateUrlTip" runat="server"></div>
                        <Hishop:ValidateTarget  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtNavigateUrl"
                            Description="<%$ Resources:Advertisements, IDS_help_NavigateUrl%>" Nullable="true">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:Advertisements, IDS_help_NavigateUrl %>" LowerBound="0" UpperBound="100" />
                        </Validators>
                        </Hishop:ValidateTarget> 
                    </td>
                </tr>
                <!--出现频率-->
                <td class="leftTD">
                        <nobr><asp:Label id="Label5" runat="server"  Text="<%$ Resources:Advertisements,IDS_Label_Impressions%>"></asp:Label></nobr>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtImpressions" runat="server" Text="10"></asp:TextBox> 
                    </td>
                    <td class="rightTD">
                        <div id="txtImpressionsTip" runat="server"></div>
                        <Hishop:ValidateTarget ID="ValidatesImpressions"  ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtImpressions"
                            Description="<%$ Resources:Advertisements, IDS_help_Impressions %>" Nullable="false">
                        <Validators>
                            <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:Advertisements, IDS_help_Impressions%>" />
                            <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:Advertisements, IDS_help_Impressions%>" MinValue="0"/>
                        </Validators>
                        </Hishop:ValidateTarget> 
                    </td>
                </tr>
                <!--按钮-->
                <tr>
                    <td class="bottonLeftTD">&nbsp;</td>
                    <td class="rightTD">
                        <asp:Button ID="btnAddAdvertisement" CommandName="Add" runat="server" Text="<%$ Resources:Advertisements, IDS_Button_AddAdvertisement %>"  OnClientClick="return PageIsValid()"  CssClass="inp_L1"/>                        
                        <asp:Button ID="btnCanel" Text="<%$ Resources:Resources, IDS_Button_Cancel%>" CssClass="inp_L1" runat="server" Visible="false"/>
                    </td>
                    <td class="rightTD">&nbsp;</td>
                </tr>
            </table>
                </SkinTemplate>
            </Hishop:Advertisements>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright ID="SiteCopyright1" runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>

 
 
