﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:FriendlyLink,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:FriendlyLink,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:FriendlyLinks ID="FriendlyLinks" runat="server">
            <SkinTemplate>
<Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdGroupFormList">  
           <div class="grdHeaderStyle">
			     <ul>
			           <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
			           <li class="spirtLines">|</li>
			           <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()"><asp:Literal ID="lkbCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
			           <li class="spirtLines">|</li>
			           <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
			     </ul>
		    </div>
            <div class="grdGroupList">
	                <Hishop:CustomGridView ID="grdGroupList" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="LinkId" CssClass="GridViewStyle" GridLines="None" 
                            RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">
                            <SelectedRowStyle BackColor="#FBFBF4" />
                        <Columns>
 
                            <Hishop:CheckBoxColumn ReadOnly="true"/>
                            
                            <asp:TemplateField HeaderText="<%$ Resources:FriendlyLink,IDS_Header_ImageUrl %>" ItemStyle-Width="20%">
                               <ItemTemplate>
                                  <div>
                                     <Hishop:Common_Image runat="server" EnabledTimestamp="true" DataField="ImageUrl"  />
                                  </div>
                               </ItemTemplate>
                            </asp:TemplateField>

                            <asp:TemplateField HeaderText="<%$ Resources:FriendlyLink, IDS_Header_Title %>" ItemStyle-Width="20%">
                               <ItemTemplate>
		                            <asp:Literal ID="liblTitle" Text='<%#Eval("Title") %>' runat="server"></asp:Literal>
                               </ItemTemplate>
                            </asp:TemplateField>

                            <asp:TemplateField HeaderText="<%$ Resources:FriendlyLink, IDS_Header_LinkUrl %>" ItemStyle-Width="20%">
                               <ItemTemplate>
                                   <div><asp:Literal ID="liblLinkUrl" Text='<%#Eval("LinkUrl") %>' runat="server"></asp:Literal></div>
                               </ItemTemplate>
                            </asp:TemplateField>
                            
                            <Hishop:SortImageColumn  HeaderText="<%$Resources:FriendlyLink,IDS_Header_Display  %>" ReadOnly="true"/>
                            
                            <Hishop:YesNoImageColumn DataField="Visible" HeaderText="<%$ Resources:FriendlyLink,IDS_Header_Visible %>"></Hishop:YesNoImageColumn>
                             <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="10%">
                                 <ItemStyle CssClass="handleRightSelect"/>
                                 <ItemTemplate>
			                        <asp:LinkButton ID="lkEdit" CssClass="SmallCommonTextButton" Text="<%$ Resources:Resources, IDS_Button_Edit %>" CommandName="Edit" runat="server"></asp:LinkButton>
			                        <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" ID="lkDelete" Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete" runat="server" />
                                 </ItemTemplate>
                             </asp:TemplateField>
                        </Columns>
                </Hishop:CustomGridView>
            </div>   
    </div>   
        <!--添加友情连接标题区域 div-->
        <div class="grdHeaderStyle" style="cursor:pointer;" onclick="expItemsTable('addItemsTable');">
            <ul>
                <li class="userGroupAddadmin">
                    <asp:Label ID="lblUserGroupTitle" Text='<%$ Resources:FriendlyLink,IDS_Title_AddUserGroup %>' runat="server"></asp:Label>
                </li>
            </ul>
        </div>
        
        <table style="width: 100%;" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable">
            <!-- 图片地址 -->
            <tr>
               <td class="leftTD"><asp:Literal ID="libladdImageUrl" runat="server" Text="<%$ Resources:FriendlyLink, IDS_FormField_ImageUrl%>"></asp:Literal>：</td>
               <td class="rightTD"><asp:FileUpload ID="uploadImageUrl" Width="281" runat="server" /></td>
               <td class="rightTD">                   
                    <div class="msgNormal">
                        <asp:Label ID="Label1" Text='<%$ Resources:FriendlyLink,IDS_LogoDec%>' runat="server"></asp:Label>
                    </div>
               </td>
            </tr>           
            <!-- 标题 -->
            <tr>
               <td class="leftTD"><asp:Literal ID="libladdTitle" runat="server" Text="<%$ Resources:FriendlyLink, IDS_FormField_Title%>"></asp:Literal>：</td>
               <td class="rightTD"><asp:TextBox ID="txtaddtitle" runat="server" CssClass="input_short"></asp:TextBox></td>
               <td class="rightTD">
                   <div id="txtaddtitleTip" runat="server"></div>
                   <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtaddtitle" Description="<%$ Resources:FriendlyLink, IDS_ErrorMessage_Title %>" Nullable="true" FocusMessage="<%$ Resources:FriendlyLink, IDS_ErrorMessage_Title %>">
                        <Validators>
                           <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:FriendlyLink, IDS_ErrorMessage_Title %>" LowerBound="1" UpperBound="100" />
                        </Validators>
                   </Hishop:ValidateTarget>
               </td>
            </tr>
            <!-- 排序 -->
            <tr>
               <td class="leftTD"><asp:Literal ID="libladdDisplaySequence" runat="server" Text="<%$ Resources:FriendlyLink, IDS_FormField_DisplaySequence%>"></asp:Literal>：</td>
               <td class="rightTD"><asp:TextBox ID="txtaddDisplaySequence" Text="1" runat="server" CssClass="input_short"></asp:TextBox></td>
               <td class="rightTD">
                   <div id="txtaddDisplaySequenceTip" runat="server"></div>
                   <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtaddDisplaySequence" Description="<%$ Resources:FriendlyLink, IDS_ErrorMessage_DisplaySequence %>" Nullable="false" FocusMessage="<%$ Resources:FriendlyLink, IDS_ErrorMessage_DisplaySequence %>">
                        <Validators>
                           <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:FriendlyLink, IDS_ErrorMessage_DisplaySequence %>" />
                           <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:FriendlyLink, IDS_ErrorMessage_DisplaySequence %>" MinValue="1" />
                        </Validators>
                   </Hishop:ValidateTarget>
               </td>
            </tr>
            <!-- 是否显示 -->
            <tr>
               <td class="leftTD"><asp:Literal ID="libladdVisible" runat="server" Text="<%$ Resources:FriendlyLink, IDS_FormField_Visible%>"></asp:Literal>：</td>
               <td class="rightTD"><Hishop:YesNoRadioButtonList id="radioShowLinks" runat="server"></Hishop:YesNoRadioButtonList></td>                   
               <td class="rightTD">                   
                   <label class="msgNormal"><asp:Literal ID="lblShowFooter" Text="<%$ Resources:FriendlyLink, IDS_ErrorMessage_Visible %>" runat="server"></asp:Literal></label>
               </td>
            </tr>            
            <!-- 链接地址 -->
            <tr>
               <td class="leftTD"><asp:Literal ID="libladdLinkUrl" runat="server" Text="<%$ Resources:FriendlyLink, IDS_FormField_LinkUrl %>"></asp:Literal>：</td>
               <td class="rightTD"><asp:TextBox ID="txtaddLinkUrl" CssClass="input_short" runat="server" Text="http://" ></asp:TextBox></td>
               <td class="rightTD">
                   <div id="txtaddLinkUrlTip" runat="server"></div>
                   <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtaddLinkUrl" Description="<%$ Resources:FriendlyLink, IDS_ErrorMessage_LinkUrl %>" Nullable="true" FocusMessage="<%$ Resources:FriendlyLink, IDS_ErrorMessage_LinkUrl %>">
                        <Validators>
                           <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:FriendlyLink, IDS_ErrorMessage_LinkUrl %>" LowerBound="1" UpperBound="255" Regex="^(http)://.*" />
                        </Validators>
                   </Hishop:ValidateTarget>
               </td>
            </tr>
            <!-- 按钮 -->        
            <tr>
                <td class="bottonLeftTD">&nbsp;</td>
                <td class="rightTD">
                        <asp:Button ID="btnSubmitLinks" Text="<%$ Resources:Resources, IDS_Button_Add%>" CssClass="inp_L1" OnClientClick="return PageIsValid()"  runat="server"/>
                        <asp:Button ID="btnCancel" Text="<%$ Resources:Resources, IDS_Button_Cancel%>" CssClass="inp_L1" runat="server" />
                </td>
                <td class="rightTD">&nbsp;</td>
             </tr>
        </table>      
            </SkinTemplate>
            </Hishop:FriendlyLinks>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
