﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>  
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:ManageHotKeywords, IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server"  Text="<%$ Resources:ManageHotKeywords, IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            
             <Hishop:ManageHotKeywords ID="ManageHotKeywords" runat="server">
             <SkinTemplate>
<Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdGroupFormList">
    <div class="grdHeaderStyle">
        <ul>
            <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()">
                <asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()">
                <asp:Literal ID="lblCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
            <li class="spirtLines">|</li>
            <li class="userGroupDelCheck">
                <Hishop:DeleteImageLinkButton ID="lkbDelectCheck" runat="server"  Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" />
            </li>
        </ul>
    </div>
            <div class="grdGroupList">
            <Hishop:CustomGridView runat="server" AutoGenerateColumns="False" ID="grdHotKeywords"
                ShowHeader="true" DataKeyNames="Hid" CssClass="GridViewStyle" GridLines="None"
                RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" AllowSorting="true"
                SortOrderBy="Frequency" SortOrder="DESC">
                <Columns>
                    <Hishop:CheckBoxColumn ReadOnly="true" />
			                <asp:TemplateField HeaderText="<%$Resources:ManageHotKeywords,IDS_Header_Keywords %>">
			                    <ItemTemplate>
			                        <asp:Literal ID="litName" runat="server" Text='<%# Eval("Keywords") %>' />
			                    </ItemTemplate>
			                    <EditItemTemplate>
			                        <asp:TextBox ID="txtKeyword" runat="server"  Text='<%# Globals.HtmlDecode(Convert.ToString(Eval("Keywords"))) %>'/>
			                        <asp:LinkButton ID="Update" CssClass="SmallCommonTextButton" runat="server" Text="<%$ Resources:Resources, IDS_Button_Update %>" CommandName="Update"  />
                                    <asp:LinkButton ID="Cancel" CssClass="SmallCommonTextButton" runat="server" Text="<%$ Resources:Resources, IDS_Button_Cancel %>" CommandName="Cancel" />
			                    </EditItemTemplate>
			                </asp:TemplateField>
                    
                         <Hishop:SortImageColumn HeaderText="<%$Resources:ManageHotKeywords,IDS_Header_Sort %>" ReadOnly="true" />
                             <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="10%">
                                 <ItemStyle CssClass="handleRightSelect"/>
                                 <ItemTemplate>
			                          <asp:LinkButton ID="Edit" CssClass="SmallCommonTextButton" runat="server" Text="<%$ Resources:Resources, IDS_Button_Edit %>" CommandName="Edit" />
			                          <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" runat="server" ID="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete" />
                                 </ItemTemplate>
                             </asp:TemplateField>    
                </Columns>
            </Hishop:CustomGridView>
            </div>
</div>
        <div class="grdHeaderStyle" style="cursor: pointer;" onclick="expItemsTable('addItemsTable');">
            <ul>
                <li class="addArticleClass">
                    <asp:Literal ID="litTitle" Text="<%$Resources:ManageHotKeywords,IDS_FormField_Title %>" runat="server" />
                </li>
            </ul>
        </div>
        <table style="width: 100%" cellspacing="0" cellpadding="0" class="formTableList"
            id="addItemsTable">
            <tr>
                <td class="leftTD">
                    <asp:Literal ID="litKeyName" Text="<%$Resources:ManageHotKeywords,IDS_FormField_Keywords %>" runat="server"></asp:Literal>：
                </td>
                <td class="rightTD">
                    <asp:TextBox ID="txtHotKeywords" CssClass="input_short" runat="server"></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtHotKeywordsTip" runat="server">
                    </div>
                    <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtHotKeywords"
                        Description="<%$Resources:ManageHotKeywords,IDS_ErrorMessage_Keywords %>"
                        Nullable="false" FocusMessage="<%$Resources:ManageHotKeywords,IDS_ErrorMessage_Keywords %>">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:ManageHotKeywords,IDS_ErrorMessage_Keywords %>"
                                LowerBound="1" UpperBound="100" />
                        </Validators>
                    </Hishop:ValidateTarget>
                </td>
            </tr>
            <tr>
                <td class="bottonLeftTD">
                    &nbsp;
                </td>
                <td class="rightTD">
                    <asp:Button ID="btnSubmitHotkeyword" runat="server" OnClientClick="return PageIsValid();"
                        Text="<%$ Resources:ManageHotKeywords, IDS_Button_AddSubmit%>" CssClass="inp_L1" />
                </td>
            </tr>
        </table>
             </SkinTemplate>
             </Hishop:ManageHotKeywords>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
 
