﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:OnlineServiceItem,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:OnlineServiceItem,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:OnlineService ID="OnlineService" runat="server">
            <SkinTemplate>
<Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<!-- 在线客服列表 -->
<div class="grdGroupFormList">     
        <div class="grdHeaderStyle">
		     <ul>
		           <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
		           <li class="spirtLines">|</li>
		           <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()"><asp:Literal ID="lkbCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
		           <li class="spirtLines">|</li>
		           <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
		     </ul>
	    </div>   
        <div class="grdGroupList">
            <Hishop:CustomGridView ID="grdOnlineServiceItem" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="ServiceId" 
                CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" >   
                <SelectedRowStyle BackColor="#FBFBF4" />                                                     
                    <Columns>                                       
                        <Hishop:CheckBoxColumn ReadOnly="true" HeadWidth="30"/>

                        <asp:TemplateField HeaderText="<%$ Resources:OnlineServiceItem,IDS_GrdHead_ServiceAccount %>">
                            <ItemTemplate>
		                          <asp:Label ID="lblServiceName" runat="server" Text='<%# Eval("ServiceAccount") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="<%$ Resources:OnlineServiceItem,IDS_Label_ServiceName %>">
                            <ItemTemplate>
                                <asp:Label ID="lblOnlineService" runat="server" Text='<%# Eval("ServiceName") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>

                        <asp:TemplateField HeaderText="<%$ Resources:OnlineServiceItem,IDS_GrdHead_ShopType %>">
                            <ItemTemplate>
                                <asp:Literal ID="litShopType" runat="server" Text='<%# Eval("ServiceType") %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                                               
                        <Hishop:SortImageColumn  HeaderText="<%$Resources:OnlineServiceItem,IDS_Header_Display  %>" ReadOnly="true"/>

                        <Hishop:YesNoImageColumn DataField="IsShowItem" HeaderText="<%$ Resources:OnlineServiceItem,IDS_Header_IsShowItem%>"></Hishop:YesNoImageColumn>
                        
                             <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="10%">
                                 <ItemStyle CssClass="handleRightSelect"/>
                                 <ItemTemplate>
	                                <asp:LinkButton ID="lkbEdit" runat="server" CssClass="SmallCommonTextButton" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit%>"></asp:LinkButton>
                                    <Hishop:DeleteImageLinkButton ID="lkDelete" CssClass="SmallCommonTextButton" Text="<%$ Resources:Resources, IDS_Button_Delete %>" CommandName="Delete" runat="server" />
                                 </ItemTemplate>
                             </asp:TemplateField>
                                                                                                                                                                                                                                  
                    </Columns>
            </Hishop:CustomGridView>
        </div>
</div>
    <div>
        <!-- 区域标题栏 -->  
        <div class="grdHeaderStyle">
            <ul>
                <li class="addProductTmpt">
                    <asp:Literal ID="lblUserGroupTitle" Text='<%$Resources:OnlineServiceItem,IDS_Literal_AddOnlineServiceItem %>' runat="server"></asp:Literal>
                </li>
            </ul>
        </div>
        <table style="width: 100%;" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable" runat="server">
            <!-- 在线客服类型 --> 
            <tr>
                <td class="leftTD">
                    <nobr><asp:Label id="lblShowType" runat="server"  Text="<%$ Resources:OnlineServiceItem,IDS_Label_ItemType%>"></asp:Label>：</nobr>
                </td>
                <td class="rightTD"><Hishop:OnlineServiceTypeDropDownList ID="dropShopType" runat="server" /></td>
                <td class="rightTD">
                    <div class="msgNormal">
                        <asp:Literal ID="lblShowTypeDis" runat="server" Text="<%$Resources:OnlineServiceItem,IDS_help_ItemType %>" />
                    </div>	            
                </td>
            </tr>
            <!-- 在线客服帐号 -->
            <tr>
                <td class="leftTD">
                    <nobr><asp:Label id="lblOnlineServiceName" runat="server"  Text="<%$ Resources:OnlineServiceItem,IDS_Label_ServiceAccount%>"></asp:Label>：</nobr>
                </td>
                <td class="rightTD">
                    <asp:TextBox ID="txtServiceAccount" runat="server" ></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtServiceAccountTip" runat="server"></div>
                    <Hishop:ValidateTarget ID="ValidateAddNameItem" ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtServiceAccount" Description="<%$ Resources:OnlineServiceItem,IDS_help_ServiceAccount %>" Nullable="false">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:OnlineServiceItem, IDS_ErrorHelp_ServiceAccount %>" LowerBound="1" UpperBound="200" />
                        </Validators>
                    </Hishop:ValidateTarget>		            
                </td>
            </tr>
            <!-- 在线客服名称 -->
            <tr>
                <td class="leftTD">
                    <nobr><asp:Label id="Label1" runat="server"  Text="<%$ Resources:OnlineServiceItem,IDS_Label_ServiceName%>"></asp:Label>：</nobr>
                </td>
                <td class="rightTD">
                    <asp:TextBox ID="txtServiceName" runat="server" ></asp:TextBox>
                </td>
                <td class="rightTD">
                    <div id="txtServiceNameTip" runat="server"></div>
                    <Hishop:ValidateTarget ID="ValidateTarget2" ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtServiceName" Description="<%$ Resources:OnlineServiceItem,IDS_help_ServiceName %>" Nullable="false">
                        <Validators>
                            <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:OnlineServiceItem, IDS_ErrorHelp_ServiceName %>" LowerBound="1" UpperBound="100" />
                        </Validators>
                    </Hishop:ValidateTarget>		            
                </td>
            </tr>
            <!-- 是否显示 -->
            <tr>
               <td class="leftTD"><asp:Literal ID="libladdVisible" runat="server" Text="<%$ Resources:OnlineServiceItem, IDS_Label_IsShowItem%>"></asp:Literal>：</td>
               <td class="rightTD"><Hishop:YesNoRadioButtonList id="radioShowLinks" runat="server"></Hishop:YesNoRadioButtonList></td>                   
               <td class="rightTD">                   
                   <label class="msgNormal"><asp:Literal ID="lblShowFooter" Text="<%$ Resources:OnlineServiceItem, IDS_Help_IsShowItem %>" runat="server"></asp:Literal></label>
               </td>
            </tr> 
            <!-- 排序 -->
            <tr>
               <td class="leftTD"><asp:Literal ID="libladdDisplaySequence" runat="server" Text="<%$ Resources:OnlineServiceItem, IDS_Label_DisplaySequence%>"></asp:Literal>：</td>
               <td class="rightTD"><Hishop:DefaultButtonTextBox ID="txtaddDisplaySequence" Text="1" runat="server" CssClass="input_short" Button="btnSubmit"></Hishop:DefaultButtonTextBox></td>
               <td class="rightTD">
                   <div id="txtaddDisplaySequenceTip" runat="server"></div>
                   <Hishop:ValidateTarget ID="ValidateTarget1" runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtaddDisplaySequence" Description="<%$ Resources:OnlineServiceItem, IDS_ErrorMessage_DisplaySequence %>" Nullable="false" FocusMessage="<%$ Resources:OnlineServiceItem, IDS_ErrorMessage_DisplaySequence %>">
                        <Validators>
                           <Hishop:InputNumberClientValidator ErrorMessage="<%$ Resources:OnlineServiceItem, IDS_ErrorMessage_DisplaySequence %>" />
                           <Hishop:NumberRangeClientValidator ErrorMessage="<%$ Resources:OnlineServiceItem, IDS_ErrorMessage_DisplaySequence %>" MinValue="1" />
                        </Validators>
                   </Hishop:ValidateTarget>
               </td>
            </tr>
            <!-- 按钮 -->
            <tr>
                <td class="bottonLeftTD">&nbsp;</td>
                <td class="rightTD">
                    <asp:Button ID="btnSubmit" runat="server" Text="<%$ Resources:Resources, IDS_Button_Add%>"  OnClientClick="return PageIsValid()"  CssClass="inp_L1"/>                        
                    <asp:Button ID="btnCancel" Text="<%$ Resources:Resources, IDS_Button_Cancel%>" CssClass="inp_L1" runat="server" />
                </td>
                <td class="rightTD">&nbsp;</td>
            </tr>
        </table>
    </div>
            </SkinTemplate>
            </Hishop:OnlineService>
            
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
