﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
   
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:Roles,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:Roles,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:Roles ID="Roles" runat="server">
            <SkinTemplate>
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
    <div class="grdGroupFormList">  
           <div class="grdHeaderStyle">
			          <ul>
			             <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Literal ID="lblCheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>"></asp:Literal></a></li>
			             <li class="spirtLines">|</li>
			             <li class="userGroupReverseCheck"><a href="#" onclick="CheckReverse()"><asp:Literal ID="lkbCheckReverse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Literal></a></li>
			             <li class="spirtLines">|</li>
			             <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbtnDeleteCheck" runat="server" Text="<%$ Resources:Resources, IDS_Button_DeleteCheck %>" /></li>
			          </ul>
	               </div>
		  <div class="grdGroupList">
		         <Hishop:CustomGridView ID="grdGroupList" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="RoleID" CssClass="GridViewStyle" GridLines="None" 
                    RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle">    
                       <Columns>
                            <Hishop:CheckBoxColumn ReadOnly="true" HeadWidth="30"/>
                            <asp:TemplateField HeaderText="<%$ Resources:Roles, IDS_Header_RolesName %>">
                               <ItemTemplate>
		                              <asp:Label ID="lblRoleName" Text='<%#Eval("Name")%>' runat="server" />
                               </ItemTemplate>
                               <EditItemTemplate>  
                                    <asp:Label ID="lblRoleName" Text='<%#Eval("Name")%>' runat="server" Visible="false"/>                                          		                    
                                   <asp:TextBox  ID="txtRoleNames" runat="server" Text='<%# Globals.HtmlDecode(Convert.ToString(Eval("Name"))) %>'></asp:TextBox> 
                                    <asp:LinkButton CssClass="SmallCommonTextButton" ID="lkbUpdate" runat="server" CommandName="Update"  Text="<%$ Resources:Resources, IDS_Button_Save %>"></asp:LinkButton>
                                    <asp:LinkButton CssClass="SmallCommonTextButton" ID="lkbCancel" runat="server" CommandName="Cancel" Text="<% $Resources:Resources, IDS_Button_Cancel %>"></asp:LinkButton> 
                               </EditItemTemplate>                                                            
                            </asp:TemplateField>
                             <asp:TemplateField HeaderText="<%$ Resources:Roles, IDS_Header_RolesDesc %>">
                                  <ItemTemplate>
                                    <div><asp:Literal ID="lblRoleDesc" Text='<%#Eval("Description") %>' runat="server"></asp:Literal></div>
                                  </ItemTemplate>
                                  <EditItemTemplate>                                            		                    
                                   <asp:TextBox ID="txtRoleDescription" runat="server" CssClass="input_longest" Text='<%# Globals.HtmlDecode(Convert.ToString(Eval("Description"))) %>'></asp:TextBox>                                    
                                  </EditItemTemplate> 
                             </asp:TemplateField>
                             <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="20%">
                                 <ItemStyle/>
                                 <ItemTemplate>
			                          <asp:LinkButton CssClass="SmallCommonTextButton" runat="server" ID="LinkButton1" CommandName="UserInRoles" Text="<%$ Resources:Roles, IDS_LinkButton_ViewUser %>" />
			                          <asp:LinkButton CssClass="SmallCommonTextButton" runat="server" ID="LinkButton2" CommandName="editRolesPermissions" Text="<%$ Resources:Roles, IDS_LinkButton_UserRolesPurview %>" />
			                          <asp:LinkButton CssClass="SmallCommonTextButton" runat="server" ID="LinkButton3" CommandName="Edit" Text="<%$ Resources:Resources, IDS_Button_Edit%>"/>
			                          <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" runat="server" ID="DeleteImageLinkButton1" CommandName="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete%>"/>
                                 </ItemTemplate>
                                 <EditItemTemplate> 
			                          <asp:LinkButton CssClass="SmallCommonTextButton" runat="server" ID="LinkButton1" CommandName="UserInRoles" Text="<%$ Resources:Roles, IDS_LinkButton_ViewUser %>" />
			                          <asp:LinkButton CssClass="SmallCommonTextButton" runat="server" ID="LinkButton2" CommandName="editRolesPermissions" Text="<%$ Resources:Roles, IDS_LinkButton_UserRolesPurview %>" />
			                          <Hishop:DeleteImageLinkButton CssClass="SmallCommonTextButton" runat="server" ID="DeleteImageLinkButton1" CommandName="Delete" Text="<%$ Resources:Resources, IDS_Button_Delete%>"/>
                                 </EditItemTemplate>
                             </asp:TemplateField>  
                      </Columns>
                </Hishop:CustomGridView>
          </div>
          </div>
        <!--添加部门-->
         <div class="grdHeaderStyle" style="cursor:pointer;" onclick="expItemsTable('addItemsTable');">
                <ul>
                    <li class="userGroupAddadmin">
                        <asp:Literal ID="litUserGroup" Text='<%$Resources:Roles,IDS_Title_AddUserGroup %>' runat="server"></asp:Literal>
                    </li>
                </ul>
        </div>
         <table style="width: 100%;" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable">
            <tr>
               <td class="leftTD"><asp:Literal ID="lblUserRolesName" runat="server" Text="<%$ Resources:Roles, IDS_FormField_RolesName%>"></asp:Literal>：</td>
               <td class="rightTD"><asp:TextBox ID="txtRoleName" runat="server" CssClass="input_short"></asp:TextBox></td>
               <td class="rightTD">
                   <div id="txtRoleNameTip" runat="server"></div>
                   <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtRoleName" Description="<%$Resources:Roles,IDS_ErrorMessage_RoleName %>" Nullable="false" FocusMessage="<%$Resources:Roles,IDS_ErrorMessage_RoleName %>">
                        <Validators>
                           <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Roles,IDS_ErrorMessage_RoleName %>" LowerBound="1" UpperBound="100" />
                        </Validators>
                   </Hishop:ValidateTarget>
               </td>
            </tr>
            <tr>
               <td class="leftTD"><asp:Literal ID="lblUserRoleDesc" runat="server" Text="<%$ Resources:Roles, IDS_FormField_RolesDesc%>"></asp:Literal>：</td>
               <td class="rightTD"><Hishop:DefaultButtonTextBox ID="txtRoleDesc" CssClass="input_short" runat="server" Button="btnSubmitRoles"></Hishop:DefaultButtonTextBox></td>
               <td class="rightTD">
                   <div id="txtRoleDescTip" runat="server"></div>
                   <Hishop:ValidateTarget runat="server" ContainerId="ValidatorContainer" ControlToValidate="txtRoleDesc" Description="<%$Resources:Roles,IDS_ErrorMessage_RoleDesc %>" Nullable="true" FocusMessage="<%$Resources:Roles,IDS_ErrorMessage_RoleDesc %>">
                        <Validators>
                           <Hishop:InputStringClientValidator ErrorMessage="<%$Resources:Roles,IDS_ErrorMessage_RoleDesc %>" LowerBound="1" UpperBound="1000" />
                        </Validators>
                   </Hishop:ValidateTarget>
               </td>
            </tr>
            <tr>
                <td class="bottonLeftTD">&nbsp;</td>
                <td class="rightTD">
                        <asp:Button ID="btnSubmitRoles" Text="<%$ Resources:Resources, IDS_Button_Add%>" OnClientClick="return PageIsValid()" CssClass="inp_L1" runat="server"/>
                </td>
                <td class="rightTD">&nbsp;</td>
             </tr>
         </table>      
            </SkinTemplate>
            </Hishop:Roles>
            
        </div>
        <br />

        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
    </body>
</html>