﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" media="screen" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" media="screen" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div>
    <div class="PageTitleArea">
        <div class="PageTitle">
            <asp:Literal ID="litManagerTop" runat="server" Text="<%$ Resources:SiteContent, IDS_PageTitle %>"></asp:Literal>
        </div>
        <div style="width: 80%;">
            <asp:Literal ID="litManagerDisciption" runat="server" Text="<%$ Resources:SiteContent, IDS_PageDesc %>"></asp:Literal>
        </div>
    </div>
    <Hishop:SiteContent ID="SiteContent" runat="server">
        <SkinTemplate>
            <Hishop:StatusMessage ID="Status" runat="server" Visible="False" />
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="formTableList">
                <!--店铺名称-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label1" runat="server" Text="<%$ Resources:SiteContent, IDM_lblSitName%>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtSiteName" runat="server" Width="280px"></asp:TextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtSiteNameTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="validateTargetUserName" ContainerId="ValidatorContainer"
                            runat="server" ControlToValidate="txtSiteName" Description="<%$ Resources:SiteContent, IDM_help01%>" Nullable="false">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help01%>" LowerBound="1" UpperBound="30" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--店铺Logo-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="lblLogo" runat="server" Text="<%$ Resources:SiteContent, IDS_lblLogo %>"></asp:Label>：
                    </td>
                    <td class="rightTD">
                        <asp:FileUpload ID="fileUpload" runat="server" Width="280px" />
                    </td>
                    <td class="rightTD">
                        <div class="msgNormal">
                            <Hishop:UploadImageMessageLabel runat="server" ID="uploadMessage"></Hishop:UploadImageMessageLabel>
                        </div>
                    </td>
                </tr>
                <tr id="tblrLogo" runat="server">
                    <td class="leftTD" style="width: 130px;">
                    </td>
                    <td class="rightTD" colspan="2">
                        <Hishop:Common_Image ID="imgLogo" EnabledTimestamp="true" runat="server" />
                        <span><Hishop:DeleteImageLinkButton ID="btnDeleteLogo" runat="server" Text="<%$ Resources:Resources, IDS_Button_Delete %>" /></span>
                    </td>
                </tr>
                <!--主域名-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label11" runat="server" Text="<%$ Resources:SiteContent, IDS_SiteUrl%>"></asp:Label>：
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtDomainName" Width="280px" runat="server"></asp:TextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtDomainNameTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="validateTarget1" ContainerId="ValidatorContainer" runat="server"
                            ControlToValidate="txtDomainName" Description="<%$ Resources:SiteContent, IDS_SiteUrl_Help%>"
                            Nullable="false">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:SiteContent, IDS_SiteUrl_Help%>"
                                    LowerBound="0" UpperBound="30" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--简单介绍-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label2" runat="server" Text="<%$ Resources:SiteContent, IDM_lblSiteDescription%>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtSiteDescription" Width="280px" runat="server"></asp:TextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtSiteDescriptionTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="validateTargetSiteDescription" ContainerId="ValidatorContainer"
                            runat="server" ControlToValidate="txtSiteDescription" Description="<%$ Resources:SiteContent, IDM_help02%>"
                            Nullable="true">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help02%>"
                                    LowerBound="0" UpperBound="60" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--店铺描述-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label5" runat="server" Text="<%$ Resources:SiteContent, IDM_lblSearchMetaDescription %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtSearchMetaDescription" runat="server" Width="280px"></asp:TextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtSearchMetaDescriptionTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="validateTargetSearchMetaDescription" ContainerId="ValidatorContainer"
                            runat="server" ControlToValidate="txtSearchMetaDescription" Description="<%$ Resources:SiteContent, IDM_help03%>"
                            Nullable="true">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help03%>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--搜索关键字-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label6" runat="server" Text="<%$ Resources:SiteContent, IDM_lblSearchMetaKeywords %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <Hishop:DefaultButtonTextBox ID="txtSearchMetaKeywords" Width="280px" runat="server"></Hishop:DefaultButtonTextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtSearchMetaKeywordsTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="validateTargetSearchMetaKeywords" ContainerId="ValidatorContainer"
                            runat="server" ControlToValidate="txtSearchMetaKeywords" Description="<%$ Resources:SiteContent, IDM_help04%>"
                            Nullable="true">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help04%>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--是否开启伪静态-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label10" runat="server" Text="<%$ Resources:SiteContent,IDM_lblEnableHtmRewrite %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <Hishop:YesNoRadioButtonList ID="radlEnableHtmRewrite" runat="server">
                        </Hishop:YesNoRadioButtonList>
                    </td>
                    <td class="rightTD">
                        <div class="msgNormal">
                            <asp:Literal ID="Literal1" runat="server" Text="<%$Resources:SiteContent,IDM_lblEnableHtmRewrite_Help %>" />
                        </div>
                    </td>
                </tr>
                <!--店铺样式-->
                <tr style="display: none">
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label3" runat="server" Text="<%$ Resources:SiteContent, IDM_lblDefaultTheme %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <Hishop:ThemeDropDownList ID="dropDefaultTheme" runat="server">
                        </Hishop:ThemeDropDownList>
                    </td>
                    <td class="rightTD">
                        <div id="dropDefaultThemeTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateDefaultTheme" ContainerId="ValidatorContainer"
                            runat="server" ControlToValidate="dropDefaultTheme" Description="<%$ Resources:SiteContent, IDM_help06 %>"
                            Nullable="false">
                            <Validators>
                                <Hishop:DropDownListClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help06%>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--店铺使用的默认货币-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label4" runat="server" Text="<%$ Resources:SiteContent, IDM_lblDefaultCurrency %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <Hishop:CurrencyDropDownList ID="dropDefaultCurrency" runat="server">
                        </Hishop:CurrencyDropDownList>
                    </td>
                    <td class="rightTD">
                        <div id="dropDefaultCurrencyTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateTargetdropDefaultCurrency" ContainerId="ValidatorContainer"
                            runat="server" ControlToValidate="dropDefaultCurrency" Description="<%$ Resources:SiteContent, IDM_help08 %>"
                            Nullable="false">
                            <Validators>
                                <Hishop:DropDownListClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help08 %>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--在线用户统计-->
                <tr style="display: none">
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label12" runat="server" Text="<%$ Resources:SiteContent,IDM_lblEnableWhoIsOnline %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <Hishop:YesNoRadioButtonList ID="ynrblEnableWhoIsOnline" runat="server">
                        </Hishop:YesNoRadioButtonList>
                    </td>
                    <td class="rightTD">
                        <div class="msgNormal">
                            <asp:Literal ID="lblEnableWhoIsOnline" runat="server" Text="<%$Resources:SiteContent,IDM_help11 %>" />
                        </div>
                    </td>
                </tr>
                <!--开启版本检查-->
                <tr style="display: none">
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label13" runat="server" Text="<%$ Resources:SiteContent,IDM_lblEnableVersionCheck %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <Hishop:YesNoRadioButtonList ID="ynrblEnableVersionCheck" runat="server">
                        </Hishop:YesNoRadioButtonList>
                    </td>
                    <td class="rightTD">
                        <div class="msgNormal">
                            <asp:Literal ID="lblEnableVersionCheck" runat="server" Text="<%$Resources:SiteContent,IDM_help12 %>" />
                        </div>
                    </td>
                </tr>
                <!--分页大小-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label7" runat="server" Text="<%$ Resources:SiteContent,IDM_lblPageSize %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <Hishop:PageSizeDropDownList ID="dropPageSize" runat="server" />
                    </td>
                    <td class="rightTD">
                        <div id="dropPageSizeTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="validatePageSize" ContainerId="ValidatorContainer" runat="server"
                            ControlToValidate="dropPageSize" Description="<%$ Resources:SiteContent, IDM_help07%>"
                            Nullable="false">
                            <Validators>
                                <Hishop:DropDownListClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help07%>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--版权信息-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label9" runat="server" Text="<%$ Resources:SiteContent, IDM_lblCopyright%>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtCopyright" runat="server" Width="280px"></asp:TextBox><br />
                        <asp:Literal ID="litCopyright" runat="server" />
                    </td>
                    <td class="rightTD">
                        <div id="txtCopyrightTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateCopyright" ContainerId="ValidatorContainer" runat="server"
                            ControlToValidate="txtCopyright" Description="<%$ Resources:SiteContent, IDM_help13 %>"
                            Nullable="true">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help13%>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--页头标签-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label8" runat="server" Text="<%$ Resources:SiteContent, IDM_lblRawAdditionalHeader %>"></asp:Label>
                    </td>
                    <td class="rightTD">
                        <asp:TextBox ID="txtRawAdditionalHeader" Width="280px" Height="80px" TextMode="MultiLine"
                            runat="server"></asp:TextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtRawAdditionalHeaderTip" runat="server">
                        </div>
                        <Hishop:ValidateTarget ID="ValidateRawAdditionalHeader" ContainerId="ValidatorContainer"
                            runat="server" ControlToValidate="txtRawAdditionalHeader" Description="<%$ Resources:SiteContent, IDM_help05 %>"
                            Nullable="true">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:SiteContent, IDM_help05%>" />
                            </Validators>
                        </Hishop:ValidateTarget>
                    </td>
                </tr>
                <!--自定放页尾-->
                <tr>
                    <td class="leftTD" style="width: 130px;">
                        <asp:Label ID="Label14" runat="server" Text="<%$ Resources:SiteContent, IDM_lblFooter%>"></asp:Label>
                    </td>
                    <td class="rightTD" colspan="2">
                        <FCKeditorV2:FCKeditor ID="fkFooter" runat="server" Width="99%" EnableXHTML="true"
                            EnableSourceXHTML="true" BasePath="~/FCKeditor/" Height="200px">
                        </FCKeditorV2:FCKeditor>
                    </td>
                </tr>
                <!--按钮-->
                <tr>
                    <td class="bottonLeftTD" style="width: 130px;">
                        &nbsp;
                    </td>
                    <td class="rightTD">
                        <asp:Button ID="btnChangeSiteSet" OnClientClick="return PageIsValid();" runat="server"
                            Text="<%$ Resources:SiteContent, IDM_btnChangeSet %>" CssClass="inp_L1"></asp:Button>
                    </td>
                    <td class="rightTD">
                        &nbsp;
                    </td>
                </tr>
            </table>
        </SkinTemplate>
    </Hishop:SiteContent>
    </div>
    <br />
    <div style="text-align: center">
        <hr style="width: 500px;" />
        <Hishop:SiteCopyright runat="server" />
    </div>
    <br />
    <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
