﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Controls" Assembly="Hishop.Web.Controls" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Management" Assembly="Hishop.Web.Management" %>
<%@ Register TagPrefix="Hishop" Namespace="Hishop.Web.Validator" Assembly="Hishop.Web.Validator" %>
<%@ Import Namespace="Hishop.SystemServices" %>
<%@ Import Namespace="System" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <Hishop:HeadContainer ID="HeadContainer1" runat="server" />
    <Hishop:PageTitle ID="PageTitle1" runat="server" />
    <link rel="stylesheet" href="../../utility/validate/pagevalidator.css" type="text/css" />
    <link rel="stylesheet" href="../css/Hishopv5.css" type="text/css" />
    <script type="text/javascript" src="../../utility/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="../../utility/validate/pagevalidator.js"></script>
    
    <script type="text/javascript" src="../js/Hishopv5.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <div class="PageTitleArea">
                <div class="PageTitle">
                    <asp:Literal ID="lblPageTitle" runat="server" Text="<%$ Resources:VoteItems,IDS_PageTitle %>"></asp:Literal>
                </div>
                <div style="width: 80%;">
                    <asp:Literal ID="lblPageDesc" runat="server" Text="<%$ Resources:VoteItems,IDS_PageDesc %>"></asp:Literal>
                </div>
            </div>
            <Hishop:VoteItems ID="Votes" runat="server">
            <SkinTemplate>
        <Hishop:StatusMessage id="Status" runat="server" Visible="False" />
<div class="grdHeaderStyle">
    <asp:Label ID="lblVoteName" runat="server"></asp:Label>
</div>
<!--投票选项列表-->
<div class="grdGroupFormList"> 
            <div class="grdHeaderStyle">
               <ul>    
                 <li class="_return"><a href='<%= Globals.GetSiteUrls().UrlData.FormatUrl("admin_Votes")%>'><asp:Label ID="lblReturnVotes" runat="server" Text="<%$ Resources:VoteItems,IDS_Label_ReturnVotes %>"></asp:Label></a></li>                                                      
                 <li class="userGroupCheckAll"><a href="#" onclick="CheckClickAll()"><asp:Label ID="CheckAll" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckAll %>" ></asp:Label></a></li>
                 <li class="spirtLines">|</li>
                 <li class="userGroupReverseCheck"><a  href="#" onclick="CheckReverse()"><asp:Label ID="lblCheckRecerse" runat="server" Text="<%$ Resources:Resources, IDS_Label_CheckReverse %>"></asp:Label></a></li>
                 <li class="spirtLines">|</li>
                 <li class="userGroupDelCheck"><Hishop:DeleteImageLinkButton ID="lkbDeleteCheck" runat="server" Text="<%$Resources:Resources, IDS_Button_DeleteCheck %>" /></li>			                 
               </ul>
            </div>
            <div class="grdGroupList">
                <asp:GridView ID="grdVoteItem" runat="server" AutoGenerateColumns="false" ShowHeader="true" DataKeyNames="VoteItemId" CssClass="GridViewStyle" GridLines="None" RowStyle-CssClass="grdrow" HeaderStyle-CssClass="GridViewHeaderStyle" >                                                        
                        <Columns>                                       
                            <Hishop:CheckBoxColumn ReadOnly="true" HeadWidth="30"/>
			                <asp:TemplateField HeaderText="<%$ Resources:VoteItems, IDM_grdVoteItmeName %>">
			                    <ItemTemplate>
			                        <asp:Label ID="lblVoteItemName" runat="server" Text='<%# Eval("VoteItemName") %>'></asp:Label>
			                    </ItemTemplate>
			                    <EditItemTemplate>
			                        <Hishop:HtmlDecodeTextBox ID="txtVoteItemName" runat="server" Text='<%# Eval("VoteItemName") %>' />
			                         <asp:LinkButton ID="lkbUpdate" runat="server" CssClass="SmallCommonTextButton" CommandName="Update" Text="<%$ Resources:VoteItems, IDS_FormField_UpdateVoteItem%>"></asp:LinkButton>
                                    <asp:LinkButton ID="lkbCancel" runat="server" CssClass="SmallCommonTextButton" CommandName="Cancel" Text="<%$ Resources:VoteItems, IDS_FormField_CancelVoteItem%>"></asp:LinkButton>
			                    </EditItemTemplate>
			                </asp:TemplateField>
			                <asp:TemplateField HeaderText="<%$ Resources:VoteItems,IDS_grdVoteItmeLenth %>" >
                                <ItemTemplate>
                                    <img width='<%# string.Format("{0}px", Eval("Lenth")) %>' height="15" class="votelenth"/>
                                </ItemTemplate>
                            </asp:TemplateField>    
                            <asp:TemplateField HeaderText="<%$ Resources:VoteItems,IDS_grdVoteItmePercentage %>" >
                                <ItemTemplate>
                                    <asp:Label ID="lblPercentage" runat="server" Text='<%# Eval("Percentage") %>' ></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>  
                            <asp:BoundField HeaderText="<%$ Resources:VoteItems,IDS_grdVoteItmeCount %>" DataField="ItemCount"  ReadOnly="true" /> 
                             <asp:TemplateField HeaderText="<%$ Resources:Resources, IDS_Header_Options %>" ItemStyle-Width="10%">
                                 <ItemStyle CssClass="handleRightSelect"/>
                                 <ItemTemplate>
	                                <asp:LinkButton ID="LinkButton1" runat="server" CssClass="SmallCommonTextButton" CommandName="Edit" Text="<%$ Resources:VoteItems, IDS_FormField_EditVoteItem%>"></asp:LinkButton>
                                    <Hishop:DeleteImageLinkButton ID="lkbDelete" CssClass="SmallCommonTextButton" runat="server"  CommandName="Delete" Text="<%$ Resources:VoteItems, IDS_FormField_DeleteVoteItem %>" />
                                 </ItemTemplate>
                             </asp:TemplateField>                                                                                                                                                                                                                                   
                        </Columns>
                </asp:GridView>
            </div>
</div>   
     <!--添加/修改投票选项-->
    <div class="grdHeaderStyle" style="cursor:pointer;" onclick="expItemsTable('addItemsTable');">
        <ul>
            <li class="addProductTmpt">
                <asp:Literal ID="litAddVoteItem" Text='<%$Resources:VoteItems,IDS_Literal_AddVoteItem %>' runat="server"></asp:Literal>
            </li>
        </ul>
    </div>
            <table style="width: 100%;" cellspacing="0" cellpadding="0" class="formTableList" id="addItemsTable">
                <tr>
                    <td class="leftTD"><asp:Label ID="lblVoteItemId" runat="server" Visible="false"></asp:Label>
                        <nobr><asp:Label id="lblAddVoteItemName" runat="server"  Text="<%$ Resources:VoteItems,IDS_Label_VoteItemName%>"></asp:Label></nobr>
                    </td>
                    <td class="rightTD">
                        <Hishop:DefaultButtonTextBox ID="txtAddVoteItemName" runat="server" Button="btnAddProductTemplet"></Hishop:DefaultButtonTextBox>
                    </td>
                    <td class="rightTD">
                        <div id="txtAddVoteItemNameTip" runat="server"></div>
                        <Hishop:ValidateTarget ID="ValidateAddNameItem" ContainerId="ValidatorContainer" runat="server" ControlToValidate="txtAddVoteItemName" Description="<%$ Resources:VoteItems,IDS_Help_Name %>" Nullable="false">
                            <Validators>
                                <Hishop:InputStringClientValidator ErrorMessage="<%$ Resources:VoteItems, IDS_Help_Name %>" LowerBound="1" UpperBound="100" />
                            </Validators>
                        </Hishop:ValidateTarget>		            
                    </td>
                </tr>
                <tr>
                    <td class="bottonLeftTD">&nbsp;</td>
                    <td class="rightTD">
                        <asp:Button ID="btnAddVoteItem" runat="server" Text="<%$ Resources:VoteItems, IDS_Button_AddVoteItem %>"  OnClientClick="return PageIsValid()"  CssClass="inp_L1"/>                        
                    </td>
                    <td class="rightTD">&nbsp;</td>
                </tr>
            </table>
            </SkinTemplate>
            </Hishop:VoteItems>
        </div>
        <br />
        <div style="text-align:center">
            <hr style="width:500px;" />
            <Hishop:SiteCopyright runat="server" />
        </div>
        <br />
        <Hishop:ValidatorContainer runat="server" ID="ValidatorContainer" />
    </form>
</body>
</html>
