﻿var selectedProductId = 0;

// 根据商品编号添加到购物车
function AddToCart(productId) {
    selectedProductId = productId;
    
    $.ajax({
        url: "ShoppingHandler.aspx?action=AddToCartById&productId=" + productId + "&timestamp=" + new Date().getTime(),
        type: 'GET', dataType: 'json', timeout: 10000,
        success: function(resultData) {
            if (resultData.Status == "OK") {
                // 商品成功加入购物车
                FocusShoppingCart();
            }
            else if (resultData.Status == "0") {
                // 商品不存在
                alert("此商品已经删除");
            }
            else if (resultData.Status == "1") {
                // 商品已经下架
                alert("此商品已经下架，暂时不能购买");
            }
            else if (resultData.Status == "2") {
                // 没有任何规格
                alert("此商品没有任何规格，暂时不能购买");
            }
            else if (resultData.Status == "3") {
                // 商品库存不足
                alert("此商品库存不足");
            }
            else if (resultData.Status == "s") {
                // 多规格，弹出规格选择框
                ToggleSelector(resultData.ImageUrl, resultData.Skus);
            }
            else {
                // 抛出异常消息
                alert(resultData.Status);
            }
        }
    });
}

// 添加成功以后打开并聚焦到购物车页面
function FocusShoppingCart() {
    var cartForm = window.open(applicationPath + "/ShoppingCart.aspx", "ShoppingCart");
    if (cartForm != null && !cartForm.closed) cartForm.focus();
}

// 弹出规格选择框
function ToggleSelector(imageUrl, skus) {
    if (skuSelector.get_isShowing()) {
        selectedProductId = 0;
        skuSelector.Close();
    }
    else {
        $("#skuSelectContainer").empty();
        $.each(skus, function(i, item) {
            var itemContainer = $("<tr><td>" + item.FieldName + ":</td><td><select id=\"skuSelector_" + i + "\"><option value=\"\">请选择</option>" + CreateOptions(item.Options) + "</select></td></tr>");
            $("#skuSelectContainer").append(itemContainer);
        });
        $("#skuSelectorMsg").empty();
        skuSelector.Show();
    }
}

// 创建规格下拉框的可选项
function CreateOptions(options) {
    var arr = options.split(",");
    var op = "";

    $.each(arr, function(i, option) {
        if (option.length > 0) {
            op += "<option value=\"" + option + "\">" + option + "</option>";
        }
    });

    return op;
}

// 选择规格并提交
function SelectOptions() {
    var selectList = $("#skuSelectContainer select");
    var options = "";
    var allSelected = true;

    if (selectList.length == 0) {
        $("#skuSelectorMsg").text("没有可供选择的规格!");
        return;
    }

    $.each(selectList, function(i, item) {
        if ($(item).val().length == 0) {
            allSelected = false;
        }
        else {
            options += $(item).val() + ",";
        }
    });

    if (allSelected) {
        $("#skuSelectorMsg").empty();
        AddToCartByOptions(options);
    }
    else {
        $("#skuSelectorMsg").text("请先选择商品规格!");
    }
}

// 根据选择的规格添加到购物车
function AddToCartByOptions(options) {
    $.ajax({
        url: "ShoppingHandler.aspx",
        type: 'post', dataType: 'json', timeout: 10000,
        data: { action: "AddToCartByOptions", productId: selectedProductId, options: options },
        success: function(resultData) {
            if (resultData.Status == "OK") {
                // 商品成功加入购物车
                skuSelector.Close();
                FocusShoppingCart();
            }
            else if (resultData.Status == "0") {
                // 没有选择任何规格
                $("#skuSelectorMsg").text("请先选择商品规格!");
            }
            else if (resultData.Status == "1") {
                // 没有匹配的规格
                $("#skuSelectorMsg").text("此商品没有您选择的规格!");
            }
            else if (resultData.Status == "2") {
                // 商品已经下架
                $("#skuSelectorMsg").text("此商品已经下架，暂时不能购买!");
            }
            else if (resultData.Status == "3") {
                // 商品库存不足
                $("#skuSelectorMsg").text("此规格商品库存不足!");
            }
            else {
                // 抛出异常消息
                alert(resultData.Status);
            }
        }
    });
}