using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
//Դwww.51aspx.com()

namespace SQLHelper
{
    public class DBHelper
    {
        /// <summary>
        /// ݿַ
        /// </summary>
        /// <returns></returns>
        public static String GetSqlConnection()
        {
            String conn = ConfigurationManager.AppSettings["SQLCONNECTIONSTRING"].ToString();
            return conn;
        }
        /// <summary>
        ///  ò 
        /// </summary>
        /// <param name="paramName"></param>
        /// <param name="paramType"></param>
        /// <param name="paramSize"></param>
        /// <param name="ColName">Դ</param>
        /// <param name="paramValue">ʵֵ</param>
        /// <returns></returns>
        public static SqlParameter GetParameter(String paramName, SqlDbType paramType, Int32 paramSize, String ColName, Object paramValue)
        {
            SqlParameter param = new SqlParameter(paramName, paramType, paramSize, ColName);
            param.Value = paramValue;
            return param;
        }
        /// <summary>
        /// ò
        /// </summary>
        /// <param name="paramName"></param>
        /// <param name="paramType"></param>
        /// <param name="paramSize"></param>
        /// <param name="ColName">Դ</param>
        /// <returns></returns>
        public static SqlParameter GetParameter(String paramName, SqlDbType paramType, Int32 paramSize, String ColName)
        {
            SqlParameter param = new SqlParameter(paramName, paramType, paramSize, ColName);
            return param;
        }
        /// <summary>
        /// ò
        /// </summary>
        /// <param name="paramName"></param>
        /// <param name="paramType"></param>
        /// <param name="paramSize"></param>
        /// <param name="ColName">Դ</param>
        /// <returns></returns>
        public static SqlParameter GetParameter(String paramName, SqlDbType paramType, Object paramValue)
        {
            SqlParameter param = new SqlParameter(paramName, paramType);
            param.Value = paramValue;
            return param;
        }
        /// <summary>
        /// ִSQL
        /// </summary>
        /// <param name="Sqlstr">SQL</param>
        /// <param name="param"></param>
        /// <returns></returns>
        public static int ExecuteSql(String Sqlstr, SqlParameter[] param)
        {
            String ConnStr = GetSqlConnection();
            using (SqlConnection conn = new SqlConnection(ConnStr))
            {
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = conn;
                cmd.CommandText = Sqlstr;
                cmd.Parameters.AddRange(param);
                conn.Open();
                cmd.ExecuteNonQuery();
                conn.Close();
                return 1;
            }
        }
        /// <summary>
        /// ִSQL䲢ݱ
        /// </summary>
        /// <param name="Sqlstr">SQL</param>
        /// <returns></returns>
        public static DataTable ExecuteDt(String Sqlstr)
        {
            String ConnStr = GetSqlConnection();
            using (SqlConnection conn = new SqlConnection(ConnStr))
            {
                SqlDataAdapter da = new SqlDataAdapter(Sqlstr, conn);
                DataTable dt = new DataTable();
                conn.Open();
                da.Fill(dt);
                conn.Close();
                return dt;
            }
        }

        /// <summary>
        /// ִSQL䲢ݱ
        /// </summary>
        /// <param name="Sqlstr">SQL</param>
        /// <param name="param">б</param>
        /// <returns></returns>
        public static DataTable ExecuteDt(String Sqlstr, SqlParameter[] param)
        {
            String ConnStr = GetSqlConnection();
            using (SqlConnection conn = new SqlConnection(ConnStr))
            {
                DataTable dt = new DataTable();
                SqlDataAdapter da = new SqlDataAdapter();
                SqlCommand cmd = new SqlCommand(Sqlstr, conn);//ִ
                cmd.Connection = conn;
                cmd.Parameters.AddRange(param);//б
                da.SelectCommand = cmd;
                conn.Open();
                da.Fill(dt);
                conn.Close();
                return dt;
            }
        }

        /// <summary>
        /// ִSQL
        /// </summary>
        /// <param name="Sqlstr">SQL</param>
        /// <param name="param">SQL</param>
        /// <returns></returns>
        public static Int32 ExecuteSqls(String[] Sqlstr, List<SqlParameter[]> param)
        {
            String ConnStr = GetSqlConnection();
            using (SqlConnection conn = new SqlConnection(ConnStr))
            {

                SqlCommand cmd = new SqlCommand();
                SqlTransaction tran = null;
                cmd.Transaction = tran;
                try
                {
                    conn.Open();
                    tran = conn.BeginTransaction();
                    cmd.Connection = conn;
                    cmd.Transaction = tran;

                    Int32 count = Sqlstr.Length;
                    for (Int32 i = 0; i < count; i++)
                    {
                        cmd.CommandText = Sqlstr[i];
                        cmd.Parameters.AddRange(param[i]);
                        cmd.ExecuteNonQuery();
                    }
                    tran.Commit();
                    return 1;
                }
                catch
                {
                    tran.Rollback();
                    return 0;
                }
                finally
                {
                    cmd.Dispose();
                    conn.Close();
                }
            }
        }

        /// <summary>
        /// ִSQL䲢DataSet
        /// </summary>
        /// <param name="Sqlstr">SQL</param>
        /// <returns></returns>
        public static DataSet ExecuteDs(String Sqlstr)
        {
            String ConnStr = GetSqlConnection();
            using (SqlConnection conn = new SqlConnection(ConnStr))
            {
                SqlDataAdapter da = new SqlDataAdapter(Sqlstr, conn);
                DataSet ds = new DataSet();
                conn.Open();
                da.Fill(ds);
                conn.Close();
                return ds;
            }
        }

        /// <summary>
        /// ִSQL䲢DataSet
        /// </summary>
        /// <param name="Sqlstr">SQL</param>
        /// <param name="param">б</param>
        /// <returns></returns>
        public static DataSet ExecuteDs(String Sqlstr, SqlParameter[] param)
        {
            String ConnStr = GetSqlConnection();
            using (SqlConnection conn = new SqlConnection(ConnStr))
            {
                DataSet ds = new DataSet();
                SqlDataAdapter da = new SqlDataAdapter();
                SqlCommand cmd = new SqlCommand(Sqlstr, conn);//ִ
                cmd.Connection = conn;
                cmd.Parameters.AddRange(param);//б
                da.SelectCommand = cmd;
                conn.Open();
                da.Fill(ds);
                conn.Close();
                return ds;
            }
        }
    }
}
