﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
/// <summary>
/// Cart 的摘要说明
/// </summary>
namespace BLL
{
    public class Cart
    {
        #region 增
        #endregion
        #region 删
        #endregion
        #region 改
        #endregion
        #region 查
        #endregion
        public Cart()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        /// <summary>
        /// 添加到购物车
        /// </summary>
        /// <param name="product"></param>
        /// <param name="count"></param>
        /// <param name="checkout"></param>
        /// <returns></returns>
        public int createcart(int productid, int userid, int count, bool checkout)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Cart (ProductID,[UserID],[Count],CheckOut) ");
            sb.Append("values (@ProductID,@UserID,@Count,@CheckOut)");
            SqlParameter[] parem =
                                   {
                                       DBHelper.GetParameter("@ProductID",SqlDbType.Int,4,"ProductID",productid),
                                       DBHelper.GetParameter("@UserID",SqlDbType.Int,4,"[UserID]",userid),
                                       DBHelper.GetParameter("@Count",SqlDbType.Int,4,"[Count]",count),
                                       DBHelper.GetParameter("@CheckOut",SqlDbType.Bit,1,"CheckOut",checkout)
                                   };
            return DBHelper.ExecuteSql(sb.ToString(), parem);
        }

        /// <summary>
        /// 删除一件商品
        /// </summary>
        /// <param name="cartid"></param>
        /// <returns></returns>
        public int deletecart(int cartid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Cart where Cartid=@Cartid");
            SqlParameter[] param = { DBHelper.GetParameter("@Cartid", SqlDbType.Int, 4, "Cartid", cartid) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 批量删除商品
        /// </summary>
        /// <param name="cartids"></param>
        /// <returns></returns>
        public int deltecartlist(int[] cartids)
        {
            List<SqlParameter[]> paramlist = new List<SqlParameter[]>();
            List<string> sqls = new List<string>();
            for (int i = 0; i < cartids.Length; i++)
            {
                sqls.Add("delete from Cart where Cartid=@Cartid" + i.ToString());
                SqlParameter[] param = { DBHelper.GetParameter("@Cartid" + i.ToString(), SqlDbType.Int, 4, "Cartid", cartids[i]) };
                paramlist.Add(param);
            }
            return DBHelper.ExecuteSqls(sqls.ToArray(), paramlist);
        }

        /// <summary>
        /// 获得购物列表
        /// </summary>
        /// <returns></returns>
        public DataTable selectcartlist()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT Cart.Cartid, Cart.[Count], Cart.CheckOut,Cart.[UserID], ");
            sb.Append("Cart.ProductID, Products.ProductName, Products.Recommended, Products.Specials, Products.Price, ");
            sb.Append("Products.UserPrice, Products.SpecialsPrice ");
            sb.Append("FROM Cart INNER JOIN Products ON Cart.ProductID = Products.ProductID where Cart.CheckOut=0");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        /// 获得某个用户的购物列表
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public DataTable getcartlist(int userid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT Cart.Cartid, Cart.[Count], Cart.CheckOut, Cart.ProductID, Cart.[UserID],");
            sb.Append("Products.ProductName, Products.Recommended, Products.Specials, Products.Price,");
            sb.Append("Products.UserPrice, Products.SpecialsPrice ");
            sb.Append("FROM Cart INNER JOIN Products ON Cart.ProductID=Products.ProductID ");
            sb.Append("WHERE Cart.CheckOut=0 and Cart.[UserID]=@UserID");
            SqlParameter[] param = { DBHelper.GetParameter("@UserID", SqlDbType.Int, 4, "Cart.[UserID]", userid) };
            return DBHelper.ExecuteDt(sb.ToString(), param);
        }

        /// <summary>
        /// 修改购物列表的购买数量
        /// </summary>
        /// <param name="cartids"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public int updatecartlist(int[] cartids, int[] count)
        {
            List<SqlParameter[]> paramlist = new List<SqlParameter[]>();
            List<string> sqls = new List<string>();
            for (int i = 0; i < cartids.Length; i++)
            {
                sqls.Add("update Cart set [Count]=@Count " + i.ToString() + "where Cartid=@Cartid" + i.ToString());
                SqlParameter[] param = 
                                        {
                                            DBHelper.GetParameter("@Count" + i.ToString(),SqlDbType.Int,4,"[Count]",count[i]),
                                            DBHelper.GetParameter("@Cartid" + i.ToString(),SqlDbType.Int,4,"Cartid",cartids[i])
                                        };
                paramlist.Add(param);
            }

            return DBHelper.ExecuteSqls(sqls.ToArray(), paramlist);
        }

        public int updatecart(int productid, int userid, int count)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Cart set [Count]=@Count where ProductID=@ProductID and [UserID]=@UserID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@Count",SqlDbType.Int,4,"[Count]",count),
                                        DBHelper.GetParameter("@ProductID",SqlDbType.Int,4,"ProductID",productid),
                                        DBHelper.GetParameter("@UserID",SqlDbType.Int,4,"[UserID]",userid)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 商品是否存在购物车里
        /// </summary>
        /// <param name="productid"></param>
        /// <returns></returns>
        public bool isexitproduct(int productid, int userid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select ProductID from Cart where CheckOut=0 and ProductID=@ProductID and [UserID]=@UserID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ProductID",SqlDbType.Int,4,"ProductID",productid),
                                        DBHelper.GetParameter("@UserID",SqlDbType.Int,4,"[UserID]",userid)
                                    };
            return DBHelper.ExecuteDt(sb.ToString(), param).Rows.Count > 0 ? true : false;
        }

        /// <summary>
        /// 根据某一购物商品的数量
        /// </summary>
        /// <param name="cartid"></param>
        /// <returns></returns>
        public int updatecart(int productid, int userid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Cart set [Count]=[Count]+1 where ProductID=@ProductID and [UserID]=@UserID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ProductID",SqlDbType.Int,4,"ProductID",productid),
                                        DBHelper.GetParameter("@UserID",SqlDbType.Int,4,"[UserID]",userid)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 修改商品的购物状态
        /// </summary>
        /// <param name="cartid"></param>
        /// <returns></returns>
        public int updatestate(int productid, int userid, bool checkout)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Cart set CheckOut=@CheckOut where ProductID=@ProductID and [UserID]=@UserID");
            SqlParameter[] param = 
                                    {
                                         DBHelper.GetParameter("@CheckOut",SqlDbType.Bit,1,"CheckOut",checkout),
                                        DBHelper.GetParameter("@ProductID",SqlDbType.Int,4,"ProductID",productid),
                                        DBHelper.GetParameter("@UserID",SqlDbType.Int,4,"[UserID]",userid)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 购物成功后商品数量减一
        /// </summary>
        /// <param name="productid"></param>
        public void updateproduct(int productid, int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Products set [Count]=[Count]-" + num + ",sellCount=sellCount +" + num + " where ProductID=@ProductID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ProductID",SqlDbType.Int,4,"ProductID",productid),
                                        //DBHelper.GetParameter("@num",SqlDbType.Int,num)
                                    };
            DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 获得一条购物纪录
        /// </summary>
        /// <param name="productid"></param>
        /// <returns></returns>
        public DataRow getonecartbyproductid(int productid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT Cart.Count ,Products.ProductName, Products.Recommended, Products.Specials, Products.Price, Products.UserPrice, Products.SpecialsPrice");
            sb.Append(" FROM Cart INNER JOIN Products ON Cart.ProductID = Products.ProductID");
            sb.Append(" WHERE Products.ProductID=@ProductID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ProductID",SqlDbType.Int,4,"Products.ProductID",productid)
                                    };
            return DBHelper.ExecuteDt(sb.ToString(), param).Rows[0];
        }

        /// <summary>
        /// 根据商品ID获得一条购物纪录的数量
        /// </summary>
        /// <param name="productid"></param>
        /// <returns></returns>
        public int getcartnum(int cartid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select [Count] from Cart where Cartid=@Cartid");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@Cartid",SqlDbType.Int,4,"Cartid",cartid)
                                    };
            return int.Parse(DBHelper.ExecuteDt(sb.ToString(), param).Rows[0]["Count"].ToString());
        }
    }
}