﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;

/// <summary>
/// Class_1 的摘要说明
/// </summary>
namespace BLL
{
    public class Class_1
    {
        #region 增

        /// <summary>
        /// 创建一个一级分类
        /// </summary>
        /// <param name="ClassName">一级分类名称</param>
        /// <returns></returns>
        public int createClass_1(string ClassName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Class_1 ([ClassName]) values (@ClassName)");
            SqlParameter[] param = { DBHelper.GetParameter("@ClassName", SqlDbType.NVarChar, 50, "[ClassName]", ClassName) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 删

        /// <summary>
        /// 删除一级分类
        /// </summary>
        /// <param name="Class_1">一级分类编号</param>
        /// <returns></returns>
        public int deleteClass_1(int Class_1)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Class_1 where [ClassID_1]=@ClassID_1");
            SqlParameter[] param = { DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "[ClassID_1]", Class_1) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 改

        /// <summary>
        /// 更新一级分类
        /// </summary>
        /// <param name="Class_1">一级分类编号</param>
        /// <param name="ClassName">一级分类名称</param>
        /// <returns></returns>
        public int updateClass_1(int Class_1, string ClassName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Class_1 set [ClassName]=@ClassName where [ClassID_1]=@ClassID_1");
            SqlParameter[] param = 
                                   { 
                                       DBHelper.GetParameter("@ClassName", SqlDbType.NVarChar, 50, "[ClassName]", ClassName),
                                       DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "[ClassID_1]", Class_1)
                                     
                                   };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 查

        /// <summary>
        /// 按升序取得一级类型前n个.
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable toplist(int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " * from Class_1 order by ClassID_1");
            return DBHelper.ExecuteDt(sb.ToString());
        }
        /// <summary>
        /// 根据类型名称查询商品一级分类
        /// </summary>
        /// <param name="ClassName"></param>
        /// <returns></returns>
        public DataTable Class_1list(string ClassName)
        {
            List<SqlParameter> list = new List<SqlParameter>();
            StringBuilder sb = new StringBuilder();
            sb.Append("select [ClassID_1],[ClassName] from Class_1 where 1 = @index");

            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (ClassName != "")
            {
                sb.Append(" and [ClassName] like '%' + @ClassName + '%'");
                list.Add(DBHelper.GetParameter("@ClassName", SqlDbType.NVarChar, 50, "[ClassName]", ClassName));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        /// <summary>
        /// 是否已经存在该分类
        /// </summary>
        /// <param name="ClassName"></param>
        /// <returns></returns>
        public bool IsExite(string ClassName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select [ClassName] from Class_1 where [ClassName]=@ClassName");
            SqlParameter[] param = { DBHelper.GetParameter("@ClassName", SqlDbType.NVarChar, 50, "[ClassName]", ClassName) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows.Count > 0 ? true : false;
        }

        /// <summary>
        /// 根据类型ID获得类型名称
        /// </summary>
        /// <param name="typeid"></param>
        /// <returns></returns>
        public string getClassName(int typeid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select [ClassName] from Class_1 where [ClassID_1]=@ClassID_1");
            SqlParameter[] param = { DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "[ClassID_1]", typeid) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows.Count > 0 ? table.Rows[0]["ClassName"].ToString() : " ";
        }

        #endregion
        public Class_1()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
    }
}