﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;

/// <summary>
/// Class_2 的摘要说明
/// </summary>
namespace BLL
{
    public class Class_2
    {
        #region 增

        /// <summary>
        /// 创建一个商品二级分类
        /// </summary>
        /// <param name="ClassID_1"></param>
        /// <param name="ClassName"></param>
        /// <returns></returns>
        public int createClass_2(int ClassID_1, string ClassName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Class_2 ([ClassID_1],[ClassName]) values (@ClassID_1,@ClassName)");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ClassID_1",SqlDbType.Int,4,"[ClassID_1]",ClassID_1),
                                        DBHelper.GetParameter("@ClassName",SqlDbType.NVarChar,50,"[ClassName]",ClassName)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 删

        /// <summary>
        /// 删除一个商品二级分类
        /// </summary>
        /// <param name="ClassID_2"></param>
        /// <returns></returns>
        public int deleteClass_2(int ClassID_2)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Class_2 where [ClassID_2]=@ClassID_2");
            SqlParameter[] param = { DBHelper.GetParameter("@ClassID_2", SqlDbType.Int, 4, "[ClassID_2]", ClassID_2) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 改

        /// <summary>
        /// 修改一个商品二级分类
        /// </summary>
        /// <param name="ClassID_1"></param>
        /// <param name="ClassName"></param>
        /// <returns></returns>
        public int updateClass_2(int ClassID_2, int ClassID_1, string ClassName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Class_2 set [ClassID_1]=@ClassID_1,[ClassName]=@ClassName where [ClassID_2]=@ClassID_2");
            SqlParameter[] param = 
                                   { 
                                        DBHelper.GetParameter("@ClassID_1",SqlDbType.Int,4,"[ClassID_1]",ClassID_1),
                                        DBHelper.GetParameter("@ClassName",SqlDbType.NVarChar,50,"[ClassName]",ClassName),
                                        DBHelper.GetParameter("@ClassID_2",SqlDbType.Int,4,"[ClassID_2]",ClassID_2)
                                   };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 查

        /// <summary>
        /// 连接查询,top n
        /// </summary>
        /// <param name="?"></param>
        /// <param name="?"></param>
        /// <param name="ClassID_1"></param>
        /// <param name="ClassName"></param>
        /// <returns></returns>
        public DataTable Class_2listtop(int num,int ClassID_1, string ClassName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT top " + num + " Class_1.ClassName as Class_1name, Class_2.ClassID_1, Class_2.ClassID_2 , Class_2.ClassName as Class_2name ");
            sb.Append("FROM Class_1 INNER JOIN Class_2 ON Class_1.ClassID_1 = Class_2.ClassID_1 where 1 = @index");
            List<SqlParameter> list = new List<SqlParameter>();
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (ClassID_1 != 0)
            {
                list.Add(DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "[ClassID_1]", ClassID_1));
                sb.Append(" and Class_2.ClassID_1=@ClassID_1");
            }
            if (ClassName != "")
            {
                list.Add(DBHelper.GetParameter("@ClassName", SqlDbType.NVarChar, 50, "ClassName", ClassName));
                sb.Append(" and Class_2.ClassName like '%' + @ClassName + '%'");
            }
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }
        /// <summary>
        /// 查找某一大类下的前n条
        /// </summary>
        /// <param name="num"></param>
        /// <param name="TypeID_1"></param>
        /// <returns></returns>
        public DataTable toplist(int num, int ClassID_1)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("select top " + num + " * from Class_2 where ClassID_1 = @ClassID_1 order by ClassID_2");
            list.Add(DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "[ClassID_1]", ClassID_1));
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }
        /// <summary>
        /// 查询商品二级分类
        /// </summary>
        /// <param name="ClassID_1"></param>
        /// <param name="ClassName"></param>
        /// <returns></returns>
        public DataTable Class_2list(int ClassID_1, string ClassName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT Class_1.ClassName as Class_1name, Class_2.ClassID_1, Class_2.ClassID_2 , Class_2.ClassName as Class_2name ");
            sb.Append("FROM Class_1 INNER JOIN Class_2 ON Class_1.ClassID_1 = Class_2.ClassID_1 where 1 = @index");
            List<SqlParameter> list = new List<SqlParameter>();
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (ClassID_1 != 0)
            {
                list.Add(DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "[ClassID_1]", ClassID_1));
                sb.Append(" and Class_2.ClassID_1=@ClassID_1");
            }
            if (ClassName != "")
            {
                list.Add(DBHelper.GetParameter("@ClassName", SqlDbType.NVarChar, 50, "ClassName", ClassName));
                sb.Append(" and Class_2.ClassName like '%' + @ClassName + '%'");
            }
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        /// <summary>
        /// 分类是否存在
        /// </summary>
        /// <param name="ClassName"></param>
        /// <returns></returns>
        public bool IsExite(string ClassName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select ClassName from Class_2 where ClassName=@ClassName");
            SqlParameter[] param = 
                                   { DBHelper.GetParameter("@ClassName", SqlDbType.NVarChar, 50, "[ClassName]", ClassName) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows.Count > 0 ? true : false;
        }

        /// <summary>
        /// 根据类型ID获得类型名称
        /// </summary>
        /// <param name="typeid"></param>
        /// <returns></returns>
        public string getClassName(int typeid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select ClassName from Class_2 where ClassID_2=@ClassID_1");
            SqlParameter[] param = { DBHelper.GetParameter("@ClassID_1", SqlDbType.Int, 4, "ClassID_1", typeid) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows.Count > 0 ? table.Rows[0]["ClassName"].ToString() : "";
        }

        #endregion
        public Class_2()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
    }
}