﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
/// <summary>
/// Order 的摘要说明
/// </summary>
namespace BLL
{
    public class Order
    {
        #region 增
        #endregion
        #region 删
        #endregion
        #region 改
        #endregion
        #region 查
        #endregion
        public Order()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        /// <summary>
        /// 添加一条订单纪录
        /// </summary>
        /// <param name="orderid">订单号</param>
        /// <param name="productid">商品号</param>
        /// <param name="userid">用户编号</param>
        /// <param name="acceptname">收货人</param>
        /// <param name="address">收货地址</param>
        /// <param name="postalcode">邮政编码</param>
        /// <param name="phone">联系电话</param>
        /// <param name="delivery">送货方式</param>
        /// <param name="payment">付款方式</param>
        /// <param name="state">订单状态</param>
        /// <param name="ordertime">下单时间</param>
        /// <param name="orderprice">订单总额</param>
        /// <returns></returns>
        public int createorder(string orderid, string productid, int userid, string acceptname,
            string address, string postalcode, string phone, string delivery, string payment, int state, DateTime ordertime, double orderprice)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Orders (OrderID,ProductID,[UserID],AcceptName,Address,PostalCode,Phone,Delivery,Payment,State,OrderTime,OrderPrice) values ");
            sb.Append("(@OrderID,@ProductID,@UserID,@AcceptName,@Address,@PostalCode,@Phone,@Delivery,@Payment,@State,@OrderTime,@OrderPrice)");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@OrderID",SqlDbType.NVarChar,50,"OrderID",orderid),
                                        DBHelper.GetParameter("@ProductID",SqlDbType.NVarChar,50,"ProductID",productid),
                                        DBHelper.GetParameter("@UserID",SqlDbType.Int,4,"[UserID]",userid),
                                        DBHelper.GetParameter("@AcceptName",SqlDbType.NVarChar,50,"AcceptName",acceptname),
                                        DBHelper.GetParameter("@Address",SqlDbType.NVarChar,200,"Address",address),
                                        DBHelper.GetParameter("@PostalCode",SqlDbType.NVarChar,50,"PostalCode",postalcode),
                                        DBHelper.GetParameter("@Phone",SqlDbType.NVarChar,50,"Phone",phone),
                                        DBHelper.GetParameter("@Delivery",SqlDbType.NVarChar,50,"Delivery",delivery),
                                        DBHelper.GetParameter("@Payment",SqlDbType.NVarChar,50,"Payment",payment),
                                        DBHelper.GetParameter("@State",SqlDbType.Int,4,"State",state),
                                        DBHelper.GetParameter("@OrderTime",SqlDbType.DateTime,8,"OrderTime",ordertime),
                                        DBHelper.GetParameter("@OrderPrice",SqlDbType.Money,8,"OrderPrice",orderprice)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 更新订单状态
        /// </summary>
        /// <param name="orderid">订单号</param>
        /// <param name="state">订单状态</param>
        /// <returns></returns>
        public int updatestate(string orderid, int state)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Orders set State=@State where OrderID=@OrderID");
            SqlParameter[] param = 
                                    { DBHelper.GetParameter("@State", SqlDbType.Int, 4, "State", state), 
                                      DBHelper.GetParameter("@OrderID", SqlDbType.NVarChar, 50, "OrderID", orderid)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 根据条件查询订单纪录
        /// </summary>
        /// <param name="username">用户名</param>
        /// <param name="ordertime">下单时间</param>
        /// <param name="state">订单状态</param>
        /// <returns></returns>
        public DataTable selectorderlist(string username, string ordertime, int state)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT UserInfo.UserID, UserInfo.UserName,Orders.OrderID, Orders.AcceptName, Orders.Address,");
            sb.Append("Orders.PostalCode, Orders.Phone, Orders.Delivery, Orders.Payment, Orders.State,");
            sb.Append("Orders.OrderTime, Orders.OrderPrice ");
            sb.Append("FROM Orders INNER JOIN UserInfo ON Orders.UserID = UserInfo.UserID");
            sb.Append(" where 1=@index");
            List<SqlParameter> list = new List<SqlParameter>();
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (username != "")
            {
                sb.Append(" and UserInfo.UserName like '%' + @UserName + '%'");
                list.Add(DBHelper.GetParameter("@UserName", SqlDbType.NVarChar, 50, "UserInfo.UserName", username));
            }
            //if (ordertime != "")
            //{
            //    sb.Append(" and orders.ordertime = # +  @ordertime #");
            //    list.Add(DBHelper.GetParameter("@ordertime", SqlDbType.NVarChar, 50, "orders.ordertime", ordertime));
            //}
            if (state == 0 || state == 1 || state == 2 || state == 3 || state == 4 || state == 5)
            {
                sb.Append(" and Orders.State=@State");
                list.Add(DBHelper.GetParameter("@State", SqlDbType.Int, 4, "State", state));
            }
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        /// <summary>
        /// 根据用户ID获得订单列表
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public DataTable getordersbyuserid(int userid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT OrderID,ProductID,[UserID],");
            sb.Append("AcceptName,Address,PostalCode,Phone,");
            sb.Append("Delivery,Payment,State,OrderTime,OrderPrice ");
            sb.Append("from Orders where [UserID]=@UserID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@UserID",SqlDbType.Int,4,"UserID",userid)
                                    };
            return DBHelper.ExecuteDt(sb.ToString(), param);
        }

        /// <summary>
        /// 根据条件查询订单纪录
        /// </summary>
        /// <param name="state">订单状态</param>
        /// <returns></returns>
        public DataTable selectorderlist(int state)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT UserInfo.UserID, UserInfo.UserName,Orders.OrderID, Orders.AcceptName, Orders.Address,");
            sb.Append("Orders.PostalCode, Orders.Phone, Orders.Delivery, Orders.Payment, Orders.State,");
            sb.Append("Orders.OrderTime, Orders.OrderPrice ");
            sb.Append("FROM Orders INNER JOIN UserInfo ON Orders.UserID = UserInfo.UserID");
            sb.Append(" where 1=@index");
            List<SqlParameter> list = new List<SqlParameter>();
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (state == 0 || state == 1 || state == 2 || state == 3 || state == 4)
            {
                sb.Append(" and State=@State");
                list.Add(DBHelper.GetParameter("@State", SqlDbType.Int, 4, "State", state));
            }
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        public DataTable selectorderlist(string username, int state)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT UserInfo.UserID, UserInfo.UserName,Orders.OrderID, Orders.AcceptName, Orders.Address,");
            sb.Append("Orders.PostalCode, Orders.Phone, Orders.Delivery, Orders.Payment, Orders.State,");
            sb.Append("Orders.OrderTime, Orders.OrderPrice ");
            sb.Append("FROM Orders INNER JOIN UserInfo ON Orders.UserID = UserInfo.UserID");
            sb.Append(" where 1=@index");
            List<SqlParameter> list = new List<SqlParameter>();
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (username != "")
            {
                sb.Append(" and UserInfo.UserName like '%' + @UserName + '%'");
                list.Add(DBHelper.GetParameter("@UserName", SqlDbType.NVarChar, 50, "UserInfo.UserName", username));
            }
            if (state == 0 || state == 1 || state == 2 || state == 3 || state == 4)
            {
                sb.Append(" and Orders.State=@State");
                list.Add(DBHelper.GetParameter("@State", SqlDbType.Int, 4, "Orders.State", state));
            }
            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        /// <summary>
        /// 获得一条订单信息
        /// </summary>
        /// <param name="orderid"></param>
        /// <returns></returns>
        public DataRow getoneorder(string orderid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT OrderID,ProductID,[UserID],");
            sb.Append("AcceptName,Address,PostalCode,Phone,");
            sb.Append("Delivery,Payment,State,OrderTime,OrderPrice ");
            sb.Append("from Orders where OrderID=@OrderID");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@OrderID",SqlDbType.NVarChar,50,"OrderID",orderid)
                                    };
            return DBHelper.ExecuteDt(sb.ToString(), param).Rows[0];
        }
    }
}