﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
/// <summary>
/// Products 的摘要说明
/// </summary>
namespace BLL
{
    public class Products
    {
        #region 增

        /// <summary>
        /// 创建一个商品
        /// </summary>
        /// <param name="productname">商品名称</param>
        /// <param name="typeid_1">商品一级分类</param>
        /// <param name="typeid_2">商品二级分类</param>
        /// <param name="recommended">是否推荐</param>
        /// <param name="specials">是否特价</param>
        /// <param name="price">商品原价</param>
        /// <param name="userprice">会员价格</param>
        /// <param name="specialsprice">推荐价格</param>
        /// <param name="pointcount">点击数量</param>
        /// <param name="imagepath">图片路径</param>
        /// <param name="count">商品库存数量</param>
        /// <param name="count">销售数量</param>
        /// <param name="description">商品描述</param>
        /// <returns></returns>
        public int createproduct(string productname, int typeid_1, int typeid_2, bool recommended, bool specials, double price,
            double userprice, double specialsprice, int pointcount, string imagepath, int count, int sellcount, string description)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Products ([ProductName],[TypeID_1],[TypeID_2],[Recommended],[Specials],[Price],");
            sb.Append("[UserPrice],[SpecialsPrice],[PointCount],[ImagePath],[Count],[SellCount],[Description]) values (");
            sb.Append("@ProductName,@TypeID_1,@TypeID_2,@Recommended,@Specials,@Price,@UserPrice,");
            sb.Append("@SpecialsPrice,@PointCount,@ImagePath,@Count,@SellCount,@Description)");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ProductName",SqlDbType.NVarChar,50,"ProductName",productname),
                                        DBHelper.GetParameter("@TypeID_1",SqlDbType.Int,4,"[TypeID_1]",typeid_1),
                                        DBHelper.GetParameter("@TypeID_2",SqlDbType.Int,4,"[TypeID_2]",typeid_2),
                                        DBHelper.GetParameter("@Recommended",SqlDbType.Bit,recommended),
                                        DBHelper.GetParameter("@Specials",SqlDbType.Bit,specials),
                                        DBHelper.GetParameter("@Price",SqlDbType.Money,8,"[Price]",price),
                                        DBHelper.GetParameter("@UserPrice",SqlDbType.Money,8,"[UserPrice]",userprice),
                                        DBHelper.GetParameter("@SpecialsPrice",SqlDbType.Money,8,"[SpecialsPrice]",specialsprice),
                                        DBHelper.GetParameter("@PointCount",SqlDbType.Int,4,"[PointCount]",pointcount),
                                        DBHelper.GetParameter("@ImagePath",SqlDbType.NVarChar,100,"ImagePath",imagepath),
                                        DBHelper.GetParameter("@Count",SqlDbType.Int,4,"[Count]",count),
                                        DBHelper.GetParameter("@SellCount",SqlDbType.Int,4,"[SellCount]",sellcount),
                                        DBHelper.GetParameter("@Description",SqlDbType.NVarChar,description)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 删

        /// <summary>
        /// 删除一个商品
        /// </summary>
        /// <param name="productid"></param>
        /// <returns></returns>
        public int deleteproduct(int productid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Products where productid=@productid");
            SqlParameter[] param = { DBHelper.GetParameter("@productid", SqlDbType.Int, 4, "productid", productid) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 改

        /// <summary>
        /// 更新图片路径
        /// </summary>
        /// <param name="path"></param>
        public int updatepic(string imagepath, int productid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Products set ImagePath=@ImagePath where productid=@productid");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ImagePath",SqlDbType.NVarChar,100,"ImagePath",imagepath),
                                        DBHelper.GetParameter("@productid", SqlDbType.Int, 4, "productid", productid)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }
        /// <summary>
        /// 更新一个商品
        /// </summary>
        /// <param name="productid">商品编号</param>
        /// <param name="productname">商品名称</param>
        /// <param name="typeid_1">商品一级分类</param>
        /// <param name="typeid_2">商品二级分类</param>
        /// <param name="recommended">是否推荐</param>
        /// <param name="specials">是否特价</param>
        /// <param name="price">商品原价</param>
        /// <param name="userprice">会员价格</param>
        /// <param name="specialsprice">推荐价格</param>
        /// <param name="pointcount">点击数量</param>
        /// <param name="imagepath">图片路径</param>
        /// <param name="count">商品库存数量</param>
        /// <param name="count">销售数量</param>
        /// <param name="description">商品描述</param>
        /// <returns></returns>
        public int updateproduct(int productid, string productname, int typeid_1, int typeid_2, bool recommended, bool specials, Double price,
            Double userprice, Double specialsprice, int pointcount, string imagepath, int count, int sellcount, string description)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Products set ProductName=@ProductName,TypeID_1=@TypeID_1,TypeID_2=@TypeID_2,Recommended=@Recommended,");
            sb.Append("Specials=@Specials,Price=@Price,UserPrice=@UserPrice,SpecialsPrice=@SpecialsPrice,PointCount=@PointCount,");
            sb.Append("ImagePath=@ImagePath,[Count]=@Count,SellCount=@SellCount,Description=@Description where productid=@productid");
            SqlParameter[] param = 
                                    {
                                        DBHelper.GetParameter("@ProductName",SqlDbType.NVarChar,50,"ProductName",productname),
                                        DBHelper.GetParameter("@TypeID_1",SqlDbType.Int,4,"TypeID_1",typeid_1),
                                        DBHelper.GetParameter("@TypeID_2",SqlDbType.Int,4,"TypeID_2",typeid_2),
                                        DBHelper.GetParameter("@Recommended",SqlDbType.Bit,1,"Recommended",recommended),
                                        DBHelper.GetParameter("@Specials",SqlDbType.Bit,1,"Specials",specials),
                                        DBHelper.GetParameter("@Price",SqlDbType.Money,8,"Price",price),
                                        DBHelper.GetParameter("@UserPrice",SqlDbType.Money,8,"UserPrice",userprice),
                                        DBHelper.GetParameter("@SpecialsPrice",SqlDbType.Money,8,"SpecialsPrice",specialsprice),
                                        DBHelper.GetParameter("@PointCount",SqlDbType.Int,4,"PointCount",pointcount),
                                        DBHelper.GetParameter("@ImagePath",SqlDbType.NVarChar,100,"ImagePath",imagepath),
                                        DBHelper.GetParameter("@Count",SqlDbType.Int,4,"[Count]",count),
                                        DBHelper.GetParameter("@SellCount",SqlDbType.Int,4,"SellCount",sellcount),
                                        DBHelper.GetParameter("@Description",SqlDbType.NVarChar,description),
                                        DBHelper.GetParameter("@productid", SqlDbType.Int, 4, "productid", productid)
                                    };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 查
        #region 首条,前一条,后一条,尾条
        public string getnextProduct(int ProductID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top 1 * from Products ");
            sb.Append("where ProductID<@ProductID order by ProductID desc");
            SqlParameter[] param = { DBHelper.GetParameter("@ProductID", SqlDbType.Int, 4, "ProductID", ProductID) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            if (table.Rows.Count > 0)
                return table.Rows[0]["ProductID"].ToString();
            else
                return "";
        }
        public string getpreProduct(int ProductID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top 1 * from Products ");
            sb.Append("where ProductID>@ProductID");
            SqlParameter[] param = { DBHelper.GetParameter("@ProductID", SqlDbType.Int, 4, "ProductID", ProductID) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            if (table.Rows.Count > 0)
                return table.Rows[0]["ProductID"].ToString();
            else
                return "";
        }
        #endregion

        public DataTable productlisttop(int num,int typeid_1, int typeid_2, string productname)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("select top "+num+" productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products where 1=@index");
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (typeid_1 != 0)
            {
                sb.Append(" and TypeID_1=@TypeID_1 ");
                list.Add(DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "TypeID_1", typeid_1));
            }
            if (typeid_2 != 0)
            {
                sb.Append(" and TypeID_2=@TypeID_2");
                list.Add(DBHelper.GetParameter("@TypeID_2", SqlDbType.Int, 4, "TypeID_2", typeid_2));
            }
            if (productname != "")
            {
                sb.Append(" and ProductName like '%' + @ProductName + '%'");
                list.Add(DBHelper.GetParameter("@ProductName", SqlDbType.NVarChar, 50, "ProductName", productname));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }
        /// <summary>
        /// 根据参数查询商品
        /// </summary>
        /// <param name="typeid_1"></param>
        /// <param name="typeid_2"></param>
        /// <param name="productname"></param>
        /// <returns></returns>
        public DataTable productlist(int typeid_1, int typeid_2, string productname)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("select productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products where 1=@index");
            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (typeid_1 != 0)
            {
                sb.Append(" and TypeID_1=@TypeID_1 ");
                list.Add(DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "TypeID_1", typeid_1));
            }
            if (typeid_2 != 0)
            {
                sb.Append(" and TypeID_2=@TypeID_2");
                list.Add(DBHelper.GetParameter("@TypeID_2", SqlDbType.Int, 4, "TypeID_2", typeid_2));
            }
            if (productname != "")
            {
                sb.Append(" and ProductName like '%' + @ProductName + '%'");
                list.Add(DBHelper.GetParameter("@ProductName", SqlDbType.NVarChar, 50, "ProductName", productname));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        public DataTable selectproduct(int typeid_1, int typeid_2, string productname, int recommended, int specials)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("SELECT Products.*, Type_2.typename AS typename_2, Type_1.typename AS typename_1 ");
            sb.Append("FROM Products, Type_2, Type_1 ");
            sb.Append("WHERE Products.TypeID_2=Type_2.TypeID_2 and Type_2.TypeID_1=Type_1.TypeID_1");
            if (typeid_1 != 0)
            {
                sb.Append(" and Type_2.TypeID_1=@TypeID_1 ");
                list.Add(DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "Type_2.TypeID_1", typeid_1));
            }
            if (typeid_2 != 0)
            {
                sb.Append(" and Type_2.TypeID_2=@TypeID_2");
                list.Add(DBHelper.GetParameter("@TypeID_2", SqlDbType.Int, 4, "Type_2.TypeID_2", typeid_2));
            }
            if (productname != "")
            {
                sb.Append(" and Products.ProductName like '%' + @ProductName + '%'");
                list.Add(DBHelper.GetParameter("@ProductName", SqlDbType.NVarChar, 50, "Products.ProductName", productname));
            }
            if (recommended == 1)
            {
                sb.Append(" and Products.Recommended=@Recommended");
                list.Add(DBHelper.GetParameter("@Recommended", SqlDbType.Bit, 1, "Products.Recommended", true));
            }
            if (recommended == 0)
            {
                sb.Append(" and Products.Recommended=@Recommended");
                list.Add(DBHelper.GetParameter("@Recommended", SqlDbType.Bit, 1, "Products.Recommended", false));
            }
            if (specials == 1)
            {
                sb.Append(" and Products.Specials=@Specials");
                list.Add(DBHelper.GetParameter("@Specials", SqlDbType.Bit, 1, "Products.Specials", true));
            }
            if (specials == 0)
            {
                sb.Append(" and Products.Specials=@Specials");
                list.Add(DBHelper.GetParameter("@Specials", SqlDbType.Bit, 1, "Products.Specials", false));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        /// <summary>
        ///获得一条商品纪录 
        /// </summary>
        /// <param name="productid"></param>
        /// <returns></returns>
        public DataRow getoneproduct(int productid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products ");
            sb.Append("where productid=@productid");
            SqlParameter[] param = { DBHelper.GetParameter("@productid", SqlDbType.Int, 4, "productid", productid) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows[0];
        }

        /// <summary>
        /// 获得若干数量的新商品
        /// </summary>
        /// <returns></returns>
        public DataTable getnewproductlist(int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products order by productid desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        /// 获得若干数量的特价商品
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable getspecialproductlist(int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products where Specials=true order by productid desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        /// 获得若干数量的推荐商品
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable getrecommendedproductlist(int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products where Recommended=1 order by productid desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }


        /// <summary>
        /// 获得若干数量的热卖商品
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable gethotsellproductlist(ref int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products order by SellCount desc,productid desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        /// 获得若干数量的热门商品
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable getpointproductlist(ref int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products order by PointCount desc,productid desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        ///更新商品的浏览数量 
        /// </summary>
        /// <param name="productid"></param>
        public void updatepointnum(int productid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Products set PointCount=PointCount+1 where productid=@productid");
            SqlParameter[] param = { DBHelper.GetParameter("@productid", SqlDbType.Int, 4, "productid", productid) };
            DBHelper.ExecuteSql(sb.ToString(), param);
        }

        /// <summary>
        /// 获得新商品
        /// </summary>
        /// <returns></returns>
        public DataTable getnewproduct()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select [ProductID],[ProductName],[TypeID_1],[TypeID_2],[Recommended],[Specials],[Price],");
            sb.Append("[UserPrice],[SpecialsPrice],[PointCount],[ImagePath],[Count],[SellCount],[Description] from Products order by ProductID desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        /// 获得特价商品
        /// </summary>
        /// <returns></returns>
        public DataTable getspecialproduct()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products where Specials=true order by productid desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }

        /// <summary>
        /// 获得推荐商品
        /// </summary>
        /// <returns></returns>
        public DataTable getrecommendedproduct()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select productid,ProductName,TypeID_1,TypeID_2,Recommended,Specials,Price,");
            sb.Append("UserPrice,SpecialsPrice,PointCount,ImagePath,[Count],SellCount,Description from Products where Recommended=true order by productid desc");
            return DBHelper.ExecuteDt(sb.ToString());
        }



        /// <summary>
        /// 查询商品
        /// </summary>
        /// <param name="type_1"></param>
        /// <param name="Type_2"></param>
        /// <param name="productname"></param>
        /// <param name="price_1"></param>
        /// <param name="price_2"></param>
        /// <returns></returns>
        public DataTable searchproductlist(int type_1, int type_2, string productname, string price_1, string price_2)
        {
            StringBuilder sb = new StringBuilder();
            List<SqlParameter> list = new List<SqlParameter>();
            sb.Append("SELECT Products.*, Type_2.typename AS typename_2, Type_1.typename AS typename_1 ");
            sb.Append("FROM Products, Type_2, Type_1 ");
            sb.Append("WHERE Products.TypeID_2=Type_2.TypeID_2 and Type_2.TypeID_1=Type_1.TypeID_1");
            if (type_1 != 0)
            {
                sb.Append(" and Type_2.TypeID_1=@TypeID_1 ");
                list.Add(DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "Type_2.TypeID_1", type_1));
            }
            if (type_2 != 0)
            {
                sb.Append(" and Type_2.TypeID_2=@TypeID_2");
                list.Add(DBHelper.GetParameter("@TypeID_2", SqlDbType.Int, 4, "Type_2.TypeID_2", type_2));
            }
            if (productname != "")
            {
                sb.Append(" and Products.ProductName like '%' + @ProductName + '%'");
                list.Add(DBHelper.GetParameter("@ProductName", SqlDbType.NVarChar, 50, "Products.ProductName", productname));
            }
            if (price_1 != "" && price_2 != "")
            {
                sb.Append(" and Products.Price between @Price_1 and @Price_2");
                list.Add(DBHelper.GetParameter("@Price_1", SqlDbType.Money, 8, "Products.Price", double.Parse(price_1)));
                list.Add(DBHelper.GetParameter("@Price_2", SqlDbType.Money, 8, "Products.Price", double.Parse(price_2)));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        #endregion

        public Products()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }   
    }
}