﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
/// <summary>
/// Reply 的摘要说明
/// </summary>
namespace BLL
{
    public class Reply
    {
        #region 增

        /// <summary>
        /// 添加一条回复
        /// </summary>
        /// <param name="RelayContent"></param>
        /// <param name="MsgID"></param>
        /// <param name="MUserID"></param>
        public int createrelay(String RelayContent, Int32 MsgID, Int32 MUserID)
        {
            SqlParameter[] param = { 
                DBHelper.GetParameter("@RelayContent",SqlDbType.NVarChar,1000,"RelayContent",RelayContent),
                DBHelper.GetParameter("@MsgID",SqlDbType.Int,4,"MsgID",MsgID),
                DBHelper.GetParameter("@MUserID",SqlDbType.Int,4,"MUserID",MUserID)};
            String sql = "Insert into Relay (RelayContent,MsgID,MUserID) values (@RelayContent,@MsgID,@MUserID)";
            return DBHelper.ExecuteSql(sql, param);
        }

        #endregion
        #region 删

        /// <summary>
        /// 删除一条回复
        /// </summary>
        /// <param name="RelayID"></param>
        public int deleterelay(int RelayID)
        {
            SqlParameter[] param = { DBHelper.GetParameter("@RelayID", SqlDbType.Int, 4, "RelayID", RelayID) };
            String sql = "delete from Relay where RelayID=@RelayID";
            return DBHelper.ExecuteSql(sql, param);
        }

        #endregion
        #region 改

        /// <summary>
        /// 更新回复
        /// </summary>
        /// <param name="MsgID"></param>
        /// <param name="RelayContent"></param>
        /// <param name="MUserID"></param>
        public int updaterelay(Int32 MsgID, String RelayContent, Int32 MUserID)
        {
            SqlParameter[] param = { 
                                   DBHelper.GetParameter("@RelayContent", SqlDbType.NVarChar, 1000, "RelayContent", RelayContent),
                                   DBHelper.GetParameter("@MUserID", SqlDbType.Int, 4, "MUserID", MUserID),
                                   DBHelper.GetParameter("@MsgID", SqlDbType.Int, 4, "MsgID", MsgID),
                                 };
            String sql = "Update Relay set RelayContent=@RelayContent,RelayTime=getdate(),MUserID=@MUserID where MsgID=@MsgID";
            return DBHelper.ExecuteSql(sql, param);
        }

        #endregion
        #region 查

        /// <summary>
        /// 留言是否有回复
        /// </summary>
        /// <param name="MsgID"></param>
        /// <returns></returns>
        public bool isRelay(int MsgID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select RelayID from Relay where MsgID=@MsgID");
            SqlParameter[] param = { 
                                   DBHelper.GetParameter("@MsgID", SqlDbType.Int, 4, "MsgID", MsgID),
                                 };
            return DBHelper.ExecuteDt(sb.ToString(), param).Rows.Count > 0 ? true : false;
        }
        /// <summary>
        /// 根据留言ID获得回复内容
        /// </summary>
        /// <param name="MsgID"></param>
        /// <returns></returns>
        public string getrelaybymessageid(int MsgID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select RelayContent from relay where MsgID=@MsgID");
            SqlParameter[] param = { 
                                   DBHelper.GetParameter("@MsgID", SqlDbType.Int, 4, "MsgID", MsgID),
                                 };
            return DBHelper.ExecuteDt(sb.ToString(), param).Rows[0]["RelayContent"].ToString();
        }

        #endregion

        public Reply()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }    
    }
}