﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SQLHelper;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
/// <summary>
/// Type_1 的摘要说明
/// </summary>
namespace BLL
{
    public class Type_1
    {
        #region 增

        /// <summary>
        /// 创建一个一级分类
        /// </summary>
        /// <param name="typename">一级分类名称</param>
        /// <returns></returns>
        public int createtype_1(string typename)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Type_1 ([TypeName]) values (@TypeName)");
            SqlParameter[] param = { DBHelper.GetParameter("@TypeName", SqlDbType.NVarChar, 50, "[TypeName]", typename) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 删

        /// <summary>
        /// 删除一级分类
        /// </summary>
        /// <param name="type_1">一级分类编号</param>
        /// <returns></returns>
        public int deletetype_1(int type_1)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Type_1 where [TypeID_1]=@TypeID_1");
            SqlParameter[] param = { DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "[TypeID_1]", type_1) };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 改

        /// <summary>
        /// 更新一级分类
        /// </summary>
        /// <param name="type_1">一级分类编号</param>
        /// <param name="typename">一级分类名称</param>
        /// <returns></returns>
        public int updatetype_1(int type_1, string typename)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update Type_1 set [TypeName]=@TypeName where [TypeID_1]=@TypeID_1");
            SqlParameter[] param = 
                                   { 
                                       DBHelper.GetParameter("@TypeName", SqlDbType.NVarChar, 50, "[TypeName]", typename),
                                       DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "[TypeID_1]", type_1)
                                     
                                   };
            return DBHelper.ExecuteSql(sb.ToString(), param);
        }

        #endregion

        #region 查

        /// <summary>
        /// 从第start-1条记录到第end条记录.
        /// </summary>
        /// <param name="start"></param>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable toplist(int start,int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " * from Type_1 ");
            sb.Append("where [TypeID_1] not in( select top " + start + " TypeID_1 from Type_1) order by TypeID_1");
            return DBHelper.ExecuteDt(sb.ToString());
        }
        /// <summary>
        /// 按升序取得产品类型前n个.
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable toplist(int num)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select top " + num + " * from Type_1 order by TypeID_1");
            return DBHelper.ExecuteDt(sb.ToString());
        }
        /// <summary>
        /// 根据类型名称查询商品一级分类
        /// </summary>
        /// <param name="typename"></param>
        /// <returns></returns>
        public DataTable type_1list(string typename)
        {
            List<SqlParameter> list = new List<SqlParameter>();
            StringBuilder sb = new StringBuilder();
            sb.Append("select [TypeID_1],[TypeName] from Type_1 where 1 = @index");

            list.Add(DBHelper.GetParameter("@index", SqlDbType.Int, 1));
            if (typename != "")
            {
                sb.Append(" and [TypeName] like '%' + @TypeName + '%'");
                list.Add(DBHelper.GetParameter("@TypeName", SqlDbType.NVarChar, 50, "[TypeName]", typename));
            }

            return DBHelper.ExecuteDt(sb.ToString(), list.ToArray());
        }

        /// <summary>
        /// 是否已经存在该分类
        /// </summary>
        /// <param name="typename"></param>
        /// <returns></returns>
        public bool IsExite(string typename)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select [TypeName] from Type_1 where [TypeName]=@TypeName");
            SqlParameter[] param = { DBHelper.GetParameter("@TypeName", SqlDbType.NVarChar, 50, "[TypeName]", typename) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows.Count > 0 ? true : false;
        }

        /// <summary>
        /// 根据类型ID获得类型名称
        /// </summary>
        /// <param name="typeid"></param>
        /// <returns></returns>
        public string gettypename(int typeid)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select [TypeName] from Type_1 where [TypeID_1]=@TypeID_1");
            SqlParameter[] param = { DBHelper.GetParameter("@TypeID_1", SqlDbType.Int, 4, "[TypeID_1]", typeid) };
            DataTable table = DBHelper.ExecuteDt(sb.ToString(), param);
            return table.Rows.Count > 0 ? table.Rows[0]["TypeName"].ToString() : " ";
        }

        #endregion

        public Type_1()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }     
    }
}