﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : CCL.BasePage
{
    BLL.News news = new BLL.News();
    BLL.Class_1 c_1 = new BLL.Class_1();
    BLL.Class_2 c_2 = new BLL.Class_2();
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "欢迎来到大气象学习园地";
        if (!IsPostBack)
        {
            Bind();
            InitData();
        }
    }
    protected void Bind()
    {
        DataView dv = news.getNewslist(0, 0, "").DefaultView;
        PagedDataSource pds = new PagedDataSource();

        AspNetPager1.RecordCount = dv.Count;
        pds.DataSource = dv;
        pds.AllowPaging = true;
        pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
        pds.PageSize = AspNetPager1.PageSize;

        this.Rpt_news.DataSource = pds;
        this.Rpt_news.DataBind();
    }
    protected void AspNetPager1_PageChanged(object src, EventArgs e)
    {
        Bind();
    }
    /// <summary>
    /// 绑定下拉框
    /// </summary>
    private void InitData()
    {
        DataTable dt = c_1.Class_1list("");
        ddl1.Items.Add(new ListItem("大类", "0"));
        ddl2.Items.Add(new ListItem("小类", "0"));
        foreach (DataRow dr in dt.Rows)
        {
            ddl1.Items.Add(new ListItem(dr["ClassName"].ToString(), dr["ClassID_1"].ToString()));
        }
    }
    protected void ddl1_SelectedIndexChanged(object sender, EventArgs e)
    {
        int id = Convert.ToInt32(ddl1.SelectedValue);
        DataTable dt = c_2.Class_2list(id, "");
        ddl2.Items.Clear();
        ddl2.Items.Add(new ListItem("小类", "0"));
        foreach (DataRow dr in dt.Rows)
        {
            ddl2.Items.Add(new ListItem(dr["Class_2name"].ToString(), dr["ClassID_2"].ToString()));
        }
    }
    protected void Btn_search_Click(object sender, EventArgs e)
    {
        Response.Redirect("New_List.aspx?class1=" + ddl1.SelectedValue + "&class2=" + ddl2.SelectedValue +
            "&key=" + Request.Form["keyword"]);
    }
}
