﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Order_List : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    BLL.Order ord = new BLL.Order();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (user.IsLogin() == true)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Member_Login.aspx");
        }
    }

    private void Bind()
    {
        DataTable table = ord.getordersbyuserid(user.getUserID());
        this.orderrepeater.DataSource = table.DefaultView;
        this.orderrepeater.DataBind();

        this.ordercountlabel.Text = this.orderrepeater.Items.Count.ToString();

        double pricecout = 0.0;

        foreach (RepeaterItem item in this.orderrepeater.Items)
        {
            pricecout += double.Parse((item.FindControl("orderpricelabel") as Label).Text);
        }

        this.pricecountlabel.Text = pricecout.ToString();
    }

    protected void orderrepeater_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.Item)
        {
            DataRowView drv = e.Item.DataItem as DataRowView;
            Label label = e.Item.FindControl("statelabel") as Label;
            LinkButton lb = e.Item.FindControl("opratelinkbutton") as LinkButton;
            switch (drv["state"].ToString())
            {
                case "0":
                    {
                        label.Text = "取消订单";
                        lb.Text = "恢复订单";
                        break;
                    }
                case "1":
                    {
                        label.Text = "等待发货";
                        lb.Text = "取消订单";
                        break;
                    }
                case "2":
                    {
                        label.Text = "商家已发货";
                        lb.Text = "确认收货";
                        break;
                    }
                case "3":
                    {
                        label.Text = "确认收货";
                        lb.Text = "等待完成";
                        break;
                    }
                case "4":
                    {
                        label.Text = "完成交易";
                        lb.Text = "交易完成";
                        lb.Enabled = false;
                        break;
                    }
            }
        }
    }

    protected void orderrepeater_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.CommandName == "canelorder")
        {
            RepeaterItem row = (RepeaterItem)((Control)e.CommandSource).Parent;

            int statecode = int.Parse((row.FindControl("statecode") as Label).Text);
            string orderid = (row.FindControl("orderidliteal") as Literal).Text;

            if (statecode == 0)
            {

                ord.updatestate(orderid, 1);
                this.Bind();
            }
            if (statecode == 1)
            {

                ord.updatestate(orderid, 0);
                this.Bind();
            }
            if (statecode == 2)
            {
                ord.updatestate(orderid, 3);
                this.Bind();
            }
            //if (statecode == 3)
            //{
            //    ord.updatestate(orderid, 4);
            //    this.Bind();
            //}
        }
    }
}
