﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Product_Info : System.Web.UI.Page
{
    BLL.Products pro = new BLL.Products();
    BLL.Type_1 t_1 = new BLL.Type_1();
    BLL.Type_2 t_2 = new BLL.Type_2();
    int nID = 0;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.Params["pid"] != null)
        {
            Title = "欢迎光临大气象学习园地！";
            string str = Request.Params["pid"].Replace("'", "");
            nID = Int32.Parse(str);
            if (!Page.IsPostBack)
            {
                if (nID > 0)
                {
                    this.Bind();
                    pro.updatepointnum(int.Parse(this.Request.QueryString["pid"].ToString()));
                }
                else
                {
                    Response.Write("<script>alert('请选择数据');history.back(1);</script>");
                    Response.End();
                }
            }
        }
        else
        {
            Response.Write("<script>alert('请选择数据');history.back(1);</script>");
            Response.End();
        }
    }

    private void Bind()
    {
        int pid = int.Parse(this.Request.QueryString["pid"].ToString());
        DataRow row = pro.getoneproduct(pid);
        this.productnameliteral.Text = row["productname"].ToString();
        this.IMG1.Src = "images/uploadfiles/" + row["imagepath"].ToString();
        this.type_1nameliteral.Text = t_1.gettypename(int.Parse(row["typeid_1"].ToString()));
        this.type_2nameliteral.Text = t_2.gettypename(int.Parse(row["typeid_2"].ToString()));
        this.pointcountliteral.Text = row["pointcount"].ToString();
        this.countliteral.Text = (int.Parse(row["count"].ToString()) > int.Parse(row["sellcount"].ToString())) ? row["count"].ToString() : "缺货";
        this.sellcountliteral.Text = row["sellcount"].ToString();
        this.priceliteral.Text = row["price"].ToString();
        this.userpriceliteral.Text = row["userprice"].ToString();
        this.specialsliteral.Text = row["specialsprice"].ToString();
        this.descriptionliteral.Text = row["description"].ToString();
        //绑定上一篇,下一篇
        if (pro.getpreProduct(nID) != "")
        {
            this.Hl_pre.NavigateUrl = "Product_Info.aspx?pid=" + pro.getpreProduct(nID);
        }
        else
            this.Hl_pre.Text = "没有上一产品";
        if (pro.getnextProduct(nID) != "")
        {
            this.Hl_next.NavigateUrl = "Product_Info.aspx?pid=" + pro.getnextProduct(nID);
        }
        else
            this.Hl_next.Text = "没有下一产品";
    }
    /// <summary>
    /// 添加到购物车
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void addcart_Click(object sender, ImageClickEventArgs e)
    {
        BLL.UserInfo user = new BLL.UserInfo();
        if (user.IsLogin() == true)
        {
            if (this.countliteral.Text.Trim() != "缺货")
            {
                BLL.Cart ocart = new BLL.Cart();
                if (ocart.isexitproduct(int.Parse(this.Request.QueryString["pid"].ToString()), user.getUserID()) == false)
                {
                    if (ocart.createcart(int.Parse(this.Request.QueryString["pid"].ToString()), user.getUserID(), 1, false) == 1)
                    {

                        Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('购物成功')</script>", false);
                    }
                    else
                    {
                        Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('购物失败')</script>", false);
                    }
                }
                else
                {
                    if (ocart.updatecart(int.Parse(this.Request.QueryString["pid"].ToString()), user.getUserID()) == 1)
                    {
                        Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('购物成功')</script>", false);
                    }
                    else
                    {
                        Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('购物失败')</script>", false);
                    }
                }
            }
            else
            {
                this.addcart.Enabled = false;
            }
        }
        else
        {
            Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "<script>alert('你还没有登陆')</script>", false);
        }
    }
}
