﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Admin_User : System.Web.UI.Page
{
    BLL.UserInfo user = new BLL.UserInfo();
    protected void Page_Load(object sender, EventArgs e)
    {
        Title = "用户管理";
        if (user.IsLogin() == true && user.getUserRole() == 2)
        {
            if (!this.IsPostBack)
            {
                this.Bind();
            }
        }
        else
        {
            this.Response.Redirect("Admin_Login.aspx");
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        if (this.IsValid)
        {
            string admin = Request["UserName"].ToString();
            string pwd = FormsAuthentication.HashPasswordForStoringInConfigFile(Request["UserPwd"].ToString().Trim(), "MD5");
            user.createUser(admin, pwd, 2, "", "", "");
            Response.Write("<script language=javascript>window.alert('添加成功！');window.location.href='Admin_User.aspx';</script>");   
        }
    }
    public bool findAdmin(string UserName)
    {
        return user.IsExist(UserName);
    }
    protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
    {
        string UserName = args.Value;
        if (findAdmin(UserName))
        {
            args.IsValid = false;
        }
        else
        {
            args.IsValid = true;
        }
    }

    protected void Bind()
    {
        GVadmin.DataSource = user.getUserlist("", 2);
        GVadmin.DataBind();
    }
    protected void GVadmin_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        //取消
        GVadmin.EditIndex = -1;
        Bind();
    }
    protected void GVadmin_RowEditing(object sender, GridViewEditEventArgs e)
    {
        GVadmin.EditIndex = e.NewEditIndex;
        Bind();
    }
    protected void GVadmin_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //这里有个ListItem判断
        e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#1e90ff'");
        e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        //这一步判断不可省
        if (e.Row.DataItem == null)
        {
            return;
        }
        ((LinkButton)(e.Row.FindControl("LinkButton3"))).Attributes.Add("onclick", "return confirm('确认删除?')");
    }
    protected void GVadmin_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GVadmin.PageIndex = e.NewPageIndex;
        Bind();
    }
    protected void GVadmin_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        Label id = this.GVadmin.Rows[e.RowIndex].FindControl("LBid") as Label;
        TextBox TBpwd = this.GVadmin.Rows[e.RowIndex].FindControl("TBpwd") as TextBox;
        string pwd = FormsAuthentication.HashPasswordForStoringInConfigFile(TBpwd.Text.ToString().Trim(), "MD5");
        user.updateUserPassword(Convert.ToInt32(id.Text.ToString()), pwd);
        GVadmin.EditIndex = -1;
        Bind();
    }
    protected void GVadmin_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Label id = this.GVadmin.Rows[e.RowIndex].FindControl("LBid") as Label;
        user.deleteUser(Convert.ToInt32(id.Text.ToString()));
        Response.Write("<script language=javascript>window.alert('删除成功！');window.location.href='Admin_User.aspx';</script>"); 
    }
}
