using System;
using System.Collections.Generic;
using System.Text;
using Model;
using System.Data.Common;
namespace ImpDDal
{
    public class ImpItemType:DbCommandStore,IDDal.ItemTypeDal<ItemType>
    {
        #region ItemTypeDal<ItemType> Ա
        DbCommand cmd = GetCommand();

        #region һ
        public int AddItemType(ItemType itemtype)
        {
            cmd.CommandText = "INSERT INTO UT_ItemType(TypeName) VALUES(@TN)";
            cmd.Parameters.Add(itemtype.TypeName);
            try
            {
                cmd.Connection.Open();
                return cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                throw new Exception("Ӳʧ" + ex.Message);
            }
            finally
            {
                cmd.Connection.Close();
            }
        }
        #endregion

        #region ɾһ
        public int DelteItemType(ItemType itemtype)
        {
            cmd.CommandText = "DELETE FROM UT_ItemType WHERE ItemTypeId=@ID";
            cmd.Parameters.Add(itemtype.ItemTypeId);
            try
            {
                cmd.Connection.Open();
                return cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                throw new Exception("ɾʧ" + ex.Message);
            }
            finally
            {
                cmd.Connection.Close();
            }
        }
        #endregion

        #region ༭һ
        public int EditItemType(ItemType itemtype)
        {
            cmd.CommandText = "UPDATE UT_ItemType SET TypeName=@TN WHERE ItemTypeId=@ID";
            cmd.Parameters.Add(itemtype.TypeName);
            cmd.Parameters.Add(itemtype.ItemTypeId);
            try
            {
                cmd.Connection.Open();
                return cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                throw new Exception("²ʧ" + ex.Message);
            }
            finally
            {
                cmd.Connection.Close();
            }
        }
        #endregion

        #region ز
        public IList<ItemType> ItemTypes()
        {
            cmd.CommandText = "SELECT * FROM UT_ItemType";
            try
            {
                if(cmd.Connection.State==System.Data.ConnectionState.Closed)
                cmd.Connection.Open();
                DbDataReader reader = cmd.ExecuteReader(System.Data.CommandBehavior.CloseConnection);
                List<ItemType> list = new List<ItemType>();
                ItemType itemtype=null;
                while (reader.Read())
                {
                    itemtype=new ItemType(int.Parse(reader.GetValue(0).ToString()),reader.GetString(1));
                    list.Add(itemtype);
                }
                return list;
            }
            catch (Exception ex)
            {
                throw new Exception("ѯʧ" + ex.Message);
            }
            finally
            {
                cmd.Connection.Close();
            }
        }
        #endregion

        #endregion
    }
}
