using System;
using System.Collections.Generic;
using System.Text;
using IDDal;
using System.Data.Common;
using Model;
using System.Data;
using System.Data.SqlClient;

namespace ImpDDal
{
    public class ImpOrder:DbCommandStore,IOrder<Order>
    {
        #region IOrder<Order> Ա
        DbCommand cmd = GetCommand();

        #region һ
        public int NewOrder(Model.Order order,out string guid)
        {
            cmd.CommandType = System.Data.CommandType.StoredProcedure;
            cmd.CommandText = "SP_NewOrder";
            SqlParameter[] p = new SqlParameter[6];
            p[0] = new System.Data.SqlClient.SqlParameter("menuId", order.Menuid);
            p[1] = new System.Data.SqlClient.SqlParameter("number",order.Number);
            p[2] = new System.Data.SqlClient.SqlParameter("loginName", order.LoginName);
            p[3] = new System.Data.SqlClient.SqlParameter("actionTime", order.ActionTime);
            p[4] = new System.Data.SqlClient.SqlParameter("mark", order.Mark);
            p[5] = new System.Data.SqlClient.SqlParameter("orderguid",SqlDbType.UniqueIdentifier);
            p[5].Direction = ParameterDirection.Output;

            cmd.Parameters.Add(p[0]);
            cmd.Parameters.Add(p[1]);
            cmd.Parameters.Add(p[2]);
            cmd.Parameters.Add(p[3]);
            cmd.Parameters.Add(p[4]);
            cmd.Parameters.Add(p[5]);

            try
            {
                if (cmd.Connection.State == ConnectionState.Closed)
                    cmd.Connection.Open();
                int i = cmd.ExecuteNonQuery();
                guid = cmd.Parameters[5].Value.ToString();
                return i;
            }
            catch (Exception ex)
            {

                throw new Exception("ʧ", ex);
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }

        }
        #endregion

        #region ж¼
        public IList<Order> OrderList()
        {
            cmd.CommandText = "SELECT * FROM UT_Order";
            IList<Order> list = new List<Order>();
            Order order = null;
            try
            {
                if (cmd.Connection.State == ConnectionState.Closed)
                    cmd.Connection.Open();
                DbDataReader reader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                while (reader.Read())
                {
                    order = new Order(reader.GetGuid(0).ToString(), reader.GetString(1), int.Parse(reader.GetValue(2).ToString()), reader.GetString(3), reader.GetDateTime(4), reader.GetString(5), reader.GetString(6));
                    list.Add(order);
                }
                return list;
            }
            catch (Exception ex)
            {
                throw new Exception("ѯʧ",ex);
            }
        }
        #endregion

        #region ʼʱͽʱѯ¼
        public IList<Order> OrderList(DateTime startTime, DateTime endTime)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        #endregion

        #region ݶ߲ѯ
        public IList<Order> OrderList(string createId)
        {
            cmd.CommandText = "SELECT * FROM UV_Order WHERE LoginName=@LN ORDER BY ActionTime DESC";
            SqlParameter p = new SqlParameter("LN", createId);
            cmd.Parameters.Add(p);
            IList<Order> list = new List<Order>();
            Order order = null;
            try
            {
                if (cmd.Connection.State == ConnectionState.Closed)
                    cmd.Connection.Open();
                DbDataReader reader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                while (reader.Read())
                {
                    order = new Order(reader.GetGuid(0).ToString(), reader.GetGuid(1).ToString(), int.Parse(reader.GetValue(2).ToString()), reader.GetString(3), reader.GetDateTime(4), reader.GetString(5), reader.GetString(6),new MenuType(reader.GetString(7),reader.GetString(8)));
                    list.Add(order);
                }
                return list;
            }
            catch (Exception ex)
            {
                throw new Exception("ѯʧ", ex);
            }
            finally
            {
                cmd.Parameters.Clear();
                cmd.Connection.Close();
            }
        }
        #endregion


        public IList<Order> OrderList(string createId, DateTime startTime, DateTime endTime)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        #endregion
    }
}
