﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Business;
using Model;
using System.Text;
/// <summary>
/// 菜单信息的展现层处理
/// </summary>
public class EMenuType
{
    BMenuType bMenuTypeOp = new BMenuType();
    /// <summary>
    /// 虚构函数
    /// </summary>
    public EMenuType()
    {
        //
        // TODO: 在此处添加构造函数逻辑
        //
    }
    /// <summary>
    /// 返回管理员定制的菜单
    /// </summary>
    /// <returns>菜单集合列表</returns>
    public IList<MenuType> GetAdminType()
    {
        try
        {
            return bMenuTypeOp.SelectMenuType("1");
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return null;
        }
    }
    /// <summary>
    /// 返回所有用户定制的菜单
    /// </summary>
    /// <returns>菜单集合列表</returns>
    public IList<MenuType> GetCustomerMenuType()
    {
        try
        {
            return bMenuTypeOp.SelectMenuType("0");
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return null;
        }
    }
    /// <summary>
    /// 返回当前用户定制的菜单
    /// </summary>
    /// <returns>菜单集合列表</returns>
    public IList<MenuType> GetMyType()
    {
        if (HttpContext.Current.User.Identity.IsAuthenticated)
        {
            try
            {
                return bMenuTypeOp.SelectMenuType("0", HttpContext.Current.User.Identity.Name);
            }
            catch (Exception ex)
            {
                WebConvert.JScript.JsAlert(ex.Message);
                return null;
            }
        }
        else
            return null;
    }
    /// <summary>
    /// 返回当前用户定制的菜单(AJAX,每一行用|分割,一列用*分割)
    /// </summary>
    /// <returns>菜单集合列表字符串</returns>
    public string GetMyTypeForAjax()
    {
        StringBuilder txt=new StringBuilder();
        if (HttpContext.Current.User.Identity.IsAuthenticated)
        {
            try
            {
                IList<MenuType> list=bMenuTypeOp.SelectMenuType("0", HttpContext.Current.User.Identity.Name);
                foreach (MenuType _menutype in list)
                {
                    txt.Append(_menutype.MenuId + "*" + _menutype.MenuName +"|");
                }
                return txt.ToString();
            }
            catch (Exception ex)
            {
                WebConvert.JScript.JsAlert(ex.Message);
                return String.Empty;
            }
            
        }
        else
            return String.Empty;
    }
    /// <summary>
    /// 返回管理员定制的菜单(AJAX,每一行用|分割,一列用*分割)
    /// </summary>
    /// <returns>菜单集合列表字符串</returns>
    public string GetAdminTypeForAjax()
    {
        StringBuilder txt = new StringBuilder();
        if (HttpContext.Current.User.Identity.IsAuthenticated)
        {
            try
            {
                IList<MenuType> list=bMenuTypeOp.SelectMenuType("1");
                foreach (MenuType _menutype in list)
                {
                    txt.Append(_menutype.MenuId + "*" + _menutype.MenuName+"|");
                }
                return txt.ToString();
            }
            catch (Exception ex)
            {
                WebConvert.JScript.JsAlert(ex.Message);
                return null;
            }
        }
        else
            return null;
    }
    /// <summary>
    /// 增加一个菜单的操作
    /// </summary>
    /// <param name="itemsList">菜单所含菜的字符串集合</param>
    /// <param name="title">菜单名称</param>
    /// <param name="detail">详细备注</param>
    /// <returns>1表示增加成功,0表示增加失败</returns>
    public int AddMenu(string itemsList, string title, string detail)
    {
        MenuType menuType = new MenuType(title, HttpContext.Current.User.IsInRole("admin")==true? "1":"0" , HttpContext.Current.User.Identity.Name, detail);
        string[] items=itemsList.Split(new char[] {','});
        IList<Model.Menu> list = new List<Model.Menu>();
        Model.Menu oneMenu = null;
        string menuId=string.Empty;
        try
        {
            menuId=bMenuTypeOp.AddMenuType(menuType);
            for (int i = 0; i < items.Length - 1; i++)
            {
                oneMenu = new Model.Menu(menuId, items[i]);
                list.Add(oneMenu);
            }
            EMenus menuop = new EMenus();
            return menuop.AddMenu(list);
        }
        catch (Exception ex)
        {
            MenuType temp=new MenuType(menuId);
            bMenuTypeOp.DeleteMenuType(temp);
            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }
       
    }
    /// <summary>
    /// 修改当前菜单
    /// </summary>
    /// <param name="menuId">菜单号</param>
    /// <param name="itemsList">菜单所含菜肴</param>
    /// <param name="title">菜单名</param>
    /// <param name="detail">详细信息</param>
    /// <returns>1表示修改成功,0表示修改失败</returns>
    public int EditMenu(string menuId,string itemsList, string title, string detail)
    {
        MenuType menuType = new MenuType(title, HttpContext.Current.User.IsInRole("admin") == true ? "1" : "0", HttpContext.Current.User.Identity.Name, detail);
        Model.Menu oldMenu = new Model.Menu(menuId);
        menuType.MenuId = menuId;
        string[] items = itemsList.Split(new char[] { ',' });
        IList<Model.Menu> list = new List<Model.Menu>();
        Model.Menu oneMenu = null;
        try
        {
            bMenuTypeOp.ModifyMenuType(menuType);
            for (int i = 0; i < items.Length - 1; i++)
            {
                oneMenu = new Model.Menu(menuId, items[i]);
                list.Add(oneMenu);
            }
            BMenu menuop = new BMenu();
            return menuop.ModifyMenu(list, oldMenu);
        }
        catch (Exception ex)
        {
            WebConvert.JScript.JsAlert(ex.Message);
            return 0;
        }

    }
    /// <summary>
    /// 获取指定菜单号的菜单信息,包括菜肴(AJAX,每一个菜肴用|分割,每个菜肴内的项目用*分割)
    /// </summary>
    /// <param name="menuId">菜单号</param>
    /// <returns>菜单详细信息字符串</returns>
    public string GetDetailMenu(string menuId)
    {
        StringBuilder txt = new StringBuilder();
        MenuType menuType = bMenuTypeOp.ShowOneMenu(menuId);
        IList<Item> list = menuType.Menuitems;
        foreach (Item item in list)
        {
            txt.Append(item.ItemName + "*" + item.Price + "*" + item.SystemId +"*" +item.Pic + "|");
        }
        return txt.ToString();
    }
    /// <summary>
    /// 获取菜单信息
    /// </summary>
    /// <param name="menuId">菜单号</param>
    /// <returns>菜单信息字符串</returns>
    public string GetDetailMenuInfo(string menuId)
    {
        StringBuilder txt = new StringBuilder();
        MenuType menuType = bMenuTypeOp.ShowOneMenu(menuId);
        txt.Append(menuType.MenuName + "*" + menuType.Detail);
        return txt.ToString();
    }

    public IList<MenuType> GetHotMenu()
    {
        return bMenuTypeOp.GetHotMenu();
    }

}
